/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.commands;

import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.commands.handlers.ListExtensionsCommandHandler;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.devtools.project.extensions.ExtensionManager;
import io.quarkus.platform.tools.ToolsUtils;
import java.util.HashMap;
import java.util.Objects;

public class ListExtensions {
    public static final String NAME = "list-extensions";
    private static final String PARAM_PREFIX = ToolsUtils.dotJoin("quarkus", "list-extensions");
    public static final String ALL = ToolsUtils.dotJoin(PARAM_PREFIX, "all");
    public static final String INSTALLED = ToolsUtils.dotJoin(PARAM_PREFIX, "installed");
    public static final String FROM_CLI = ToolsUtils.dotJoin(PARAM_PREFIX, "fromCli");
    public static final String FORMAT = ToolsUtils.dotJoin(PARAM_PREFIX, "format");
    public static final String SEARCH = ToolsUtils.dotJoin(PARAM_PREFIX, "search");
    public static final String EXTENSION_MANAGER = ToolsUtils.dotJoin(PARAM_PREFIX, "extension-manager");
    private final QuarkusCommandInvocation invocation;
    private final ListExtensionsCommandHandler handler = new ListExtensionsCommandHandler();

    public ListExtensions(QuarkusProject quarkusProject) {
        this.invocation = new QuarkusCommandInvocation(quarkusProject);
    }

    public ListExtensions(QuarkusProject quarkusProject, MessageWriter messageWriter) {
        this.invocation = new QuarkusCommandInvocation(quarkusProject, new HashMap<String, Object>(), messageWriter);
    }

    public ListExtensions all(boolean all) {
        this.invocation.setValue(ALL, all);
        return this;
    }

    public ListExtensions installed(boolean installed) {
        this.invocation.setValue(INSTALLED, installed);
        return this;
    }

    public ListExtensions fromCli(boolean cli) {
        this.invocation.setValue(FROM_CLI, cli);
        return this;
    }

    public ListExtensions format(String format) {
        this.invocation.setValue(FORMAT, format);
        return this;
    }

    public ListExtensions extensionManager(ExtensionManager extensionManager) {
        this.invocation.setValue(EXTENSION_MANAGER, Objects.requireNonNull(extensionManager, "extensionManager is required"));
        return this;
    }

    public ListExtensions search(String search) {
        this.invocation.setValue(SEARCH, search);
        return this;
    }

    public QuarkusCommandOutcome execute() throws QuarkusCommandException {
        return this.handler.execute(this.invocation);
    }
}

