/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.commands.handlers;

import io.quarkus.devtools.commands.RemoveExtensions;
import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.commands.handlers.QuarkusCommandHandler;
import io.quarkus.devtools.commands.handlers.QuarkusCommandHandlers;
import io.quarkus.devtools.messagewriter.MessageIcons;
import io.quarkus.devtools.project.extensions.ExtensionManager;
import io.quarkus.maven.ArtifactCoords;
import io.quarkus.maven.ArtifactKey;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class RemoveExtensionsCommandHandler
implements QuarkusCommandHandler {
    @Override
    public QuarkusCommandOutcome execute(QuarkusCommandInvocation invocation) throws QuarkusCommandException {
        Set<String> extensionsQuery = invocation.getValue(RemoveExtensions.EXTENSIONS, Collections.emptySet());
        if (extensionsQuery.isEmpty()) {
            return (QuarkusCommandOutcome)QuarkusCommandOutcome.success().setValue(RemoveExtensions.OUTCOME_UPDATED, false);
        }
        List<ArtifactCoords> extensionsToRemove = QuarkusCommandHandlers.computeCoordsFromQuery(invocation, extensionsQuery);
        if (extensionsToRemove == null) {
            return (QuarkusCommandOutcome)new QuarkusCommandOutcome(false).setValue(RemoveExtensions.OUTCOME_UPDATED, false);
        }
        ExtensionManager extensionManager = invocation.getValue(RemoveExtensions.EXTENSION_MANAGER, invocation.getQuarkusProject().getExtensionManager());
        try {
            Set<ArtifactKey> keys = extensionsToRemove.stream().map(ArtifactCoords::getKey).collect(Collectors.toSet());
            ExtensionManager.UninstallResult result = extensionManager.uninstall(keys);
            result.getUninstalled().forEach(a -> invocation.log().info(MessageIcons.OK_ICON + " Extension " + a.getGroupId() + ":" + a.getArtifactId() + " has been uninstalled"));
            return (QuarkusCommandOutcome)new QuarkusCommandOutcome(true).setValue(RemoveExtensions.OUTCOME_UPDATED, result.isSourceUpdated());
        }
        catch (IOException e) {
            throw new QuarkusCommandException("Failed to remove extensions", e);
        }
    }
}

