/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.update;

import io.quarkus.devtools.project.state.TopExtensionDependency;
import io.quarkus.devtools.project.update.ExtensionUpdateInfo;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.registry.catalog.Extension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

final class ExtensionMapBuilder {
    final Map<String, List<ExtensionUpdateInfoBuilder>> extensionInfo;
    final List<ExtensionUpdateInfoBuilder> list = new ArrayList<ExtensionUpdateInfoBuilder>();

    public ExtensionMapBuilder() {
        this.extensionInfo = new LinkedHashMap<String, List<ExtensionUpdateInfoBuilder>>();
    }

    public ExtensionMapBuilder(int size) {
        this.extensionInfo = new LinkedHashMap<String, List<ExtensionUpdateInfoBuilder>>(size);
    }

    public void add(ExtensionUpdateInfoBuilder e) {
        this.extensionInfo.put(e.currentDep.getArtifact().getArtifactId(), Collections.singletonList(e));
        this.list.add(e);
    }

    public ExtensionUpdateInfoBuilder get(ArtifactKey key) {
        List<ExtensionUpdateInfoBuilder> list = this.extensionInfo.get(key.getArtifactId());
        if (list == null || list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        for (ExtensionUpdateInfoBuilder e : list) {
            TopExtensionDependency recommendedDep = e.resolveRecommendedDep();
            if (!e.currentDep.getKey().equals(key) && (recommendedDep == null || !recommendedDep.getKey().equals(key))) continue;
            return e;
        }
        throw new IllegalArgumentException(String.valueOf(key) + " isn't found in the extension map");
    }

    public Collection<ExtensionUpdateInfoBuilder> values() {
        return this.list;
    }

    public int size() {
        return this.extensionInfo.size();
    }

    public boolean isEmpty() {
        return this.extensionInfo.isEmpty();
    }

    public static final class ExtensionUpdateInfoBuilder {
        private final TopExtensionDependency currentDep;
        private Extension recommendedMetadata;
        private TopExtensionDependency recommendedDep;
        private Extension latestMetadata;

        public ExtensionUpdateInfoBuilder(TopExtensionDependency currentDep) {
            this.currentDep = currentDep;
        }

        public TopExtensionDependency getCurrentDep() {
            return this.currentDep;
        }

        public Extension getRecommendedMetadata() {
            return this.recommendedMetadata;
        }

        public void setRecommendedMetadata(Extension e) {
            this.recommendedMetadata = e;
        }

        public ExtensionUpdateInfoBuilder setRecommendedDep(TopExtensionDependency recommendedDep) {
            this.recommendedDep = recommendedDep;
            return this;
        }

        public ExtensionUpdateInfo build() {
            TopExtensionDependency effectiveRecommendedDep = this.resolveRecommendedDep();
            return new ExtensionUpdateInfo(this.currentDep, effectiveRecommendedDep.getCatalogMetadata(), effectiveRecommendedDep);
        }

        public TopExtensionDependency resolveRecommendedDep() {
            if (this.recommendedDep != null) {
                return this.recommendedDep;
            }
            return this.recommendedMetadata == null ? this.currentDep : TopExtensionDependency.builder().setArtifact(this.recommendedMetadata.getArtifact()).setCatalogMetadata(this.recommendedMetadata).setTransitive(this.currentDep.isTransitive()).build();
        }

        public Extension getLatestMetadata() {
            return this.latestMetadata;
        }

        public ExtensionUpdateInfoBuilder setLatestMetadata(Extension latestMetadata) {
            this.latestMetadata = latestMetadata;
            return this;
        }
    }
}

