/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.elytron.security.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.elytron.security.deployment.ElytronPasswordMarkerBuildItem;
import io.quarkus.elytron.security.deployment.ElytronTokenMarkerBuildItem;
import io.quarkus.elytron.security.deployment.SecurityDomainBuildItem;
import io.quarkus.elytron.security.deployment.SecurityRealmBuildItem;
import io.quarkus.elytron.security.runtime.DefaultRoleDecoder;
import io.quarkus.elytron.security.runtime.ElytronPasswordIdentityProvider;
import io.quarkus.elytron.security.runtime.ElytronRecorder;
import io.quarkus.elytron.security.runtime.ElytronSecurityDomainManager;
import io.quarkus.elytron.security.runtime.ElytronTokenIdentityProvider;
import io.quarkus.elytron.security.runtime.ElytronTrustedIdentityProvider;
import io.quarkus.runtime.RuntimeValue;
import java.util.List;
import org.jboss.logging.Logger;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;

class ElytronDeploymentProcessor {
    private static final Logger log = Logger.getLogger((String)ElytronDeploymentProcessor.class.getName());

    ElytronDeploymentProcessor() {
    }

    @BuildStep
    void addBeans(BuildProducer<AdditionalBeanBuildItem> beans, List<ElytronPasswordMarkerBuildItem> pw, List<ElytronTokenMarkerBuildItem> token) {
        beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(ElytronSecurityDomainManager.class));
        beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(DefaultRoleDecoder.class));
        if (!token.isEmpty()) {
            beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(ElytronTokenIdentityProvider.class));
        }
        if (!pw.isEmpty()) {
            beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(ElytronPasswordIdentityProvider.class));
            beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(ElytronTrustedIdentityProvider.class));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    SecurityDomainBuildItem build(ElytronRecorder recorder, List<SecurityRealmBuildItem> realms) throws Exception {
        if (realms.size() > 0) {
            SecurityRealmBuildItem realmBuildItem = realms.get(0);
            RuntimeValue securityDomainBuilder = recorder.configureDomainBuilder(realmBuildItem.getName(), realmBuildItem.getRealm());
            for (int n = 1; n < realms.size(); ++n) {
                realmBuildItem = realms.get(n);
                RuntimeValue<SecurityRealm> realm = realmBuildItem.getRealm();
                recorder.addRealm(securityDomainBuilder, realmBuildItem.getName(), realm);
            }
            RuntimeValue securityDomain = recorder.buildDomain(securityDomainBuilder);
            return new SecurityDomainBuildItem((RuntimeValue<SecurityDomain>)securityDomain);
        }
        return null;
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void identityManager(ElytronRecorder recorder, SecurityDomainBuildItem securityDomain, BeanContainerBuildItem bc) {
        if (securityDomain != null) {
            recorder.setDomainForIdentityProvider(bc.getValue(), securityDomain.getSecurityDomain());
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void loadRealm(ElytronRecorder recorder, List<SecurityRealmBuildItem> realms) throws Exception {
        for (SecurityRealmBuildItem realm : realms) {
            if (realm.getRuntimeLoadTask() == null) continue;
            recorder.runLoadTask(realm.getRuntimeLoadTask());
        }
    }
}

