/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.elytron.security.runtime;

import io.quarkus.elytron.security.runtime.ElytronAccount;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.idm.PasswordCredential;
import org.jboss.logging.Logger;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;

public class ElytronIdentityManager
implements IdentityManager {
    private static Logger log = Logger.getLogger(ElytronIdentityManager.class);
    private final SecurityDomain domain;

    public ElytronIdentityManager(SecurityDomain domain) {
        this.domain = domain;
    }

    public Account verify(Account account) {
        return account;
    }

    public Account verify(String id, Credential credential) {
        block5: {
            log.debugf("verify, id=%s, credential=%s", (Object)id, (Object)credential);
            try {
                if (!(credential instanceof PasswordCredential)) break block5;
                PasswordCredential passwordCredential = (PasswordCredential)credential;
                try {
                    SecurityIdentity result = this.domain.authenticate(id, (Evidence)new PasswordGuessEvidence(passwordCredential.getPassword()));
                    log.debugf("authenticate, id=%s, result=%s", (Object)id, (Object)result);
                    if (result != null) {
                        return new ElytronAccount(result);
                    }
                }
                catch (RealmUnavailableException e) {
                    log.debugf((Throwable)e, "failed, id=%s, credential=%s", (Object)id, (Object)credential);
                }
            }
            catch (Exception e) {
                log.warnf((Throwable)e, "Failed to verify id=%s", (Object)id);
            }
        }
        return null;
    }

    public Account verify(Credential credential) {
        return null;
    }
}

