/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.elytron.security.runtime;

import io.quarkus.elytron.security.runtime.SecurityContextPrincipal;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.CDI;

public class SecurityContextPrincipalHandler
implements HttpHandler {
    private final HttpHandler next;

    public SecurityContextPrincipalHandler(HttpHandler next) {
        this.next = next;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        Account account = exchange.getSecurityContext().getAuthenticatedAccount();
        if (account != null && account.getPrincipal() != null) {
            SecurityContextPrincipal contextPrincipal = (SecurityContextPrincipal)CDI.current().select(SecurityContextPrincipal.class, new Annotation[0]).get();
            contextPrincipal.setContextPrincipal(account.getPrincipal());
        }
        this.next.handleRequest(exchange);
    }
}

