/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.funqy.runtime.query;

import io.quarkus.arc.impl.Reflections;
import io.quarkus.funqy.runtime.query.QueryListReader;
import io.quarkus.funqy.runtime.query.QueryMapReader;
import io.quarkus.funqy.runtime.query.QueryObjectReader;
import io.quarkus.funqy.runtime.query.QueryPropertySetter;
import io.quarkus.funqy.runtime.query.QueryReader;
import io.quarkus.funqy.runtime.query.QuerySetReader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class QueryObjectMapper {
    Map<Class, QueryObjectReader> readers = new HashMap<Class, QueryObjectReader>();

    Function<String, Object> extractor(Type type) {
        return this.extractor(Reflections.getRawType((Type)type));
    }

    Function<String, Object> extractor(Class clz) {
        if (String.class.equals((Object)clz)) {
            return strVal -> strVal;
        }
        if (clz.equals(Long.TYPE) || clz.equals(Long.class)) {
            return strVal -> Long.valueOf(strVal);
        }
        if (clz.equals(Integer.TYPE) || clz.equals(Integer.class)) {
            return strVal -> Integer.valueOf(strVal);
        }
        if (clz.equals(Short.TYPE) || clz.equals(Short.class)) {
            return strVal -> Short.valueOf(strVal);
        }
        if (clz.equals(Float.TYPE) || clz.equals(Float.class)) {
            return strVal -> Float.valueOf(strVal);
        }
        if (clz.equals(Double.TYPE) || clz.equals(Double.class)) {
            return strVal -> Double.valueOf(strVal);
        }
        if (clz.equals(Boolean.TYPE) || clz.equals(Boolean.class)) {
            return strVal -> Boolean.valueOf(strVal);
        }
        if (clz.equals(Byte.TYPE) || clz.equals(Byte.class)) {
            return strVal -> Byte.valueOf(strVal);
        }
        if (clz.equals(OffsetDateTime.class)) {
            return strVal -> OffsetDateTime.parse(strVal);
        }
        return null;
    }

    public <T> QueryReader<T> readerFor(Class<T> clz) {
        return this.readerFor(clz, null);
    }

    public QueryReader readerFor(Type type) {
        Class clazz = null;
        if (type instanceof Class) {
            clazz = (Class)type;
        } else if (type instanceof ParameterizedType) {
            clazz = (Class)((ParameterizedType)type).getRawType();
        } else {
            throw new RuntimeException("Cannot get QueryReader for: " + type);
        }
        return this.readerFor(clazz, type);
    }

    public <T> QueryReader<T> readerFor(Class<T> clz, Type genericType) {
        if (clz.equals(Map.class)) {
            return new QueryMapReader(genericType, this);
        }
        QueryObjectReader reader = this.readers.get(clz);
        if (reader != null) {
            return reader;
        }
        reader = new QueryObjectReader(clz, this);
        this.readers.put(clz, reader);
        return reader;
    }

    QueryPropertySetter setterFor(Class clz, Type genericType) {
        if (clz.equals(List.class)) {
            return new QueryListReader(genericType, this);
        }
        if (clz.equals(Set.class)) {
            return new QuerySetReader(genericType, this);
        }
        return (QueryPropertySetter)((Object)this.readerFor(clz, genericType));
    }
}

