/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.ArcInvocationContext;
import io.quarkus.arc.impl.ContextDataMap;
import io.quarkus.arc.impl.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;

abstract class AbstractInvocationContext
implements ArcInvocationContext {
    private static final Object[] EMPTY_PARAMS = new Object[0];
    protected Object target;
    protected Object[] parameters;
    protected ContextDataMap contextData;

    protected AbstractInvocationContext(Object target, Object[] parameters, ContextDataMap contextData) {
        this.target = target;
        this.parameters = parameters != null ? parameters : EMPTY_PARAMS;
        this.contextData = contextData;
    }

    @Override
    public Map<String, Object> getContextData() {
        return this.contextData;
    }

    @Override
    public <T extends Annotation> T findIterceptorBinding(Class<T> annotationType) {
        for (Annotation annotation : this.getInterceptorBindings()) {
            if (!annotation.annotationType().equals(annotationType)) continue;
            return (T)annotation;
        }
        return null;
    }

    @Override
    public <T extends Annotation> List<T> findIterceptorBindings(Class<T> annotationType) {
        ArrayList<Annotation> found = new ArrayList<Annotation>();
        for (Annotation annotation : this.getInterceptorBindings()) {
            if (!annotation.annotationType().equals(annotationType)) continue;
            found.add(annotation);
        }
        return found;
    }

    static void validateParameters(Executable executable, Object[] params) {
        int newParametersCount = Objects.requireNonNull(params).length;
        Object[] parameterTypes = executable.getParameterTypes();
        if (parameterTypes.length != newParametersCount) {
            throw new IllegalArgumentException("Wrong number of parameters - method has " + Arrays.toString(parameterTypes) + ", attempting to set " + Arrays.toString(params));
        }
        for (int i = 0; i < params.length; ++i) {
            if (((Class)parameterTypes[i]).isPrimitive() && params[i] == null) {
                throw new IllegalArgumentException("Trying to set a null value to a primitive parameter [position: " + i + ", type: " + (Class)parameterTypes[i] + "]");
            }
            if (params[i] == null || Types.boxedClass(parameterTypes[i]).isAssignableFrom(Types.boxedClass(params[i].getClass()))) continue;
            throw new IllegalArgumentException("The parameter type [" + params[i].getClass() + "] can not be assigned to the type for the target method [" + (Class)parameterTypes[i] + "]");
        }
    }

    @Override
    public Method getMethod() {
        return null;
    }

    @Override
    public Object getTarget() {
        return this.target;
    }

    @Override
    public Object getTimer() {
        return null;
    }

    @Override
    public Constructor<?> getConstructor() {
        return null;
    }
}

