/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.dev;

import io.quarkus.hibernate.orm.runtime.dev.HibernateOrmDevInfo;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.query.NamedHqlQueryDefinition;
import org.hibernate.boot.query.NamedNativeQueryDefinition;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.schema.Action;
import org.hibernate.tool.schema.SourceType;
import org.hibernate.tool.schema.TargetType;
import org.hibernate.tool.schema.internal.ExceptionHandlerCollectingImpl;
import org.hibernate.tool.schema.internal.HibernateSchemaManagementTool;
import org.hibernate.tool.schema.internal.exec.ScriptTargetOutputToWriter;
import org.hibernate.tool.schema.spi.ContributableMatcher;
import org.hibernate.tool.schema.spi.ExceptionHandler;
import org.hibernate.tool.schema.spi.ExecutionOptions;
import org.hibernate.tool.schema.spi.SchemaCreator;
import org.hibernate.tool.schema.spi.SchemaDropper;
import org.hibernate.tool.schema.spi.SchemaManagementTool;
import org.hibernate.tool.schema.spi.SchemaManagementToolCoordinator;
import org.hibernate.tool.schema.spi.ScriptSourceInput;
import org.hibernate.tool.schema.spi.ScriptTargetOutput;
import org.hibernate.tool.schema.spi.SourceDescriptor;
import org.hibernate.tool.schema.spi.TargetDescriptor;

public class HibernateOrmDevController {
    private static final HibernateOrmDevController INSTANCE = new HibernateOrmDevController();
    private HibernateOrmDevInfo info = new HibernateOrmDevInfo();

    public static HibernateOrmDevController get() {
        return INSTANCE;
    }

    private HibernateOrmDevController() {
    }

    public HibernateOrmDevInfo getInfo() {
        return this.info;
    }

    void pushPersistenceUnit(String persistenceUnitName, Metadata metadata, ServiceRegistry serviceRegistry, String importFile) {
        ArrayList<HibernateOrmDevInfo.Entity> managedEntities = new ArrayList<HibernateOrmDevInfo.Entity>();
        for (PersistentClass entityBinding : metadata.getEntityBindings()) {
            managedEntities.add(new HibernateOrmDevInfo.Entity(entityBinding.getClassName(), entityBinding.getTable().getName()));
        }
        ArrayList<HibernateOrmDevInfo.Query> namedQueries = new ArrayList<HibernateOrmDevInfo.Query>();
        ArrayList namedQueriesHqlDefs = new ArrayList();
        metadata.visitNamedHqlQueryDefinitions(namedQueriesHqlDefs::add);
        for (Object queryDefinition : namedQueriesHqlDefs) {
            namedQueries.add(new HibernateOrmDevInfo.Query((NamedHqlQueryDefinition)queryDefinition));
        }
        ArrayList<HibernateOrmDevInfo.Query> namedNativeQueries = new ArrayList<HibernateOrmDevInfo.Query>();
        ArrayList namedNativeQueriesNativeDefs = new ArrayList();
        metadata.visitNamedNativeQueryDefinitions(namedNativeQueriesNativeDefs::add);
        for (NamedNativeQueryDefinition staticQueryDefinition : namedNativeQueriesNativeDefs) {
            namedNativeQueries.add(new HibernateOrmDevInfo.Query(staticQueryDefinition));
        }
        String createDDL = HibernateOrmDevController.generateDDL(Action.CREATE, metadata, serviceRegistry, importFile);
        String dropDDL = HibernateOrmDevController.generateDDL(Action.DROP, metadata, serviceRegistry, importFile);
        this.info.add(new HibernateOrmDevInfo.PersistenceUnit(persistenceUnitName, managedEntities, namedQueries, namedNativeQueries, createDDL, dropDDL));
    }

    void clearData() {
        this.info = new HibernateOrmDevInfo();
    }

    private static String generateDDL(Action action, Metadata metadata, ServiceRegistry ssr, String importFiles) {
        HibernateSchemaManagementTool tool = (HibernateSchemaManagementTool)ssr.getService(SchemaManagementTool.class);
        HashMap<String, Object> config = new HashMap<String, Object>(((ConfigurationService)ssr.getService(ConfigurationService.class)).getSettings());
        config.put("hibernate.hbm2ddl.delimiter", ";");
        config.put("hibernate.format_sql", true);
        config.put("hibernate.hbm2ddl.import_files", importFiles);
        ExceptionHandlerCollectingImpl exceptionHandler = new ExceptionHandlerCollectingImpl();
        try {
            ExecutionOptions executionOptions = SchemaManagementToolCoordinator.buildExecutionOptions(config, (ExceptionHandler)exceptionHandler);
            final StringWriter writer = new StringWriter();
            SourceDescriptor source = new SourceDescriptor(){

                public SourceType getSourceType() {
                    return SourceType.METADATA;
                }

                public ScriptSourceInput getScriptSourceInput() {
                    return null;
                }
            };
            TargetDescriptor target = new TargetDescriptor(){

                public EnumSet<TargetType> getTargetTypes() {
                    return EnumSet.of(TargetType.SCRIPT);
                }

                public ScriptTargetOutput getScriptTargetOutput() {
                    return new ScriptTargetOutputToWriter(writer){

                        public void accept(String command) {
                            super.accept(command);
                        }
                    };
                }
            };
            if (action == Action.DROP) {
                SchemaDropper schemaDropper = tool.getSchemaDropper(executionOptions.getConfigurationValues());
                schemaDropper.doDrop(metadata, executionOptions, ContributableMatcher.ALL, source, target);
            } else if (action == Action.CREATE) {
                SchemaCreator schemaDropper = tool.getSchemaCreator(executionOptions.getConfigurationValues());
                schemaDropper.doCreation(metadata, executionOptions, ContributableMatcher.ALL, source, target);
            }
            return writer.toString();
        }
        catch (RuntimeException e) {
            StringWriter stackTraceWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stackTraceWriter));
            return "Could not generate DDL: \n" + stackTraceWriter.toString();
        }
    }
}

