/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.runtime.test.TestHttpEndpointProvider;
import io.quarkus.test.common.NativeImageLauncher;
import io.quarkus.test.common.PropertyTestUtil;
import io.quarkus.test.common.RestAssuredURLManager;
import io.quarkus.test.common.TestResourceManager;
import io.quarkus.test.common.TestScopeManager;
import io.quarkus.test.common.http.TestHTTPResourceManager;
import io.quarkus.test.junit.QuarkusTestExtension;
import io.quarkus.test.junit.QuarkusTestProfile;
import io.quarkus.test.junit.TestProfile;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.platform.commons.JUnitException;
import org.opentest4j.TestAbortedException;

public class NativeTestExtension
implements BeforeEachCallback,
AfterEachCallback,
BeforeAllCallback,
TestInstancePostProcessor {
    private static boolean failedBoot;
    private static List<Function<Class<?>, String>> testHttpEndpointProviders;
    private static boolean ssl;
    private static Class<? extends QuarkusTestProfile> quarkusTestProfile;
    private static Throwable firstException;

    public void afterEach(ExtensionContext context) throws Exception {
        if (!failedBoot) {
            RestAssuredURLManager.clearURL();
            TestScopeManager.tearDown((boolean)true);
        }
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        if (failedBoot) {
            this.throwBootFailureException();
        } else {
            RestAssuredURLManager.setURL((boolean)ssl, (String)QuarkusTestExtension.getEndpointPath(context, testHttpEndpointProviders));
            TestScopeManager.setup((boolean)true);
        }
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        this.ensureStarted(extensionContext);
    }

    private void ensureNoInjectAnnotationIsUsed(Class<?> testClass) {
        Class<?> current = testClass;
        while (current.getSuperclass() != null) {
            for (Field field : current.getDeclaredFields()) {
                Inject injectAnnotation = field.getAnnotation(Inject.class);
                if (injectAnnotation == null) continue;
                throw new JUnitException("@Inject is not supported in NativeImageTest tests. Offending field is " + field.getDeclaringClass().getTypeName() + "." + field.getName());
            }
            current = current.getSuperclass();
        }
    }

    private ExtensionState ensureStarted(ExtensionContext extensionContext) {
        boolean wrongProfile;
        Class testClass = extensionContext.getRequiredTestClass();
        this.ensureNoInjectAnnotationIsUsed(testClass);
        ExtensionContext root = extensionContext.getRoot();
        ExtensionContext.Store store = root.getStore(ExtensionContext.Namespace.GLOBAL);
        ExtensionState state = (ExtensionState)store.get((Object)ExtensionState.class.getName(), ExtensionState.class);
        TestProfile annotation = testClass.getAnnotation(TestProfile.class);
        Class<? extends QuarkusTestProfile> selectedProfile = null;
        if (annotation != null) {
            selectedProfile = annotation.value();
        }
        boolean bl = wrongProfile = !Objects.equals(selectedProfile, quarkusTestProfile);
        if (state == null && !failedBoot || wrongProfile) {
            if (wrongProfile && state != null) {
                try {
                    state.close();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            PropertyTestUtil.setLogFileProperty();
            try {
                state = this.doNativeStart(extensionContext, selectedProfile);
                store.put((Object)ExtensionState.class.getName(), (Object)state);
            }
            catch (Throwable e) {
                failedBoot = true;
                firstException = e;
            }
        }
        return state;
    }

    private ExtensionState doNativeStart(ExtensionContext context, Class<? extends QuarkusTestProfile> profile) throws Throwable {
        quarkusTestProfile = profile;
        TestResourceManager testResourceManager = null;
        try {
            Class requiredTestClass = context.getRequiredTestClass();
            HashMap<String, String> sysPropRestore = new HashMap<String, String>();
            sysPropRestore.put("quarkus.test.profile", System.getProperty("quarkus.test.profile"));
            QuarkusTestProfile profileInstance = null;
            HashMap<String, String> additional = new HashMap<String, String>();
            if (profile != null) {
                String configProfile;
                profileInstance = profile.newInstance();
                additional.putAll(profileInstance.getConfigOverrides());
                Set<Class<?>> enabledAlternatives = profileInstance.getEnabledAlternatives();
                if (!enabledAlternatives.isEmpty()) {
                    additional.put("quarkus.arc.selected-alternatives", enabledAlternatives.stream().peek(c -> {
                        if (!c.isAnnotationPresent(Alternative.class)) {
                            throw new RuntimeException("Enabled alternative " + c + " is not annotated with @Alternative");
                        }
                    }).map(Class::getName).collect(Collectors.joining(",")));
                }
                if ((configProfile = profileInstance.getConfigProfile()) != null) {
                    additional.put("quarkus.profile", configProfile);
                }
                additional.put("quarkus.configuration.build-time-mismatch-at-runtime", "fail");
                for (Map.Entry i : additional.entrySet()) {
                    sysPropRestore.put((String)i.getKey(), System.getProperty((String)i.getKey()));
                }
                for (Map.Entry i : additional.entrySet()) {
                    System.setProperty((String)i.getKey(), (String)i.getValue());
                }
            }
            testResourceManager = new TestResourceManager(requiredTestClass);
            testResourceManager.init();
            additional.putAll(testResourceManager.start());
            NativeImageLauncher launcher = new NativeImageLauncher(requiredTestClass);
            launcher.addSystemProperties(additional);
            try {
                launcher.start();
            }
            catch (IOException e) {
                try {
                    launcher.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw e;
            }
            if (launcher.isDefaultSsl()) {
                ssl = true;
            }
            ExtensionState state = new ExtensionState(testResourceManager, (Closeable)launcher, sysPropRestore);
            testHttpEndpointProviders = TestHttpEndpointProvider.load();
            return state;
        }
        catch (Throwable e) {
            try {
                if (testResourceManager != null) {
                    testResourceManager.close();
                }
            }
            catch (Exception ex) {
                e.addSuppressed(ex);
            }
            throw e;
        }
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        TestHTTPResourceManager.inject((Object)testInstance);
        ExtensionContext root = context.getRoot();
        ExtensionContext.Store store = root.getStore(ExtensionContext.Namespace.GLOBAL);
        ExtensionState state = (ExtensionState)store.get((Object)ExtensionState.class.getName(), ExtensionState.class);
        state.testResourceManager.inject(testInstance);
    }

    private void throwBootFailureException() throws Exception {
        if (firstException != null) {
            Throwable throwable = firstException;
            firstException = null;
            throw new RuntimeException(throwable);
        }
        throw new TestAbortedException("Boot failed");
    }

    public class ExtensionState
    implements ExtensionContext.Store.CloseableResource {
        private final TestResourceManager testResourceManager;
        private final Closeable resource;
        private final Map<String, String> sysPropRestore;
        private final Thread shutdownHook;

        ExtensionState(TestResourceManager testResourceManager, Closeable resource, Map<String, String> sysPropRestore) {
            this.testResourceManager = testResourceManager;
            this.resource = resource;
            this.sysPropRestore = sysPropRestore;
            this.shutdownHook = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ExtensionState.this.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }, "Quarkus Test Cleanup Shutdown task");
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }

        public void close() throws IOException {
            this.testResourceManager.close();
            this.resource.close();
            for (Map.Entry<String, String> entry : this.sysPropRestore.entrySet()) {
                String val = entry.getValue();
                if (val == null) {
                    System.clearProperty(entry.getKey());
                    continue;
                }
                System.setProperty(entry.getKey(), val);
            }
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
    }
}

