/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.runtime.test.TestHttpEndpointProvider;
import io.quarkus.test.common.ArtifactLauncher;
import io.quarkus.test.common.DockerContainerLauncher;
import io.quarkus.test.common.JarLauncher;
import io.quarkus.test.common.NativeImageLauncher;
import io.quarkus.test.common.RestAssuredURLManager;
import io.quarkus.test.common.TestResourceManager;
import io.quarkus.test.common.TestScopeManager;
import io.quarkus.test.junit.IntegrationTestExtensionState;
import io.quarkus.test.junit.IntegrationTestUtil;
import io.quarkus.test.junit.QuarkusTestExtension;
import io.quarkus.test.junit.QuarkusTestProfile;
import io.quarkus.test.junit.TestProfileAndProperties;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.opentest4j.TestAbortedException;

public class QuarkusIntegrationTestExtension
implements BeforeEachCallback,
AfterEachCallback,
BeforeAllCallback,
TestInstancePostProcessor {
    private static boolean failedBoot;
    private static List<Function<Class<?>, String>> testHttpEndpointProviders;
    private static boolean ssl;
    private static Class<? extends QuarkusTestProfile> quarkusTestProfile;
    private static Throwable firstException;
    private static Class<?> currentJUnitTestClass;
    private static boolean hasPerTestResources;

    public void afterEach(ExtensionContext context) throws Exception {
        if (!failedBoot) {
            RestAssuredURLManager.clearURL();
            TestScopeManager.tearDown((boolean)true);
        }
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        if (failedBoot) {
            this.throwBootFailureException();
        } else {
            RestAssuredURLManager.setURL((boolean)ssl, (String)QuarkusTestExtension.getEndpointPath(context, testHttpEndpointProviders));
            TestScopeManager.setup((boolean)true);
        }
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        this.ensureStarted(extensionContext);
    }

    private IntegrationTestExtensionState ensureStarted(ExtensionContext extensionContext) {
        boolean reloadTestResources;
        Class testClass = extensionContext.getRequiredTestClass();
        IntegrationTestUtil.ensureNoInjectAnnotationIsUsed(testClass);
        Properties quarkusArtifactProperties = this.readQuarkusArtifactProperties(extensionContext);
        ExtensionContext root = extensionContext.getRoot();
        ExtensionContext.Store store = root.getStore(ExtensionContext.Namespace.GLOBAL);
        IntegrationTestExtensionState state = (IntegrationTestExtensionState)store.get((Object)IntegrationTestExtensionState.class.getName(), IntegrationTestExtensionState.class);
        Class<? extends QuarkusTestProfile> selectedProfile = IntegrationTestUtil.findProfile(testClass);
        boolean wrongProfile = !Objects.equals(selectedProfile, quarkusTestProfile);
        boolean bl = reloadTestResources = !Objects.equals(extensionContext.getRequiredTestClass(), currentJUnitTestClass) && (hasPerTestResources || QuarkusTestExtension.hasPerTestResources(extensionContext));
        if (state == null && !failedBoot || wrongProfile || reloadTestResources) {
            if (wrongProfile && state != null) {
                try {
                    state.close();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            try {
                state = this.doProcessStart(quarkusArtifactProperties, selectedProfile, extensionContext);
                store.put((Object)IntegrationTestExtensionState.class.getName(), (Object)state);
            }
            catch (Throwable e) {
                failedBoot = true;
                firstException = e;
            }
        }
        return state;
    }

    private Properties readQuarkusArtifactProperties(ExtensionContext context) {
        Path buildOutputDirectory = this.determineBuildOutputDirectory(context);
        Path artifactProperties = buildOutputDirectory.resolve("quarkus-artifact.properties");
        if (!Files.exists(artifactProperties, new LinkOption[0])) {
            throw new IllegalStateException("Unable to locate the artifact metadata file created that must be created by Quarkus in order to run tests annotated with '@QuarkusIntegrationTest'.");
        }
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(artifactProperties.toFile()));
            return properties;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to read artifact metadata file created that must be created by Quarkus in order to run tests annotated with '@QuarkusIntegrationTest'.", e);
        }
    }

    private Path determineBuildOutputDirectory(ExtensionContext context) {
        String buildOutputDirStr = System.getProperty("build.output.directory");
        Path result = null;
        if (buildOutputDirStr != null) {
            result = Paths.get(buildOutputDirStr, new String[0]);
        } else {
            Class testClass = context.getRequiredTestClass();
            CodeSource codeSource = testClass.getProtectionDomain().getCodeSource();
            if (codeSource != null) {
                URL codeSourceLocation = codeSource.getLocation();
                File artifactPropertiesDirectory = QuarkusIntegrationTestExtension.determineBuildOutputDirectory(codeSourceLocation);
                if (artifactPropertiesDirectory == null) {
                    throw new IllegalStateException("Unable to determine the output of the Quarkus build. Consider setting the 'build.output.directory' system property.");
                }
                result = artifactPropertiesDirectory.toPath();
            }
        }
        if (result == null) {
            throw new IllegalStateException("Unable to locate the artifact metadata file created that must be created by Quarkus in order to run tests annotated with '@QuarkusIntegrationTest'.");
        }
        if (!Files.isDirectory(result, new LinkOption[0])) {
            throw new IllegalStateException("The determined Quarkus build output '" + result.toAbsolutePath().toString() + "' is not a directory");
        }
        return result;
    }

    private static File determineBuildOutputDirectory(URL url) {
        if (url == null) {
            return null;
        }
        if (url.getProtocol().equals("file") && url.getPath().endsWith("test-classes/")) {
            File testClasses = new File(url.getPath());
            return testClasses.getParentFile();
        }
        if (url.getProtocol().equals("file") && url.getPath().endsWith("test/")) {
            File testClasses = new File(url.getPath());
            return testClasses.getParentFile().getParentFile().getParentFile();
        }
        if (url.getProtocol().equals("file") && url.getPath().contains("/target/surefire/")) {
            String path = url.getPath();
            int index = path.lastIndexOf("/target/");
            return new File(path.substring(0, index) + "/target/");
        }
        return null;
    }

    private IntegrationTestExtensionState doProcessStart(Properties quarkusArtifactProperties, Class<? extends QuarkusTestProfile> profile, ExtensionContext context) throws Throwable {
        Map<String, String> devDbProps = IntegrationTestUtil.handleDevDb(context);
        quarkusTestProfile = profile;
        currentJUnitTestClass = context.getRequiredTestClass();
        TestResourceManager testResourceManager = null;
        try {
            DockerContainerLauncher launcher;
            Class requiredTestClass = context.getRequiredTestClass();
            Map<String, String> sysPropRestore = IntegrationTestUtil.getSysPropsToRestore();
            TestProfileAndProperties testProfileAndProperties = IntegrationTestUtil.determineTestProfileAndProperties(profile, sysPropRestore);
            testResourceManager = new TestResourceManager(requiredTestClass, quarkusTestProfile, Collections.emptyList(), testProfileAndProperties.testProfile != null && testProfileAndProperties.testProfile.disableGlobalTestResources());
            testResourceManager.init();
            hasPerTestResources = testResourceManager.hasPerTestResources();
            HashMap<String, String> additionalProperties = new HashMap<String, String>(testProfileAndProperties.properties);
            additionalProperties.putAll(devDbProps);
            additionalProperties.putAll(testResourceManager.start());
            String artifactType = quarkusArtifactProperties.getProperty("type");
            if (artifactType == null) {
                throw new IllegalStateException("Unable to determine the type of artifact created by the Quarkus build");
            }
            switch (artifactType) {
                case "native": {
                    String pathStr = quarkusArtifactProperties.getProperty("path");
                    if (pathStr != null && !pathStr.isEmpty()) {
                        String previousNativeImagePathValue = System.setProperty("native.image.path", this.determineBuildOutputDirectory(context).resolve(pathStr).toAbsolutePath().toString());
                        sysPropRestore.put("native.image.path", previousNativeImagePathValue);
                        launcher = new NativeImageLauncher(requiredTestClass);
                        break;
                    }
                    throw new IllegalStateException("The path of the native binary could not be determined");
                }
                case "jar": {
                    String pathStr = quarkusArtifactProperties.getProperty("path");
                    if (pathStr != null && !pathStr.isEmpty()) {
                        launcher = new JarLauncher(this.determineBuildOutputDirectory(context).resolve(pathStr));
                        break;
                    }
                    throw new IllegalStateException("The path of the native binary could not be determined");
                }
                case "jar-container": 
                case "native-container": {
                    String containerImage = quarkusArtifactProperties.getProperty("metadata.container-image");
                    if (containerImage != null && !containerImage.isEmpty()) {
                        launcher = new DockerContainerLauncher(containerImage);
                        break;
                    }
                    throw new IllegalStateException("The container image to be launched could not be determined");
                }
                default: {
                    throw new IllegalStateException("Artifact type + '" + artifactType + "' is not supported by @QuarkusIntegrationTest");
                }
            }
            IntegrationTestUtil.startLauncher((ArtifactLauncher)launcher, additionalProperties, () -> {
                ssl = true;
            });
            IntegrationTestExtensionState state = new IntegrationTestExtensionState(testResourceManager, (Closeable)launcher, sysPropRestore);
            testHttpEndpointProviders = TestHttpEndpointProvider.load();
            return state;
        }
        catch (Throwable e) {
            try {
                if (testResourceManager != null) {
                    testResourceManager.close();
                }
            }
            catch (Exception ex) {
                e.addSuppressed(ex);
            }
            throw e;
        }
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) {
        if (!failedBoot) {
            IntegrationTestUtil.doProcessTestInstance(testInstance, context);
        }
    }

    private void throwBootFailureException() {
        if (firstException != null) {
            Throwable throwable = firstException;
            firstException = null;
            throw new RuntimeException(throwable);
        }
        throw new TestAbortedException("Boot failed");
    }
}

