/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.keycloak.admin.client.reactive.runtime;

import io.quarkus.keycloak.admin.client.common.KeycloakAdminClientConfig;
import io.quarkus.keycloak.admin.client.common.KeycloakAdminClientConfigUtil;
import io.quarkus.keycloak.admin.client.reactive.runtime.ResteasyReactiveClientProvider;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.util.function.Supplier;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.KeycloakBuilder;
import org.keycloak.admin.client.spi.ResteasyClientProvider;

@Recorder
public class ResteasyReactiveKeycloakAdminClientRecorder {
    private final RuntimeValue<KeycloakAdminClientConfig> keycloakAdminClientConfigRuntimeValue;

    public ResteasyReactiveKeycloakAdminClientRecorder(RuntimeValue<KeycloakAdminClientConfig> keycloakAdminClientConfigRuntimeValue) {
        this.keycloakAdminClientConfigRuntimeValue = keycloakAdminClientConfigRuntimeValue;
    }

    public void setClientProvider(boolean tlsTrustAll) {
        Keycloak.setClientProvider((ResteasyClientProvider)new ResteasyReactiveClientProvider(tlsTrustAll));
    }

    public Supplier<Keycloak> createAdminClient() {
        KeycloakAdminClientConfig config = (KeycloakAdminClientConfig)this.keycloakAdminClientConfigRuntimeValue.getValue();
        KeycloakAdminClientConfigUtil.validate((KeycloakAdminClientConfig)config);
        if (config.serverUrl().isEmpty()) {
            return new Supplier<Keycloak>(){

                @Override
                public Keycloak get() {
                    throw new IllegalStateException("'quarkus.keycloak.admin-client.server-url' must be set in order to use the Keycloak admin client as a CDI bean");
                }
            };
        }
        final KeycloakBuilder keycloakBuilder = KeycloakBuilder.builder().clientId(config.clientId()).clientSecret((String)config.clientSecret().orElse(null)).grantType(config.grantType().asString()).username((String)config.username().orElse(null)).password((String)config.password().orElse(null)).realm(config.realm()).serverUrl((String)config.serverUrl().get()).scope((String)config.scope().orElse(null));
        return new Supplier<Keycloak>(){

            @Override
            public Keycloak get() {
                return keycloakBuilder.build();
            }
        };
    }
}

