/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.keycloak.pep.runtime;

import io.quarkus.keycloak.pep.runtime.HttpClientBuilder;
import io.quarkus.keycloak.pep.runtime.KeycloakPolicyEnforcerTenantConfig;
import io.quarkus.oidc.OIDCException;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.common.runtime.OidcCommonConfig;
import io.quarkus.oidc.common.runtime.OidcTlsSupport;
import io.quarkus.oidc.runtime.OidcConfig;
import io.quarkus.oidc.runtime.OidcTenantConfig;
import io.quarkus.runtime.configuration.ConfigurationException;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.adapters.authorization.PolicyEnforcer;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.keycloak.representations.adapters.config.AdapterHttpClientConfig;
import org.keycloak.representations.adapters.config.PolicyEnforcerConfig;

public final class KeycloakPolicyEnforcerUtil {
    private KeycloakPolicyEnforcerUtil() {
    }

    static PolicyEnforcer createPolicyEnforcer(io.quarkus.oidc.OidcTenantConfig oidcConfig, KeycloakPolicyEnforcerTenantConfig keycloakPolicyEnforcerConfig, OidcTlsSupport.TlsConfigSupport tlsConfigSupport) {
        if (oidcConfig.applicationType.orElse(OidcTenantConfig.ApplicationType.SERVICE) == OidcTenantConfig.ApplicationType.WEB_APP && oidcConfig.roles.source.orElse(null) != OidcTenantConfig.Roles.Source.accesstoken) {
            throw new OIDCException("Application 'web-app' type is only supported if access token is the source of roles");
        }
        AdapterConfig adapterConfig = new AdapterConfig();
        String authServerUrl = (String)oidcConfig.getAuthServerUrl().get();
        try {
            adapterConfig.setRealm(authServerUrl.substring(authServerUrl.lastIndexOf(47) + 1));
            adapterConfig.setAuthServerUrl(authServerUrl.substring(0, authServerUrl.lastIndexOf("/realms")));
        }
        catch (Exception cause) {
            throw new ConfigurationException("Failed to parse the realm name.", (Throwable)cause);
        }
        adapterConfig.setResource((String)oidcConfig.getClientId().get());
        adapterConfig.setCredentials(KeycloakPolicyEnforcerUtil.getCredentials(oidcConfig));
        if (!tlsConfigSupport.useTlsRegistry()) {
            boolean trustAll;
            boolean bl = oidcConfig.tls.getVerification().isPresent() ? oidcConfig.tls.getVerification().get() == OidcCommonConfig.Tls.Verification.NONE : (trustAll = tlsConfigSupport.isGlobalTrustAll());
            if (trustAll) {
                adapterConfig.setDisableTrustManager(true);
                adapterConfig.setAllowAnyHostname(true);
            } else if (oidcConfig.tls.trustStoreFile.isPresent()) {
                adapterConfig.setTruststore(((Path)oidcConfig.tls.trustStoreFile.get()).toString());
                adapterConfig.setTruststorePassword(oidcConfig.tls.trustStorePassword.orElse("password"));
                if (OidcCommonConfig.Tls.Verification.CERTIFICATE_VALIDATION == oidcConfig.tls.verification.orElse(OidcCommonConfig.Tls.Verification.REQUIRED)) {
                    adapterConfig.setAllowAnyHostname(true);
                }
            }
        }
        adapterConfig.setConnectionPoolSize(keycloakPolicyEnforcerConfig.connectionPoolSize());
        if (oidcConfig.proxy.host.isPresent()) {
            Object host = (String)oidcConfig.proxy.host.get();
            if (!((String)host).startsWith("http://") && !((String)host).startsWith("https://")) {
                host = URI.create(authServerUrl).getScheme() + "://" + (String)host;
            }
            adapterConfig.setProxyUrl((String)host + ":" + oidcConfig.proxy.port);
        }
        PolicyEnforcerConfig enforcerConfig = KeycloakPolicyEnforcerUtil.getPolicyEnforcerConfig(keycloakPolicyEnforcerConfig);
        adapterConfig.setPolicyEnforcerConfig(enforcerConfig);
        return PolicyEnforcer.builder().authServerUrl(adapterConfig.getAuthServerUrl()).realm(adapterConfig.getRealm()).clientId(adapterConfig.getResource()).credentials(adapterConfig.getCredentials()).bearerOnly(adapterConfig.isBearerOnly()).enforcerConfig(enforcerConfig).httpClient(new HttpClientBuilder().sslContext(tlsConfigSupport.getSslContext()).build((AdapterHttpClientConfig)adapterConfig)).build();
    }

    private static Map<String, Object> getCredentials(io.quarkus.oidc.OidcTenantConfig oidcConfig) {
        HashMap<String, Object> credentials = new HashMap<String, Object>();
        Optional clientSecret = oidcConfig.getCredentials().getSecret();
        if (clientSecret.isPresent()) {
            credentials.put("secret", clientSecret.orElse(null));
        }
        return credentials;
    }

    private static Map<String, Map<String, Object>> getClaimInformationPointConfig(KeycloakPolicyEnforcerTenantConfig.KeycloakConfigPolicyEnforcer.ClaimInformationPointConfig config) {
        HashMap<String, Object> newConfig;
        HashMap<String, Map<String, Object>> cipConfig = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<String, Map<String, String>> entry : config.simpleConfig().entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            newConfig = new HashMap<String, Object>();
            for (Map.Entry<String, Object> e : entry.getValue().entrySet()) {
                if (!KeycloakPolicyEnforcerUtil.isNotComplexConfigKey(e.getKey())) continue;
                newConfig.put(e.getKey(), e.getValue());
            }
            if (newConfig.isEmpty()) continue;
            cipConfig.put(entry.getKey(), newConfig);
        }
        for (Map.Entry<String, Map<String, Object>> entry : config.complexConfig().entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            newConfig = new HashMap();
            for (Map.Entry<String, Object> e : entry.getValue().entrySet()) {
                if (e.getValue() == null || ((Map)e.getValue()).isEmpty()) continue;
                newConfig.put(e.getKey(), e.getValue());
            }
            if (newConfig.isEmpty()) continue;
            cipConfig.computeIfAbsent(entry.getKey(), s -> new HashMap()).putAll(newConfig);
        }
        return cipConfig;
    }

    private static PolicyEnforcerConfig getPolicyEnforcerConfig(KeycloakPolicyEnforcerTenantConfig config) {
        PolicyEnforcerConfig enforcerConfig = new PolicyEnforcerConfig();
        enforcerConfig.setLazyLoadPaths(Boolean.valueOf(config.policyEnforcer().lazyLoadPaths()));
        enforcerConfig.setEnforcementMode(config.policyEnforcer().enforcementMode());
        enforcerConfig.setHttpMethodAsScope(Boolean.valueOf(config.policyEnforcer().httpMethodAsScope()));
        KeycloakPolicyEnforcerTenantConfig.KeycloakConfigPolicyEnforcer.PathCacheConfig pathCache = config.policyEnforcer().pathCache();
        PolicyEnforcerConfig.PathCacheConfig pathCacheConfig = new PolicyEnforcerConfig.PathCacheConfig();
        pathCacheConfig.setLifespan(pathCache.lifespan());
        pathCacheConfig.setMaxEntries(pathCache.maxEntries());
        enforcerConfig.setPathCacheConfig(pathCacheConfig);
        enforcerConfig.setClaimInformationPointConfig(KeycloakPolicyEnforcerUtil.getClaimInformationPointConfig(config.policyEnforcer().claimInformationPoint()));
        enforcerConfig.setPaths(config.policyEnforcer().paths().values().stream().flatMap(new Function<KeycloakPolicyEnforcerTenantConfig.KeycloakConfigPolicyEnforcer.PathConfig, Stream<? extends PolicyEnforcerConfig.PathConfig>>(){

            @Override
            public Stream<? extends PolicyEnforcerConfig.PathConfig> apply(final KeycloakPolicyEnforcerTenantConfig.KeycloakConfigPolicyEnforcer.PathConfig pathConfig) {
                Set<String> paths = KeycloakPolicyEnforcerUtil.getPathConfigPaths(pathConfig);
                if (paths.isEmpty()) {
                    return Stream.of(KeycloakPolicyEnforcerUtil.createKeycloakPathConfig(pathConfig, null));
                }
                return paths.stream().map(new Function<String, PolicyEnforcerConfig.PathConfig>(){

                    @Override
                    public PolicyEnforcerConfig.PathConfig apply(String path) {
                        return KeycloakPolicyEnforcerUtil.createKeycloakPathConfig(pathConfig, path);
                    }
                });
            }
        }).collect(Collectors.toList()));
        return enforcerConfig;
    }

    private static Set<String> getPathConfigPaths(KeycloakPolicyEnforcerTenantConfig.KeycloakConfigPolicyEnforcer.PathConfig pathConfig) {
        HashSet<String> paths = new HashSet<String>();
        if (pathConfig.path().isPresent()) {
            paths.add(pathConfig.path().get());
        }
        if (pathConfig.paths().isPresent()) {
            paths.addAll((Collection<String>)pathConfig.paths().get());
        }
        return paths;
    }

    private static PolicyEnforcerConfig.PathConfig createKeycloakPathConfig(KeycloakPolicyEnforcerTenantConfig.KeycloakConfigPolicyEnforcer.PathConfig pathConfig, String path) {
        PolicyEnforcerConfig.PathConfig config1 = new PolicyEnforcerConfig.PathConfig();
        config1.setName((String)pathConfig.name().orElse(null));
        config1.setPath(path);
        config1.setEnforcementMode(pathConfig.enforcementMode());
        config1.setMethods(pathConfig.methods().values().stream().map(new Function<KeycloakPolicyEnforcerTenantConfig.KeycloakConfigPolicyEnforcer.MethodConfig, PolicyEnforcerConfig.MethodConfig>(){

            @Override
            public PolicyEnforcerConfig.MethodConfig apply(KeycloakPolicyEnforcerTenantConfig.KeycloakConfigPolicyEnforcer.MethodConfig methodConfig) {
                PolicyEnforcerConfig.MethodConfig mConfig = new PolicyEnforcerConfig.MethodConfig();
                mConfig.setMethod(methodConfig.method());
                mConfig.setScopes(methodConfig.scopes());
                mConfig.setScopesEnforcementMode(methodConfig.scopesEnforcementMode());
                return mConfig;
            }
        }).collect(Collectors.toList()));
        config1.setClaimInformationPointConfig(KeycloakPolicyEnforcerUtil.getClaimInformationPointConfig(pathConfig.claimInformationPoint()));
        return config1;
    }

    private static boolean isNotComplexConfigKey(String key) {
        return !key.contains(".");
    }

    static io.quarkus.oidc.OidcTenantConfig getOidcTenantConfig(OidcConfig oidcConfig, String tenant) {
        if (tenant == null || "Default".equals(tenant)) {
            return new io.quarkus.oidc.OidcTenantConfig(OidcConfig.getDefaultTenant((OidcConfig)oidcConfig), "Default");
        }
        OidcTenantConfig oidcTenantConfig = (OidcTenantConfig)oidcConfig.namedTenants().get(tenant);
        if (oidcTenantConfig == null) {
            throw new ConfigurationException("Failed to find a matching OidcTenantConfig for tenant: " + tenant);
        }
        return new io.quarkus.oidc.OidcTenantConfig(oidcTenantConfig, tenant);
    }
}

