/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.deps.kubernetes.api.builder.Visitor;
import io.dekorate.deps.kubernetes.api.model.Container;
import io.dekorate.deps.kubernetes.api.model.ContainerBuilder;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.Mount;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.decorator.AddEnvVarDecorator;
import io.dekorate.kubernetes.decorator.AddLivenessProbeDecorator;
import io.dekorate.kubernetes.decorator.AddMountDecorator;
import io.dekorate.kubernetes.decorator.AddPortDecorator;
import io.dekorate.kubernetes.decorator.AddReadinessProbeDecorator;
import io.dekorate.kubernetes.decorator.ApplyImagePullPolicyDecorator;
import io.dekorate.utils.Images;
import io.dekorate.utils.Strings;

public class ContainerAdapter {
    public static Container adapt(io.dekorate.kubernetes.config.Container container) {
        String name = container.getName();
        if (Strings.isNullOrEmpty((String)name)) {
            name = Images.getName((String)container.getImage());
        }
        ContainerBuilder builder = (ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName(name)).withImage(container.getImage())).withWorkingDir(container.getWorkingDir())).withCommand(container.getCommand())).withArgs(container.getArguments());
        for (Env env : container.getEnvVars()) {
            builder.accept((Visitor)new AddEnvVarDecorator(env));
        }
        for (Env env : container.getPorts()) {
            builder.accept((Visitor)new AddPortDecorator((Port)env));
        }
        for (Env env : container.getMounts()) {
            builder.accept((Visitor)new AddMountDecorator((Mount)env));
        }
        builder.accept((Visitor)new ApplyImagePullPolicyDecorator(name, container.getImagePullPolicy()));
        builder.accept((Visitor)new AddLivenessProbeDecorator(name, container.getLivenessProbe()));
        builder.accept((Visitor)new AddReadinessProbeDecorator(name, container.getReadinessProbe()));
        return builder.build();
    }
}

