/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.config.Probe;
import io.dekorate.kubernetes.config.ProbeBuilder;
import io.quarkus.kubernetes.deployment.ProbeConfig;

public class ProbeConverter {
    public static Probe convert(ProbeConfig probe) {
        return ProbeConverter.builder(probe).build();
    }

    public static ProbeBuilder builder(ProbeConfig probe) {
        ProbeBuilder b = new ProbeBuilder();
        probe.httpActionPath.ifPresent(v -> {
            ProbeBuilder cfr_ignored_0 = (ProbeBuilder)b.withHttpActionPath(v);
        });
        probe.execAction.ifPresent(v -> {
            ProbeBuilder cfr_ignored_0 = (ProbeBuilder)b.withExecAction(v);
        });
        probe.tcpSocketAction.ifPresent(v -> {
            ProbeBuilder cfr_ignored_0 = (ProbeBuilder)b.withTcpSocketAction(v);
        });
        b.withInitialDelaySeconds((int)probe.initialDelay.getSeconds());
        b.withPeriodSeconds((int)probe.period.getSeconds());
        b.withTimeoutSeconds((int)probe.timeout.getSeconds());
        b.withSuccessThreshold(probe.successThreshold.intValue());
        b.withFailureThreshold(probe.failureThreshold.intValue());
        return b;
    }
}

