/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.annotation.ImagePullPolicy;
import io.dekorate.kubernetes.annotation.ServiceType;
import io.quarkus.container.image.deployment.ContainerImageCapabilitiesUtil;
import io.quarkus.container.image.deployment.ContainerImageConfig;
import io.quarkus.deployment.Capabilities;
import io.quarkus.kubernetes.deployment.AwsElasticBlockStoreVolumeConfig;
import io.quarkus.kubernetes.deployment.AzureDiskVolumeConfig;
import io.quarkus.kubernetes.deployment.AzureFileVolumeConfig;
import io.quarkus.kubernetes.deployment.ConfigMapVolumeConfig;
import io.quarkus.kubernetes.deployment.ContainerConfig;
import io.quarkus.kubernetes.deployment.CronJobConfig;
import io.quarkus.kubernetes.deployment.DebugConfig;
import io.quarkus.kubernetes.deployment.EnvConfig;
import io.quarkus.kubernetes.deployment.EnvVarsConfig;
import io.quarkus.kubernetes.deployment.GitRepoVolumeConfig;
import io.quarkus.kubernetes.deployment.HostAliasConfig;
import io.quarkus.kubernetes.deployment.InitTaskConfig;
import io.quarkus.kubernetes.deployment.JobConfig;
import io.quarkus.kubernetes.deployment.MountConfig;
import io.quarkus.kubernetes.deployment.PlatformConfiguration;
import io.quarkus.kubernetes.deployment.PortConfig;
import io.quarkus.kubernetes.deployment.ProbeConfig;
import io.quarkus.kubernetes.deployment.PrometheusConfig;
import io.quarkus.kubernetes.deployment.PvcVolumeConfig;
import io.quarkus.kubernetes.deployment.RbacConfig;
import io.quarkus.kubernetes.deployment.ResourcesConfig;
import io.quarkus.kubernetes.deployment.RouteConfig;
import io.quarkus.kubernetes.deployment.SecretVolumeConfig;
import io.quarkus.kubernetes.deployment.SecurityContextConfig;
import io.quarkus.kubernetes.spi.DeployStrategy;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;

@ConfigRoot
public class OpenshiftConfig
implements PlatformConfiguration {
    @ConfigItem(defaultValue="v4")
    OpenshiftFlavor flavor;
    @ConfigItem
    Optional<DeploymentResourceKind> deploymentKind;
    @ConfigItem
    Optional<String> partOf;
    @ConfigItem
    Optional<String> name;
    @ConfigItem
    Optional<String> version;
    @ConfigItem
    Optional<String> namespace;
    @ConfigItem
    Map<String, String> labels;
    @ConfigItem
    Map<String, String> annotations;
    @ConfigItem(defaultValue="true")
    boolean addBuildTimestamp;
    @ConfigItem
    Optional<String> workingDir;
    @ConfigItem
    Optional<List<String>> command;
    @ConfigItem
    Optional<List<String>> arguments;
    @ConfigItem
    Optional<String> serviceAccount;
    @ConfigItem
    Map<String, PortConfig> ports;
    @ConfigItem(defaultValue="1")
    Integer replicas;
    @ConfigItem(defaultValue="ClusterIP")
    ServiceType serviceType;
    @ConfigItem
    OptionalInt nodePort;
    @ConfigItem(defaultValue="Always")
    ImagePullPolicy imagePullPolicy;
    @ConfigItem
    Optional<List<String>> imagePullSecrets;
    @ConfigItem(defaultValue="false")
    boolean generateImagePullSecret;
    @ConfigItem
    ProbeConfig livenessProbe;
    @ConfigItem
    ProbeConfig readinessProbe;
    @ConfigItem
    ProbeConfig startupProbe;
    @ConfigItem
    PrometheusConfig prometheus;
    @ConfigItem
    Map<String, MountConfig> mounts;
    @ConfigItem
    Map<String, SecretVolumeConfig> secretVolumes;
    @ConfigItem
    Map<String, ConfigMapVolumeConfig> configMapVolumes;
    @ConfigItem
    Optional<List<String>> emptyDirVolumes;
    @ConfigItem
    Map<String, GitRepoVolumeConfig> gitRepoVolumes;
    @ConfigItem
    Map<String, PvcVolumeConfig> pvcVolumes;
    @ConfigItem
    Map<String, AwsElasticBlockStoreVolumeConfig> awsElasticBlockStoreVolumes;
    @ConfigItem
    Map<String, AzureFileVolumeConfig> azureFileVolumes;
    @ConfigItem
    Map<String, AzureDiskVolumeConfig> azureDiskVolumes;
    @ConfigItem
    Map<String, ContainerConfig> initContainers;
    @ConfigItem
    @Deprecated
    Map<String, ContainerConfig> containers;
    @ConfigItem
    Map<String, ContainerConfig> sidecars;
    @ConfigItem
    Map<String, HostAliasConfig> hostAliases;
    @ConfigItem
    ResourcesConfig resources;
    @ConfigItem
    Optional<String> containerName;
    RouteConfig route;
    @ConfigItem(defaultValue="true")
    boolean addVersionToLabelSelectors;
    @ConfigItem(defaultValue="true")
    boolean addNameToLabelSelectors;
    JobConfig job;
    CronJobConfig cronJob;
    RbacConfig rbac;
    @ConfigItem
    @Deprecated
    Map<String, EnvConfig> envVars;
    @ConfigItem
    EnvVarsConfig env;
    @ConfigItem
    Optional<String> appSecret;
    @ConfigItem
    Optional<String> appConfigMap;
    @ConfigItem
    SecurityContextConfig securityContext;
    DebugConfig remoteDebug;
    @ConfigItem(defaultValue="false")
    boolean deploy;
    @ConfigItem(defaultValue="CreateOrUpdate")
    DeployStrategy deployStrategy;
    @Deprecated(since="3.1", forRemoval=true)
    @ConfigItem(defaultValue="true")
    boolean externalizeInit;
    @ConfigItem
    Map<String, InitTaskConfig> initTasks;
    @ConfigItem
    InitTaskConfig initTaskDefaults;
    @ConfigItem(defaultValue="false")
    boolean idempotent;

    @Override
    public Optional<String> getPartOf() {
        return this.partOf;
    }

    @Override
    public Optional<String> getName() {
        return this.name;
    }

    @Override
    public Optional<String> getVersion() {
        return this.version;
    }

    @Override
    public Optional<String> getNamespace() {
        return this.namespace;
    }

    @Override
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Override
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    @Override
    public boolean isAddBuildTimestamp() {
        return this.addBuildTimestamp;
    }

    @Override
    public boolean isAddNameToLabelSelectors() {
        return this.addNameToLabelSelectors;
    }

    @Override
    public boolean isAddVersionToLabelSelectors() {
        return this.addVersionToLabelSelectors;
    }

    @Override
    public Optional<String> getWorkingDir() {
        return this.workingDir;
    }

    @Override
    public Optional<List<String>> getCommand() {
        return this.command;
    }

    @Override
    public Optional<List<String>> getArguments() {
        return this.arguments;
    }

    @Override
    public Optional<String> getServiceAccount() {
        return this.serviceAccount;
    }

    @Override
    public Optional<String> getContainerName() {
        return this.containerName;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    @Override
    public Map<String, PortConfig> getPorts() {
        return this.ports;
    }

    @Override
    public ServiceType getServiceType() {
        return this.serviceType;
    }

    @Override
    public ImagePullPolicy getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    @Override
    public Optional<List<String>> getImagePullSecrets() {
        return this.imagePullSecrets;
    }

    @Override
    public boolean isGenerateImagePullSecret() {
        return this.generateImagePullSecret;
    }

    @Override
    public ProbeConfig getLivenessProbe() {
        return this.livenessProbe;
    }

    @Override
    public ProbeConfig getReadinessProbe() {
        return this.readinessProbe;
    }

    @Override
    public ProbeConfig getStartupProbe() {
        return this.startupProbe;
    }

    @Override
    public PrometheusConfig getPrometheusConfig() {
        return this.prometheus;
    }

    @Override
    public Map<String, MountConfig> getMounts() {
        return this.mounts;
    }

    @Override
    public Map<String, SecretVolumeConfig> getSecretVolumes() {
        return this.secretVolumes;
    }

    @Override
    public Map<String, ConfigMapVolumeConfig> getConfigMapVolumes() {
        return this.configMapVolumes;
    }

    @Override
    public List<String> getEmptyDirVolumes() {
        return this.emptyDirVolumes.orElse(Collections.emptyList());
    }

    @Override
    public Map<String, GitRepoVolumeConfig> getGitRepoVolumes() {
        return this.gitRepoVolumes;
    }

    @Override
    public Map<String, PvcVolumeConfig> getPvcVolumes() {
        return this.pvcVolumes;
    }

    @Override
    public Map<String, AwsElasticBlockStoreVolumeConfig> getAwsElasticBlockStoreVolumes() {
        return this.awsElasticBlockStoreVolumes;
    }

    @Override
    public Map<String, AzureFileVolumeConfig> getAzureFileVolumes() {
        return this.azureFileVolumes;
    }

    @Override
    public Map<String, AzureDiskVolumeConfig> getAzureDiskVolumes() {
        return this.azureDiskVolumes;
    }

    @Override
    public Map<String, HostAliasConfig> getHostAliases() {
        return this.hostAliases;
    }

    @Override
    public ResourcesConfig getResources() {
        return this.resources;
    }

    @Override
    public Map<String, ContainerConfig> getInitContainers() {
        return this.initContainers;
    }

    @Override
    public Map<String, ContainerConfig> getSidecars() {
        if (!this.containers.isEmpty() && !this.sidecars.isEmpty()) {
            throw new IllegalStateException("'quarkus.openshift.sidecars' and 'quarkus.openshift.containers' cannot be used together. Please use the former as the latter has been deprecated");
        }
        if (!this.containers.isEmpty()) {
            return this.containers;
        }
        return this.sidecars;
    }

    @Override
    public String getTargetPlatformName() {
        return "openshift";
    }

    @Override
    @Deprecated
    public Map<String, EnvConfig> getEnvVars() {
        return this.envVars;
    }

    @Override
    public EnvVarsConfig getEnv() {
        return this.env;
    }

    @Override
    public Optional<String> getAppSecret() {
        return this.appSecret;
    }

    @Override
    public Optional<String> getAppConfigMap() {
        return this.appConfigMap;
    }

    @Override
    public SecurityContextConfig getSecurityContext() {
        return this.securityContext;
    }

    @Override
    public boolean isIdempotent() {
        return this.idempotent;
    }

    public DeployStrategy getDeployStrategy() {
        return this.deployStrategy;
    }

    @Override
    public RbacConfig getRbacConfig() {
        return this.rbac;
    }

    public static boolean isOpenshiftBuildEnabled(ContainerImageConfig containerImageConfig, Capabilities capabilities) {
        boolean implicitlyEnabled = ContainerImageCapabilitiesUtil.getActiveContainerImageCapability((Capabilities)capabilities).filter(c -> c.contains("openshift") || c.contains("s2i")).isPresent();
        return containerImageConfig.builder.map(b -> b.equals("openshift") || b.equals("s2i")).orElse(implicitlyEnabled);
    }

    public DeploymentResourceKind getDeploymentResourceKind(Capabilities capabilities) {
        if (this.deploymentKind.isPresent()) {
            return this.deploymentKind.get();
        }
        if (capabilities.isPresent("io.quarkus.picocli")) {
            return DeploymentResourceKind.Job;
        }
        return DeploymentResourceKind.DeploymentConfig;
    }

    public static enum DeploymentResourceKind {
        Deployment("Deployment", "apps", "v1"),
        DeploymentConfig("DeploymentConfig", "apps.openshift.io", "v1"),
        StatefulSet("StatefulSet", "apps", "v1"),
        Job("Job", "batch", "v1"),
        CronJob("CronJob", "batch", "v1");

        public final String kind;
        public final String apiGroup;
        public final String apiVersion;

        private DeploymentResourceKind(String kind, String apiGroup, String apiVersion) {
            this.kind = kind;
            this.apiGroup = apiGroup;
            this.apiVersion = apiVersion;
        }
    }

    public static enum OpenshiftFlavor {
        v3,
        v4;

    }
}

