/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.liquibase.runtime;

import io.agroal.api.AgroalDataSource;
import io.quarkus.agroal.runtime.DataSources;
import io.quarkus.arc.Arc;
import io.quarkus.liquibase.LiquibaseFactory;
import io.quarkus.liquibase.runtime.LiquibaseContainer;
import io.quarkus.liquibase.runtime.LiquibaseContainerProducer;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.sql.DataSource;
import liquibase.Liquibase;

@Recorder
public class LiquibaseRecorder {
    static final List<LiquibaseContainer> liquibaseContainers = new ArrayList<LiquibaseContainer>(2);

    public Supplier<LiquibaseFactory> liquibaseSupplier(String dataSourceName) {
        AgroalDataSource dataSource = DataSources.fromName((String)dataSourceName);
        LiquibaseContainerProducer liquibaseProducer = (LiquibaseContainerProducer)Arc.container().instance(LiquibaseContainerProducer.class, new Annotation[0]).get();
        final LiquibaseContainer liquibaseContainer = liquibaseProducer.createLiquibaseFactory((DataSource)dataSource, dataSourceName);
        liquibaseContainers.add(liquibaseContainer);
        return new Supplier<LiquibaseFactory>(){

            @Override
            public LiquibaseFactory get() {
                return liquibaseContainer.getLiquibaseFactory();
            }
        };
    }

    public void doStartActions() {
        try {
            for (LiquibaseContainer liquibaseContainer : liquibaseContainers) {
                Throwable throwable;
                Liquibase liquibase;
                LiquibaseFactory liquibaseFactory = liquibaseContainer.getLiquibaseFactory();
                if (liquibaseContainer.isCleanAtStart()) {
                    liquibase = liquibaseFactory.createLiquibase();
                    throwable = null;
                    try {
                        liquibase.dropAll();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (liquibase != null) {
                            if (throwable != null) {
                                try {
                                    liquibase.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                liquibase.close();
                            }
                        }
                    }
                }
                if (!liquibaseContainer.isMigrateAtStart()) continue;
                if (liquibaseContainer.isValidateOnMigrate()) {
                    liquibase = liquibaseFactory.createLiquibase();
                    throwable = null;
                    try {
                        liquibase.validate();
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (liquibase != null) {
                            if (throwable != null) {
                                try {
                                    liquibase.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                liquibase.close();
                            }
                        }
                    }
                }
                liquibase = liquibaseFactory.createLiquibase();
                throwable = null;
                try {
                    liquibase.update(liquibaseFactory.createContexts(), liquibaseFactory.createLabels());
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    if (liquibase == null) continue;
                    if (throwable != null) {
                        try {
                            liquibase.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                        continue;
                    }
                    liquibase.close();
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

