/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.liquibase.runtime.devconsole;

import io.quarkus.devconsole.runtime.spi.DevConsolePostHandler;
import io.quarkus.devconsole.runtime.spi.FlashScopeUtil;
import io.quarkus.liquibase.LiquibaseFactory;
import io.quarkus.liquibase.runtime.LiquibaseContainer;
import io.quarkus.liquibase.runtime.LiquibaseContainerSupplier;
import io.quarkus.runtime.annotations.Recorder;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.ext.web.RoutingContext;
import java.util.Iterator;
import liquibase.Liquibase;

@Recorder
public class LiquibaseDevConsoleRecorder {
    public Handler<RoutingContext> handler() {
        return new DevConsolePostHandler(){

            protected void handlePost(RoutingContext event, MultiMap form) throws Exception {
                String datasource = form.get("datasource");
                String operation = form.get("operation");
                Object liquibaseContainers = new LiquibaseContainerSupplier().get();
                Iterator iterator = liquibaseContainers.iterator();
                while (iterator.hasNext()) {
                    LiquibaseContainer liquibaseContainer = (LiquibaseContainer)iterator.next();
                    if (!liquibaseContainer.getDataSourceName().equals(datasource)) continue;
                    LiquibaseFactory liquibaseFactory = liquibaseContainer.getLiquibaseFactory();
                    if ("clean".equals(operation)) {
                        try (Liquibase liquibase = liquibaseFactory.createLiquibase();){
                            liquibase.dropAll();
                        }
                        this.flashMessage(event, "Data source " + datasource + " cleaned");
                        return;
                    }
                    if ("migrate".equals(operation)) {
                        try (Liquibase liquibase = liquibaseFactory.createLiquibase();){
                            liquibase.update(liquibaseFactory.createContexts(), liquibaseFactory.createLabels());
                        }
                        this.flashMessage(event, "Data source " + datasource + " migrated");
                        return;
                    }
                    this.flashMessage(event, "Invalid operation: " + operation, FlashScopeUtil.FlashMessageStatus.ERROR);
                    return;
                }
                this.flashMessage(event, "Unknown datasource: " + datasource, FlashScopeUtil.FlashMessageStatus.ERROR);
            }
        };
    }
}

