/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.health;

import com.mongodb.client.MongoClient;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.mongodb.MongoClientName;
import io.quarkus.mongodb.reactive.ReactiveMongoClient;
import io.quarkus.mongodb.runtime.MongoClientConfig;
import io.quarkus.mongodb.runtime.MongodbConfig;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.tuples.Tuple2;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.spi.Bean;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;

@Readiness
@ApplicationScoped
public class MongoHealthCheck
implements HealthCheck {
    public static final String CLIENT_DEFAULT = "<default>";
    public static final String CLIENT_DEFAULT_REACTIVE = "<default-reactive>";
    private static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(30L);
    private final List<Supplier<Uni<Tuple2<String, String>>>> checks = new ArrayList<Supplier<Uni<Tuple2<String, String>>>>();
    private static final Document COMMAND = new Document("ping", (Object)1);

    public void configure(final MongodbConfig config) {
        final Iterable handle = Arc.container().select(MongoClient.class, new Annotation[]{Any.Literal.INSTANCE}).handles();
        final Iterable reactiveHandlers = Arc.container().select(ReactiveMongoClient.class, new Annotation[]{Any.Literal.INSTANCE}).handles();
        if (config.defaultMongoClientConfig != null) {
            MongoClient client = this.getClient(handle, null);
            ReactiveMongoClient reactiveClient = this.getReactiveClient(reactiveHandlers, null);
            if (client != null) {
                this.checks.add(new MongoClientCheck(CLIENT_DEFAULT, client, config.defaultMongoClientConfig));
            }
            if (reactiveClient != null) {
                this.checks.add(new ReactiveMongoClientCheck(CLIENT_DEFAULT_REACTIVE, reactiveClient, config.defaultMongoClientConfig));
            }
        }
        config.mongoClientConfigs.forEach(new BiConsumer<String, MongoClientConfig>(){

            @Override
            public void accept(String name, MongoClientConfig cfg) {
                MongoClient client = MongoHealthCheck.this.getClient(handle, name);
                ReactiveMongoClient reactiveClient = MongoHealthCheck.this.getReactiveClient(reactiveHandlers, name);
                if (client != null) {
                    MongoHealthCheck.this.checks.add(new MongoClientCheck(name, client, config.defaultMongoClientConfig));
                }
                if (reactiveClient != null) {
                    MongoHealthCheck.this.checks.add(new ReactiveMongoClientCheck(name, reactiveClient, config.defaultMongoClientConfig));
                }
            }
        });
    }

    private MongoClient getClient(Iterable<InstanceHandle<MongoClient>> handle, String name) {
        for (InstanceHandle<MongoClient> client : handle) {
            String n = this.getMongoClientName((Bean<?>)client.getBean());
            if (name == null && n == null) {
                return (MongoClient)client.get();
            }
            if (name == null || !name.equals(n)) continue;
            return (MongoClient)client.get();
        }
        return null;
    }

    private ReactiveMongoClient getReactiveClient(Iterable<InstanceHandle<ReactiveMongoClient>> handle, String name) {
        for (InstanceHandle<ReactiveMongoClient> client : handle) {
            String n = this.getMongoClientName((Bean<?>)client.getBean());
            if (name == null && n == null) {
                return (ReactiveMongoClient)client.get();
            }
            if (name == null || !name.equals(n)) continue;
            return (ReactiveMongoClient)client.get();
        }
        return null;
    }

    private BiFunction<Document, Throwable, Tuple2<String, String>> toResult(final String name) {
        return new BiFunction<Document, Throwable, Tuple2<String, String>>(){

            @Override
            public Tuple2<String, String> apply(Document ignored, Throwable failure) {
                return Tuple2.of((Object)name, (Object)(failure == null ? "OK" : failure.getMessage()));
            }
        };
    }

    private String getMongoClientName(Bean<?> bean) {
        for (Object qualifier : bean.getQualifiers()) {
            if (!(qualifier instanceof MongoClientName)) continue;
            return ((MongoClientName)qualifier).value();
        }
        return null;
    }

    public HealthCheckResponse call() {
        final HealthCheckResponseBuilder builder = HealthCheckResponse.named((String)"MongoDB connection health check").up();
        ArrayList<Uni<Tuple2<String, String>>> unis = new ArrayList<Uni<Tuple2<String, String>>>();
        for (Supplier<Uni<Tuple2<String, String>>> client : this.checks) {
            unis.add(client.get());
        }
        if (unis.isEmpty()) {
            return builder.build();
        }
        return (HealthCheckResponse)Uni.combine().all().unis(unis).collectFailures().combinedWith(new Function<List<?>, HealthCheckResponse>(){

            @Override
            public HealthCheckResponse apply(List<?> list) {
                return MongoHealthCheck.this.combine(list, builder);
            }
        }).await().indefinitely();
    }

    private HealthCheckResponse combine(List<?> results, HealthCheckResponseBuilder builder) {
        for (Object result : results) {
            Tuple2 tuple = (Tuple2)result;
            if ("OK".equalsIgnoreCase((String)tuple.getItem2())) {
                builder.withData((String)tuple.getItem1(), "OK");
                continue;
            }
            builder.down().withData((String)tuple.getItem1(), "KO, reason: " + (String)tuple.getItem2());
        }
        return builder.build();
    }

    private class MongoClientCheck
    implements Supplier<Uni<Tuple2<String, String>>> {
        final String name;
        final MongoClient client;
        final MongoClientConfig config;

        MongoClientCheck(String name, MongoClient client, MongoClientConfig config) {
            this.name = name;
            this.client = client;
            this.config = config;
        }

        @Override
        public Uni<Tuple2<String, String>> get() {
            return Uni.createFrom().item((Supplier)new Supplier<Document>(){

                @Override
                public Document get() {
                    return MongoClientCheck.this.client.getDatabase(MongoClientCheck.this.config.healthDatabase).runCommand((Bson)COMMAND);
                }
            }).runSubscriptionOn(Infrastructure.getDefaultExecutor()).ifNoItem().after(this.config.readTimeout.orElse(DEFAULT_TIMEOUT)).fail().onItemOrFailure().transform(MongoHealthCheck.this.toResult(this.name));
        }
    }

    private class ReactiveMongoClientCheck
    implements Supplier<Uni<Tuple2<String, String>>> {
        final String name;
        final ReactiveMongoClient client;
        final MongoClientConfig config;

        ReactiveMongoClientCheck(String name, ReactiveMongoClient client, MongoClientConfig config) {
            this.name = name;
            this.client = client;
            this.config = config;
        }

        @Override
        public Uni<Tuple2<String, String>> get() {
            return this.client.getDatabase(this.config.healthDatabase).runCommand((Bson)COMMAND).ifNoItem().after(this.config.readTimeout.orElse(DEFAULT_TIMEOUT)).fail().onItemOrFailure().transform(MongoHealthCheck.this.toResult(this.name));
        }
    }
}

