/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.common.runtime;

import io.quarkus.oidc.common.runtime.config.OidcCommonConfig;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Optional;
import java.util.OptionalInt;

public class OidcCommonConfig {
    public Optional<String> authServerUrl = Optional.empty();
    public Optional<Boolean> discoveryEnabled = Optional.empty();
    public Optional<String> registrationPath = Optional.empty();
    public Optional<Duration> connectionDelay = Optional.empty();
    public int connectionRetryCount = 3;
    public Duration connectionTimeout = Duration.ofSeconds(10L);
    public boolean useBlockingDnsLookup;
    public OptionalInt maxPoolSize = OptionalInt.empty();
    public boolean followRedirects = true;
    public Proxy proxy = new Proxy();
    public Tls tls = new Tls();

    public OidcCommonConfig() {
    }

    protected OidcCommonConfig(io.quarkus.oidc.common.runtime.config.OidcCommonConfig mapping) {
        this.authServerUrl = mapping.authServerUrl();
        this.discoveryEnabled = mapping.discoveryEnabled();
        this.registrationPath = mapping.registrationPath();
        this.connectionDelay = mapping.connectionDelay();
        this.connectionRetryCount = mapping.connectionRetryCount();
        this.connectionTimeout = mapping.connectionTimeout();
        this.useBlockingDnsLookup = mapping.useBlockingDnsLookup();
        this.maxPoolSize = mapping.maxPoolSize();
        this.followRedirects = mapping.followRedirects();
        this.proxy.addConfigMappingValues(mapping.proxy());
        this.tls.addConfigMappingValues(mapping.tls());
    }

    public Optional<Duration> getConnectionDelay() {
        return this.connectionDelay;
    }

    public void setConnectionDelay(Duration connectionDelay) {
        this.connectionDelay = Optional.of(connectionDelay);
    }

    public Optional<String> getAuthServerUrl() {
        return this.authServerUrl;
    }

    public void setAuthServerUrl(String authServerUrl) {
        this.authServerUrl = Optional.of(authServerUrl);
    }

    public Optional<String> getRegistrationPath() {
        return this.registrationPath;
    }

    public void setRegistrationPath(String registrationPath) {
        this.registrationPath = Optional.of(registrationPath);
    }

    public Optional<Boolean> isDiscoveryEnabled() {
        return this.discoveryEnabled;
    }

    public void setDiscoveryEnabled(boolean enabled) {
        this.discoveryEnabled = Optional.of(enabled);
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public OptionalInt getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = OptionalInt.of(maxPoolSize);
    }

    public Optional<Boolean> getDiscoveryEnabled() {
        return this.discoveryEnabled;
    }

    public void setDiscoveryEnabled(Boolean discoveryEnabled) {
        this.discoveryEnabled = Optional.of(discoveryEnabled);
    }

    public static class Proxy {
        public Optional<String> host = Optional.empty();
        public int port = 80;
        public Optional<String> username = Optional.empty();
        public Optional<String> password = Optional.empty();

        private void addConfigMappingValues(OidcCommonConfig.Proxy mapping) {
            this.host = mapping.host();
            this.port = mapping.port();
            this.username = mapping.username();
            this.password = mapping.password();
        }
    }

    public static class Tls {
        Optional<String> tlsConfigurationName = Optional.empty();
        public Optional<Verification> verification = Optional.empty();
        public Optional<Path> keyStoreFile = Optional.empty();
        public Optional<String> keyStoreFileType = Optional.empty();
        public Optional<String> keyStoreProvider;
        public Optional<String> keyStorePassword;
        public Optional<String> keyStoreKeyAlias = Optional.empty();
        public Optional<String> keyStoreKeyPassword = Optional.empty();
        public Optional<Path> trustStoreFile = Optional.empty();
        public Optional<String> trustStorePassword = Optional.empty();
        public Optional<String> trustStoreCertAlias = Optional.empty();
        public Optional<String> trustStoreFileType = Optional.empty();
        public Optional<String> trustStoreProvider;

        private void addConfigMappingValues(OidcCommonConfig.Tls mapping) {
            this.tlsConfigurationName = mapping.tlsConfigurationName();
            this.verification = mapping.verification().map(Enum::toString).map(Verification::valueOf);
            this.keyStoreFile = mapping.keyStoreFile();
            this.keyStoreFileType = mapping.keyStoreFileType();
            this.keyStoreProvider = mapping.keyStoreProvider();
            this.keyStorePassword = mapping.keyStorePassword();
            this.keyStoreKeyAlias = mapping.keyStoreKeyAlias();
            this.keyStoreKeyPassword = mapping.keyStoreKeyPassword();
            this.trustStoreFile = mapping.trustStoreFile();
            this.trustStorePassword = mapping.trustStorePassword();
            this.trustStoreCertAlias = mapping.trustStoreCertAlias();
            this.trustStoreFileType = mapping.trustStoreFileType();
            this.trustStoreProvider = mapping.trustStoreProvider();
        }

        public Optional<Verification> getVerification() {
            return this.verification;
        }

        public void setVerification(Verification verification) {
            this.verification = Optional.of(verification);
        }

        public Optional<Path> getTrustStoreFile() {
            return this.trustStoreFile;
        }

        public void setTrustStoreFile(Path trustStoreFile) {
            this.trustStoreFile = Optional.of(trustStoreFile);
        }

        public Optional<String> getTrustStorePassword() {
            return this.trustStorePassword;
        }

        public void setTrustStorePassword(String trustStorePassword) {
            this.trustStorePassword = Optional.of(trustStorePassword);
        }

        public Optional<String> getTrustStoreCertAlias() {
            return this.trustStoreCertAlias;
        }

        public void setTrustStoreCertAlias(String trustStoreCertAlias) {
            this.trustStoreCertAlias = Optional.of(trustStoreCertAlias);
        }

        public Optional<String> getKeyStoreProvider() {
            return this.keyStoreProvider;
        }

        public void setKeyStoreProvider(String keyStoreProvider) {
            this.keyStoreProvider = Optional.of(keyStoreProvider);
        }

        public Optional<String> getTrustStoreProvider() {
            return this.trustStoreProvider;
        }

        public void setTrustStoreProvider(String trustStoreProvider) {
            this.trustStoreProvider = Optional.of(trustStoreProvider);
        }

        public static enum Verification {
            REQUIRED,
            CERTIFICATE_VALIDATION,
            NONE;

        }
    }
}

