/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.common.runtime.config;

import io.quarkus.oidc.common.runtime.config.OidcClientCommonConfig;
import io.quarkus.oidc.common.runtime.config.OidcCommonConfigBuilder;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public abstract class OidcClientCommonConfigBuilder<T>
extends OidcCommonConfigBuilder<T> {
    private Optional<String> tokenPath;
    private Optional<String> revokePath;
    private Optional<String> clientId;
    private Optional<String> clientName;
    private OidcClientCommonConfig.Credentials credentials;

    protected OidcClientCommonConfigBuilder(OidcClientCommonConfig oidcClientCommonConfig) {
        super(oidcClientCommonConfig);
        this.tokenPath = oidcClientCommonConfig.tokenPath();
        this.revokePath = oidcClientCommonConfig.revokePath();
        this.clientId = oidcClientCommonConfig.clientId();
        this.clientName = oidcClientCommonConfig.clientName();
        this.credentials = oidcClientCommonConfig.credentials();
    }

    public T tokenPath(String tokenPath) {
        this.tokenPath = Optional.ofNullable(tokenPath);
        return this.getBuilder();
    }

    public T revokePath(String revokePath) {
        this.revokePath = Optional.ofNullable(revokePath);
        return this.getBuilder();
    }

    public T clientId(String clientId) {
        this.clientId = Optional.ofNullable(clientId);
        return this.getBuilder();
    }

    public T clientName(String clientName) {
        this.clientName = Optional.ofNullable(clientName);
        return this.getBuilder();
    }

    public T credentials(OidcClientCommonConfig.Credentials credentials) {
        this.credentials = Objects.requireNonNull(credentials);
        return this.getBuilder();
    }

    public CredentialsBuilder<T> credentials() {
        return new CredentialsBuilder(this);
    }

    public T credentials(String secret) {
        return this.credentials().secret(secret).end();
    }

    public T credentials(OidcClientCommonConfig.Credentials.Secret clientSecret) {
        Objects.requireNonNull(clientSecret);
        return this.credentials().clientSecret(clientSecret).end();
    }

    public T credentials(OidcClientCommonConfig.Credentials.Jwt jwt) {
        Objects.requireNonNull(jwt);
        return this.credentials().jwt(jwt).end();
    }

    public static final class CredentialsBuilder<T> {
        private final OidcClientCommonConfigBuilder<T> builder;
        private Optional<String> secret;
        private OidcClientCommonConfig.Credentials.Secret clientSecret;
        private OidcClientCommonConfig.Credentials.Jwt jwt;

        public CredentialsBuilder() {
            this.builder = null;
            this.secret = Optional.empty();
            this.clientSecret = new SecretBuilder().build();
            this.jwt = new JwtBuilder().build();
        }

        public CredentialsBuilder(OidcClientCommonConfigBuilder<T> builder) {
            this.builder = builder;
            this.secret = builder.credentials.secret();
            this.clientSecret = builder.credentials.clientSecret();
            this.jwt = builder.credentials.jwt();
        }

        public CredentialsBuilder<T> secret(String secret) {
            this.secret = Optional.ofNullable(secret);
            return this;
        }

        public CredentialsBuilder<T> clientSecret(OidcClientCommonConfig.Credentials.Secret clientSecret) {
            this.clientSecret = Objects.requireNonNull(clientSecret);
            return this;
        }

        public SecretBuilder<T> clientSecret() {
            return new SecretBuilder(this);
        }

        public CredentialsBuilder<T> clientSecret(String value) {
            return this.clientSecret().value(value).end();
        }

        public CredentialsBuilder<T> clientSecret(OidcClientCommonConfig.Credentials.Provider provider) {
            return this.clientSecret().provider(provider).end();
        }

        public CredentialsBuilder<T> clientSecret(String value, OidcClientCommonConfig.Credentials.Secret.Method method) {
            return this.clientSecret().value(value).method(method).end();
        }

        public CredentialsBuilder<T> jwt(OidcClientCommonConfig.Credentials.Jwt jwt) {
            this.jwt = Objects.requireNonNull(jwt);
            return this;
        }

        public JwtBuilder<T> jwt() {
            return new JwtBuilder(this);
        }

        public T end() {
            Objects.requireNonNull(this.builder);
            return this.builder.credentials(this.build());
        }

        public OidcClientCommonConfig.Credentials build() {
            return new CredentialsImpl(this.secret, this.clientSecret, this.jwt);
        }

        private record CredentialsImpl(Optional<String> secret, OidcClientCommonConfig.Credentials.Secret clientSecret, OidcClientCommonConfig.Credentials.Jwt jwt) implements OidcClientCommonConfig.Credentials
        {
        }
    }

    public static final class JwtBuilder<T> {
        private final CredentialsBuilder<T> builder;
        private final Map<String, String> claims = new HashMap<String, String>();
        private OidcClientCommonConfig.Credentials.Jwt.Source source;
        private Optional<String> secret;
        private OidcClientCommonConfig.Credentials.Provider secretProvider;
        private Optional<String> key;
        private Optional<String> keyFile;
        private Optional<String> keyStoreFile;
        private Optional<String> keyStorePassword;
        private Optional<String> keyId;
        private Optional<String> keyPassword;
        private Optional<String> audience;
        private Optional<String> tokenKeyId;
        private Optional<String> issuer;
        private Optional<String> subject;
        private Optional<String> signatureAlgorithm;
        private Optional<Path> tokenPath;
        private int lifespan;
        private boolean assertion;

        public JwtBuilder() {
            this.builder = null;
            this.source = OidcClientCommonConfig.Credentials.Jwt.Source.CLIENT;
            this.secret = Optional.empty();
            this.secretProvider = new ProviderBuilder().build();
            this.key = Optional.empty();
            this.keyFile = Optional.empty();
            this.keyStoreFile = Optional.empty();
            this.keyStorePassword = Optional.empty();
            this.keyId = Optional.empty();
            this.keyPassword = Optional.empty();
            this.audience = Optional.empty();
            this.tokenKeyId = Optional.empty();
            this.issuer = Optional.empty();
            this.subject = Optional.empty();
            this.signatureAlgorithm = Optional.empty();
            this.lifespan = 10;
            this.assertion = false;
            this.tokenPath = Optional.empty();
        }

        public JwtBuilder(CredentialsBuilder<T> builder) {
            this(Objects.requireNonNull(builder), builder.jwt);
        }

        private JwtBuilder(CredentialsBuilder<T> builder, OidcClientCommonConfig.Credentials.Jwt jwt) {
            this.builder = builder;
            this.source = jwt.source();
            this.secret = jwt.secret();
            this.secretProvider = jwt.secretProvider();
            this.key = jwt.key();
            this.keyFile = jwt.keyFile();
            this.keyStoreFile = jwt.keyStoreFile();
            this.keyStorePassword = jwt.keyStorePassword();
            this.keyId = jwt.keyId();
            this.keyPassword = jwt.keyPassword();
            this.audience = jwt.audience();
            this.tokenKeyId = jwt.tokenKeyId();
            this.issuer = jwt.issuer();
            this.subject = jwt.subject();
            this.claims.putAll(jwt.claims());
            this.signatureAlgorithm = jwt.signatureAlgorithm();
            this.lifespan = jwt.lifespan();
            this.assertion = jwt.assertion();
            this.tokenPath = jwt.tokenPath();
        }

        public JwtBuilder<T> tokenPath(Path tokenPath) {
            this.tokenPath = Optional.ofNullable(tokenPath);
            return this;
        }

        public ProviderBuilder<JwtBuilder<T>> secretProvider() {
            return new ProviderBuilder<JwtBuilder<T>>(this::secretProvider, this.secretProvider);
        }

        public JwtBuilder<T> secretProvider(OidcClientCommonConfig.Credentials.Provider secretProvider) {
            Objects.requireNonNull(secretProvider);
            this.secretProvider = secretProvider;
            return this;
        }

        public JwtBuilder<T> source(OidcClientCommonConfig.Credentials.Jwt.Source source) {
            Objects.requireNonNull(source);
            this.source = source;
            return this;
        }

        public JwtBuilder<T> secret(String secret) {
            this.secret = Optional.ofNullable(secret);
            return this;
        }

        public JwtBuilder<T> key(String key) {
            this.key = Optional.ofNullable(key);
            return this;
        }

        public JwtBuilder<T> keyFile(String keyFile) {
            this.keyFile = Optional.ofNullable(keyFile);
            return this;
        }

        public JwtBuilder<T> keyStoreFile(String keyStoreFile) {
            this.keyStoreFile = Optional.ofNullable(keyStoreFile);
            return this;
        }

        public JwtBuilder<T> keyStorePassword(String keyStorePassword) {
            this.keyStorePassword = Optional.ofNullable(keyStorePassword);
            return this;
        }

        public JwtBuilder<T> keyId(String keyId) {
            this.keyId = Optional.ofNullable(keyId);
            return this;
        }

        public JwtBuilder<T> keyPassword(String keyPassword) {
            this.keyPassword = Optional.ofNullable(keyPassword);
            return this;
        }

        public JwtBuilder<T> audience(String audience) {
            this.audience = Optional.ofNullable(audience);
            return this;
        }

        public JwtBuilder<T> tokenKeyId(String tokenKeyId) {
            this.tokenKeyId = Optional.ofNullable(tokenKeyId);
            return this;
        }

        public JwtBuilder<T> issuer(String issuer) {
            this.issuer = Optional.ofNullable(issuer);
            return this;
        }

        public JwtBuilder<T> subject(String subject) {
            this.subject = Optional.ofNullable(subject);
            return this;
        }

        public JwtBuilder<T> claim(String claimName, String claimValue) {
            Objects.requireNonNull(claimName);
            Objects.requireNonNull(claimValue);
            this.claims.put(claimName, claimValue);
            return this;
        }

        public JwtBuilder<T> claims(Map<String, String> claims) {
            Objects.requireNonNull(claims);
            this.claims.putAll(claims);
            return this;
        }

        public JwtBuilder<T> signatureAlgorithm(String signatureAlgorithm) {
            this.signatureAlgorithm = Optional.ofNullable(signatureAlgorithm);
            return this;
        }

        public JwtBuilder<T> lifespan(int lifespan) {
            this.lifespan = lifespan;
            return this;
        }

        public JwtBuilder<T> assertion(boolean assertion) {
            this.assertion = assertion;
            return this;
        }

        public CredentialsBuilder<T> end() {
            Objects.requireNonNull(this.builder);
            return this.builder.jwt(this.build());
        }

        public T endCredentials() {
            return this.end().end();
        }

        public OidcClientCommonConfig.Credentials.Jwt build() {
            return new JwtImpl(this.source, this.secret, this.secretProvider, this.key, this.keyFile, this.keyStoreFile, this.keyStorePassword, this.keyId, this.keyPassword, this.audience, this.tokenKeyId, this.issuer, this.subject, Map.copyOf(this.claims), this.signatureAlgorithm, this.lifespan, this.assertion, this.tokenPath);
        }

        private record JwtImpl(OidcClientCommonConfig.Credentials.Jwt.Source source, Optional<String> secret, OidcClientCommonConfig.Credentials.Provider secretProvider, Optional<String> key, Optional<String> keyFile, Optional<String> keyStoreFile, Optional<String> keyStorePassword, Optional<String> keyId, Optional<String> keyPassword, Optional<String> audience, Optional<String> tokenKeyId, Optional<String> issuer, Optional<String> subject, Map<String, String> claims, Optional<String> signatureAlgorithm, int lifespan, boolean assertion, Optional<Path> tokenPath) implements OidcClientCommonConfig.Credentials.Jwt
        {
        }
    }

    public static final class ProviderBuilder<T> {
        private final Function<OidcClientCommonConfig.Credentials.Provider, T> providerSetter;
        private Optional<String> name;
        private Optional<String> keyringName;
        private Optional<String> key;

        private ProviderBuilder(Function<OidcClientCommonConfig.Credentials.Provider, T> providerSetter, OidcClientCommonConfig.Credentials.Provider provider) {
            this.providerSetter = providerSetter;
            this.name = provider.name();
            this.keyringName = provider.keyringName();
            this.key = provider.key();
        }

        public ProviderBuilder() {
            this.providerSetter = null;
            this.name = Optional.empty();
            this.keyringName = Optional.empty();
            this.key = Optional.empty();
        }

        public ProviderBuilder<T> name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        public ProviderBuilder<T> keyringName(String keyringName) {
            this.keyringName = Optional.ofNullable(keyringName);
            return this;
        }

        public ProviderBuilder<T> key(String key) {
            this.key = Optional.ofNullable(key);
            return this;
        }

        public T end() {
            Objects.requireNonNull(this.providerSetter);
            return this.providerSetter.apply(this.build());
        }

        public OidcClientCommonConfig.Credentials.Provider build() {
            return new ProviderImpl(this.name, this.keyringName, this.key);
        }

        private record ProviderImpl(Optional<String> name, Optional<String> keyringName, Optional<String> key) implements OidcClientCommonConfig.Credentials.Provider
        {
        }
    }

    public static final class SecretBuilder<T> {
        private final CredentialsBuilder<T> builder;
        private Optional<String> value;
        private Optional<OidcClientCommonConfig.Credentials.Secret.Method> method;
        private OidcClientCommonConfig.Credentials.Provider provider;

        public SecretBuilder() {
            this.builder = null;
            this.value = Optional.empty();
            this.method = Optional.empty();
            this.provider = new ProviderBuilder().build();
        }

        public SecretBuilder(CredentialsBuilder<T> builder) {
            this.builder = Objects.requireNonNull(builder);
            this.value = builder.clientSecret.value();
            this.method = builder.clientSecret.method();
            this.provider = builder.clientSecret.provider();
        }

        public SecretBuilder<T> method(OidcClientCommonConfig.Credentials.Secret.Method method) {
            this.method = Optional.ofNullable(method);
            return this;
        }

        public SecretBuilder<T> value(String value) {
            this.value = Optional.ofNullable(value);
            return this;
        }

        public SecretBuilder<T> provider(OidcClientCommonConfig.Credentials.Provider provider) {
            this.provider = Objects.requireNonNull(provider);
            return this;
        }

        public SecretBuilder<T> provider(String key) {
            return this.provider().key(key).end();
        }

        public SecretBuilder<T> provider(String key, String name) {
            return this.provider().key(key).name(name).end();
        }

        public SecretBuilder<T> provider(String key, String name, String keyringName) {
            return this.provider().key(key).name(name).keyringName(keyringName).end();
        }

        public ProviderBuilder<SecretBuilder<T>> provider() {
            return new ProviderBuilder<SecretBuilder<T>>(this::provider, this.provider);
        }

        public CredentialsBuilder<T> end() {
            Objects.requireNonNull(this.builder);
            return this.builder.clientSecret(this.build());
        }

        public T endCredentials() {
            return this.end().end();
        }

        public OidcClientCommonConfig.Credentials.Secret build() {
            return new SecretImpl(this.value, this.method, this.provider);
        }

        private record SecretImpl(Optional<String> value, Optional<OidcClientCommonConfig.Credentials.Secret.Method> method, OidcClientCommonConfig.Credentials.Provider provider) implements OidcClientCommonConfig.Credentials.Secret
        {
        }
    }

    protected static class OidcClientCommonConfigImpl
    extends OidcCommonConfigBuilder.OidcCommonConfigImpl
    implements OidcClientCommonConfig {
        private final Optional<String> tokenPath;
        private final Optional<String> revokePath;
        private final Optional<String> clientId;
        private final Optional<String> clientName;
        private final OidcClientCommonConfig.Credentials credentials;

        protected OidcClientCommonConfigImpl(OidcClientCommonConfigBuilder<?> builder) {
            super(builder);
            this.tokenPath = builder.tokenPath;
            this.revokePath = builder.revokePath;
            this.clientId = builder.clientId;
            this.clientName = builder.clientName;
            this.credentials = builder.credentials;
        }

        @Override
        public Optional<String> tokenPath() {
            return this.tokenPath;
        }

        @Override
        public Optional<String> revokePath() {
            return this.revokePath;
        }

        @Override
        public Optional<String> clientId() {
            return this.clientId;
        }

        @Override
        public Optional<String> clientName() {
            return this.clientName;
        }

        @Override
        public OidcClientCommonConfig.Credentials credentials() {
            return this.credentials;
        }
    }
}

