/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.arc.BeanDestroyer;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.smallrye.mutiny.Uni;
import jakarta.enterprise.context.spi.CreationalContext;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class TenantConfigBean {
    private final Map<String, TenantConfigContext> staticTenantsConfig;
    private final Map<String, TenantConfigContext> dynamicTenantsConfig;
    private final TenantConfigContext defaultTenant;
    private final TenantContextFactory tenantContextFactory;

    public TenantConfigBean(Map<String, TenantConfigContext> staticTenantsConfig, TenantConfigContext defaultTenant, TenantContextFactory tenantContextFactory) {
        this.staticTenantsConfig = Map.copyOf(staticTenantsConfig);
        this.dynamicTenantsConfig = new ConcurrentHashMap<String, TenantConfigContext>();
        this.defaultTenant = defaultTenant;
        this.tenantContextFactory = tenantContextFactory;
    }

    public Uni<TenantConfigContext> createDynamicTenantContext(OidcTenantConfig oidcConfig) {
        final String tenantId = oidcConfig.tenantId.orElseThrow();
        TenantConfigContext tenant = this.dynamicTenantsConfig.get(tenantId);
        if (tenant != null) {
            return Uni.createFrom().item((Object)tenant);
        }
        return this.tenantContextFactory.create(oidcConfig).onItem().transform((Function)new Function<TenantConfigContext, TenantConfigContext>(){

            @Override
            public TenantConfigContext apply(TenantConfigContext t) {
                TenantConfigBean.this.dynamicTenantsConfig.putIfAbsent(tenantId, t);
                return t;
            }
        });
    }

    public Map<String, TenantConfigContext> getStaticTenantsConfig() {
        return this.staticTenantsConfig;
    }

    public TenantConfigContext getStaticTenant(String tenantId) {
        return this.staticTenantsConfig.get(tenantId);
    }

    public TenantConfigContext getDefaultTenant() {
        return this.defaultTenant;
    }

    public TenantConfigContext getDynamicTenant(String tenantId) {
        return this.dynamicTenantsConfig.get(tenantId);
    }

    @FunctionalInterface
    public static interface TenantContextFactory {
        public Uni<TenantConfigContext> create(OidcTenantConfig var1);
    }

    public static class Destroyer
    implements BeanDestroyer<TenantConfigBean> {
        public void destroy(TenantConfigBean instance, CreationalContext<TenantConfigBean> creationalContext, Map<String, Object> params) {
            if (instance.defaultTenant != null && instance.defaultTenant.provider() != null) {
                instance.defaultTenant.provider().close();
            }
            for (TenantConfigContext i : instance.staticTenantsConfig.values()) {
                if (i.provider() == null) continue;
                i.provider().close();
            }
            for (TenantConfigContext i : instance.dynamicTenantsConfig.values()) {
                if (i.provider() == null) continue;
                i.provider().close();
            }
        }
    }
}

