/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime.devui;

import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.oidc.runtime.devui.OidcDevJsonRpcService;
import io.quarkus.oidc.runtime.devui.OidcDevServicesUtils;
import io.quarkus.oidc.runtime.devui.OidcDevSessionCookieReaderHandler;
import io.quarkus.oidc.runtime.devui.OidcDevSessionLogoutHandler;
import io.quarkus.oidc.runtime.devui.OidcDevUiRpcSvcPropertiesBean;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.vertx.core.runtime.VertxCoreRecorder;
import io.quarkus.vertx.http.runtime.VertxHttpConfig;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.mutiny.ext.web.client.HttpResponse;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;

@Recorder
public class OidcDevUiRecorder {
    private static final Logger LOG = Logger.getLogger(OidcDevUiRecorder.class);

    public void createJsonRPCService(BeanContainer beanContainer, RuntimeValue<OidcDevUiRpcSvcPropertiesBean> oidcDevUiRpcSvcPropertiesBean, VertxHttpConfig httpConfig) {
        OidcDevJsonRpcService jsonRpcService = (OidcDevJsonRpcService)beanContainer.beanInstance(OidcDevJsonRpcService.class, new Annotation[0]);
        jsonRpcService.hydrate((OidcDevUiRpcSvcPropertiesBean)oidcDevUiRpcSvcPropertiesBean.getValue(), httpConfig);
    }

    public RuntimeValue<OidcDevUiRpcSvcPropertiesBean> getRpcServiceProperties(String authorizationUrl, String tokenUrl, String logoutUrl, Duration webClientTimeout, Map<String, Map<String, String>> grantOptions, Map<String, String> oidcUsers, String oidcProviderName, String oidcApplicationType, String oidcGrantType, boolean introspectionIsAvailable, String keycloakAdminUrl, List<String> keycloakRealms, boolean swaggerIsAvailable, boolean graphqlIsAvailable, String swaggerUiPath, String graphqlUiPath, boolean alwaysLogoutUserInDevUiOnReload, boolean discoverMetadata, String authServerUrl) {
        JsonObject metadata;
        if (discoverMetadata && (metadata = OidcDevUiRecorder.discoverMetadata(authServerUrl)) != null) {
            authorizationUrl = metadata.getString("authorization_endpoint");
            tokenUrl = metadata.getString("token_endpoint");
            logoutUrl = metadata.getString("end_session_endpoint");
            introspectionIsAvailable = metadata.containsKey("introspection_endpoint") || metadata.containsKey("userinfo_endpoint");
        }
        return new RuntimeValue((Object)new OidcDevUiRpcSvcPropertiesBean(authorizationUrl, tokenUrl, logoutUrl, webClientTimeout, grantOptions, oidcUsers, oidcProviderName, oidcApplicationType, oidcGrantType, introspectionIsAvailable, keycloakAdminUrl, keycloakRealms, swaggerIsAvailable, graphqlIsAvailable, swaggerUiPath, graphqlUiPath, alwaysLogoutUserInDevUiOnReload));
    }

    public Handler<RoutingContext> readSessionCookieHandler() {
        return new OidcDevSessionCookieReaderHandler();
    }

    public Handler<RoutingContext> logoutHandler() {
        return new OidcDevSessionLogoutHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JsonObject discoverMetadata(String authServerUrl) {
        try (WebClient client = OidcDevServicesUtils.createWebClient((Vertx)VertxCoreRecorder.getVertx().get());){
            String metadataUrl = authServerUrl + "/.well-known/openid-configuration";
            LOG.infof("OIDC Dev Console: discovering the provider metadata at %s", (Object)metadataUrl);
            HttpResponse resp = (HttpResponse)client.getAbs(metadataUrl).putHeader(HttpHeaders.ACCEPT.toString(), "application/json").send().await().indefinitely();
            if (resp.statusCode() == 200) {
                JsonObject jsonObject = resp.bodyAsJsonObject();
                return jsonObject;
            }
            LOG.errorf("OIDC metadata discovery failed: %s", (Object)resp.bodyAsString());
            JsonObject jsonObject = null;
            return jsonObject;
        }
    }
}

