/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing.intrumentation.vertx;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerRoute;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerRouteBiGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerRouteSource;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import io.opentelemetry.semconv.SemanticAttributes;
import io.quarkus.opentelemetry.runtime.config.runtime.SemconvStabilityType;
import io.quarkus.opentelemetry.runtime.tracing.intrumentation.vertx.InstrumenterVertxTracer;
import io.quarkus.opentelemetry.runtime.tracing.intrumentation.vertx.OpenTelemetryVertxTracer;
import io.quarkus.opentelemetry.runtime.tracing.intrumentation.vertx.VertxUtil;
import io.smallrye.common.vertx.VertxContext;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.impl.HttpRequestHead;
import io.vertx.core.http.impl.headers.HeadersAdaptor;
import io.vertx.core.http.impl.headers.HeadersMultiMap;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.observability.HttpRequest;
import io.vertx.core.spi.observability.HttpResponse;
import io.vertx.core.spi.tracing.SpanKind;
import io.vertx.core.spi.tracing.TagExtractor;
import io.vertx.core.tracing.TracingPolicy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;

public class HttpInstrumenterVertxTracer
implements InstrumenterVertxTracer<HttpRequest, HttpResponse> {
    private final Instrumenter<HttpRequest, HttpResponse> serverInstrumenter;
    private final Instrumenter<HttpRequest, HttpResponse> clientInstrumenter;

    public HttpInstrumenterVertxTracer(OpenTelemetry openTelemetry, SemconvStabilityType semconvStability) {
        this.serverInstrumenter = HttpInstrumenterVertxTracer.getServerInstrumenter(openTelemetry, semconvStability);
        this.clientInstrumenter = HttpInstrumenterVertxTracer.getClientInstrumenter(openTelemetry);
    }

    @Override
    public <R> boolean canHandle(R request, TagExtractor<R> tagExtractor) {
        return request instanceof HttpRequest;
    }

    @Override
    public Instrumenter<HttpRequest, HttpResponse> getReceiveRequestInstrumenter() {
        return this.serverInstrumenter;
    }

    @Override
    public Instrumenter<HttpRequest, HttpResponse> getSendResponseInstrumenter() {
        return this.serverInstrumenter;
    }

    @Override
    public Instrumenter<HttpRequest, HttpResponse> getSendRequestInstrumenter() {
        return this.clientInstrumenter;
    }

    @Override
    public Instrumenter<HttpRequest, HttpResponse> getReceiveResponseInstrumenter() {
        return this.clientInstrumenter;
    }

    @Override
    public OpenTelemetryVertxTracer.SpanOperation spanOperation(io.vertx.core.Context context, HttpRequest request, MultiMap headers, Context spanContext, Scope scope) {
        HttpRequestSpan requestSpan = HttpRequestSpan.request(request, headers, context, spanContext);
        return OpenTelemetryVertxTracer.SpanOperation.span(context, requestSpan, headers, spanContext, scope);
    }

    @Override
    public <R> void sendResponse(io.vertx.core.Context context, R response, OpenTelemetryVertxTracer.SpanOperation spanOperation, Throwable failure, TagExtractor<R> tagExtractor) {
        HttpServerRoute.update((Context)spanOperation.getSpanContext(), (HttpServerRouteSource)HttpServerRouteSource.SERVER_FILTER, (HttpServerRouteBiGetter)RouteGetter.ROUTE_GETTER, (Object)((HttpRequestSpan)spanOperation.getRequest()), (Object)((HttpResponse)response));
        InstrumenterVertxTracer.super.sendResponse(context, response, spanOperation, failure, tagExtractor);
    }

    @Override
    public <R> OpenTelemetryVertxTracer.SpanOperation sendRequest(io.vertx.core.Context context, SpanKind kind, TracingPolicy policy, R request, String operation, BiConsumer<String, String> headers, TagExtractor<R> tagExtractor) {
        String pathTemplate;
        io.vertx.core.Context runningCtx;
        Object spanOperation = InstrumenterVertxTracer.super.sendRequest(context, kind, policy, (Object)request, operation, (BiConsumer)headers, (TagExtractor)tagExtractor);
        if (spanOperation != null && VertxContext.isDuplicatedContext((io.vertx.core.Context)(runningCtx = ((OpenTelemetryVertxTracer.SpanOperation)spanOperation).getContext())) && (pathTemplate = (String)runningCtx.getLocal((Object)"ClientUrlPathTemplate")) != null && !pathTemplate.isEmpty()) {
            Span.fromContext((Context)((OpenTelemetryVertxTracer.SpanOperation)spanOperation).getSpanContext()).updateName(((HttpRequest)((OpenTelemetryVertxTracer.SpanOperation)spanOperation).getRequest()).method().name() + " " + pathTemplate);
        }
        return spanOperation;
    }

    @Override
    public HttpRequest writableHeaders(HttpRequest request, BiConsumer<String, String> headers) {
        return WriteHeadersHttpRequest.request(request, headers);
    }

    private static Instrumenter<HttpRequest, HttpResponse> getServerInstrumenter(OpenTelemetry openTelemetry, SemconvStabilityType semconvStability) {
        ServerAttributesExtractor serverAttributesExtractor = new ServerAttributesExtractor();
        InstrumenterBuilder serverBuilder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"io.quarkus.opentelemetry", (SpanNameExtractor)HttpSpanNameExtractor.create((HttpServerAttributesGetter)serverAttributesExtractor));
        return serverBuilder.setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpServerAttributesGetter)serverAttributesExtractor)).addAttributesExtractor(HttpServerAttributesExtractor.create((HttpServerAttributesGetter)serverAttributesExtractor)).addAttributesExtractor((AttributesExtractor)new AdditionalServerAttributesExtractor(semconvStability)).addContextCustomizer(HttpServerRoute.create((HttpServerAttributesGetter)serverAttributesExtractor)).buildServerInstrumenter((TextMapGetter)new HttpRequestTextMapGetter());
    }

    private static Instrumenter<HttpRequest, HttpResponse> getClientInstrumenter(OpenTelemetry openTelemetry) {
        ServerAttributesExtractor serverAttributesExtractor = new ServerAttributesExtractor();
        HttpClientAttributesExtractor httpClientAttributesExtractor = new HttpClientAttributesExtractor();
        InstrumenterBuilder clientBuilder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"io.quarkus.opentelemetry", (SpanNameExtractor)new ClientSpanNameExtractor(httpClientAttributesExtractor));
        return clientBuilder.setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpServerAttributesGetter)serverAttributesExtractor)).addAttributesExtractor(io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractor.create((HttpClientAttributesGetter)httpClientAttributesExtractor)).buildClientInstrumenter((TextMapSetter)new HttpRequestTextMapSetter());
    }

    private static String getHttpVersion(HttpRequest request) {
        HttpVersion version;
        if (request instanceof HttpServerRequest && (version = ((HttpServerRequest)request).version()) != null) {
            switch (version) {
                case HTTP_1_0: {
                    return "1.0";
                }
                case HTTP_1_1: {
                    return "1.1";
                }
                case HTTP_2: {
                    return "2.0";
                }
            }
            return version.alpnName();
        }
        return null;
    }

    static class HttpRequestSpan
    implements HttpRequest {
        private final HttpRequest httpRequest;
        private final MultiMap headers;
        private final io.vertx.core.Context context;
        private final Context spanContext;

        HttpRequestSpan(HttpRequest httpRequest, MultiMap headers, io.vertx.core.Context context, Context spanContext) {
            this.httpRequest = httpRequest;
            this.headers = headers;
            this.context = context;
            this.spanContext = spanContext;
        }

        public int id() {
            return this.httpRequest.id();
        }

        public String uri() {
            return this.httpRequest.uri();
        }

        public String absoluteURI() {
            return this.httpRequest.absoluteURI();
        }

        public HttpMethod method() {
            return this.httpRequest.method();
        }

        public MultiMap headers() {
            return this.headers;
        }

        public SocketAddress remoteAddress() {
            return this.httpRequest.remoteAddress();
        }

        public io.vertx.core.Context getContext() {
            if (this.context == null) {
                throw new IllegalStateException("The Vert.x Context is not set");
            }
            return this.context;
        }

        public Context getSpanContext() {
            if (this.spanContext == null) {
                throw new IllegalStateException("The OpenTelemetry Context is not set");
            }
            return this.spanContext;
        }

        static HttpRequestSpan request(HttpRequest httpRequest, MultiMap headers, io.vertx.core.Context context, Context spanContext) {
            return new HttpRequestSpan(httpRequest, headers, context, spanContext);
        }
    }

    private static class RouteGetter
    implements HttpServerRouteBiGetter<HttpRequestSpan, HttpResponse> {
        static final RouteGetter ROUTE_GETTER = new RouteGetter();

        private RouteGetter() {
        }

        public String get(Context context, HttpRequestSpan requestSpan, HttpResponse response) {
            String route = (String)requestSpan.getContext().getLocal((Object)"UrlPathTemplate");
            if (route == null) {
                route = (String)requestSpan.getContext().getLocal((Object)"VertxRoute");
            }
            if (route != null && route.length() >= 1) {
                return route;
            }
            if (response != null && HttpResponseStatus.NOT_FOUND.code() == response.statusCode()) {
                return "/*";
            }
            return null;
        }
    }

    private static class WriteHeadersHttpRequest
    implements HttpRequest {
        private final HttpRequest httpRequest;
        private final BiConsumer<String, String> headers;

        WriteHeadersHttpRequest(HttpRequest httpRequest, BiConsumer<String, String> headers) {
            this.httpRequest = httpRequest;
            this.headers = headers;
        }

        public int id() {
            return this.httpRequest.id();
        }

        public String uri() {
            return this.httpRequest.uri();
        }

        public String absoluteURI() {
            return this.httpRequest.absoluteURI();
        }

        public HttpMethod method() {
            return this.httpRequest.method();
        }

        public MultiMap headers() {
            HeadersAdaptor headers = new HeadersAdaptor((io.netty.handler.codec.http.HttpHeaders)new HeadersMultiMap()){

                public MultiMap set(String name, String value) {
                    MultiMap result = super.set(name, value);
                    headers.accept(name, value);
                    return result;
                }
            };
            return headers.addAll(this.httpRequest.headers());
        }

        public SocketAddress remoteAddress() {
            return this.httpRequest.remoteAddress();
        }

        public String traceOperation() {
            if (this.httpRequest instanceof HttpRequestHead) {
                return ((HttpRequestHead)this.httpRequest).traceOperation;
            }
            return null;
        }

        static WriteHeadersHttpRequest request(HttpRequest httpRequest, BiConsumer<String, String> headers) {
            return new WriteHeadersHttpRequest(httpRequest, headers);
        }
    }

    private static class ServerAttributesExtractor
    implements HttpServerAttributesGetter<HttpRequest, HttpResponse> {
        private ServerAttributesExtractor() {
        }

        public String getTransport(HttpRequest httpRequest) {
            return null;
        }

        public String getServerAddress(HttpRequest httpRequest) {
            if (httpRequest instanceof HttpServerRequest) {
                return VertxUtil.extractRemoteHostname((HttpServerRequest)httpRequest);
            }
            return null;
        }

        public Integer getServerPort(HttpRequest httpRequest) {
            if (httpRequest instanceof HttpServerRequest) {
                Long remoteHostPort = VertxUtil.extractRemoteHostPort((HttpServerRequest)httpRequest);
                if (remoteHostPort == null) {
                    return null;
                }
                return remoteHostPort.intValue();
            }
            return null;
        }

        public String getNetworkProtocolName(HttpRequest request, HttpResponse response) {
            return "http";
        }

        public String getNetworkProtocolVersion(HttpRequest request, HttpResponse response) {
            return HttpInstrumenterVertxTracer.getHttpVersion(request);
        }

        public String getUrlPath(HttpRequest request) {
            try {
                URI uri = new URI(request.uri());
                return uri.getPath();
            }
            catch (URISyntaxException e) {
                return null;
            }
        }

        public String getUrlQuery(HttpRequest request) {
            try {
                URI uri = new URI(request.uri());
                return uri.getQuery();
            }
            catch (URISyntaxException e) {
                return null;
            }
        }

        public String getHttpRoute(HttpRequest request) {
            return null;
        }

        public String getUrlScheme(HttpRequest request) {
            if (request instanceof HttpServerRequest) {
                return ((HttpServerRequest)request).scheme();
            }
            return null;
        }

        public String getHttpRequestMethod(HttpRequest request) {
            return request.method().name();
        }

        public List<String> getHttpRequestHeader(HttpRequest request, String name) {
            return request.headers().getAll(name);
        }

        public Integer getHttpResponseStatusCode(HttpRequest httpRequest, HttpResponse httpResponse, Throwable error) {
            return httpResponse != null ? Integer.valueOf(httpResponse.statusCode()) : null;
        }

        public List<String> getHttpResponseHeader(HttpRequest request, HttpResponse response, String name) {
            return response != null ? response.headers().getAll(name) : Collections.emptyList();
        }

        private static Long getContentLength(MultiMap headers) {
            String contentLength = headers.get(HttpHeaders.CONTENT_LENGTH);
            if (contentLength != null && contentLength.length() > 0) {
                try {
                    return Long.valueOf(contentLength);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            return null;
        }
    }

    private static class AdditionalServerAttributesExtractor
    implements AttributesExtractor<HttpRequest, HttpResponse> {
        private final SemconvStabilityType semconvStability;

        public AdditionalServerAttributesExtractor(SemconvStabilityType semconvStability) {
            this.semconvStability = semconvStability;
        }

        public void onStart(AttributesBuilder attributes, Context parentContext, HttpRequest httpRequest) {
            String clientIp;
            if (httpRequest instanceof HttpServerRequest && (clientIp = VertxUtil.extractClientIP((HttpServerRequest)httpRequest)) != null) {
                switch (this.semconvStability) {
                    case HTTP_OLD: {
                        attributes.put(SemanticAttributes.HTTP_CLIENT_IP, (Object)clientIp);
                        break;
                    }
                    case HTTP_DUP: {
                        attributes.put(SemanticAttributes.HTTP_CLIENT_IP, (Object)clientIp);
                        attributes.put(SemanticAttributes.CLIENT_ADDRESS, (Object)clientIp);
                        break;
                    }
                    case HTTP: {
                        attributes.put(SemanticAttributes.CLIENT_ADDRESS, (Object)clientIp);
                    }
                }
            }
        }

        public void onEnd(AttributesBuilder attributes, Context context, HttpRequest httpRequest, HttpResponse httpResponse, Throwable error) {
        }
    }

    private static class HttpRequestTextMapGetter
    implements TextMapGetter<HttpRequest> {
        private HttpRequestTextMapGetter() {
        }

        public Iterable<String> keys(HttpRequest carrier) {
            return carrier.headers().names();
        }

        public String get(HttpRequest carrier, String key) {
            if (carrier == null) {
                return null;
            }
            return carrier.headers().get(key);
        }
    }

    private static class HttpClientAttributesExtractor
    implements HttpClientAttributesGetter<HttpRequest, HttpResponse> {
        private HttpClientAttributesExtractor() {
        }

        public String getUrlFull(HttpRequest request) {
            return request.absoluteURI();
        }

        public String getHttpRequestMethod(HttpRequest request) {
            return request.method().name();
        }

        public List<String> getHttpRequestHeader(HttpRequest request, String name) {
            return request.headers().getAll(name);
        }

        public Integer getHttpResponseStatusCode(HttpRequest httpRequest, HttpResponse httpResponse, Throwable error) {
            return httpResponse.statusCode();
        }

        public List<String> getHttpResponseHeader(HttpRequest request, HttpResponse response, String name) {
            return response.headers().getAll(name);
        }

        public String getTransport(HttpRequest httpClientRequest, HttpResponse httpClientResponse) {
            return "ip_tcp";
        }

        public String getServerAddress(HttpRequest httpRequest) {
            return httpRequest.remoteAddress().hostName();
        }

        public Integer getServerPort(HttpRequest httpRequest) {
            return httpRequest.remoteAddress().port();
        }

        public String getNetworkProtocolName(HttpRequest request, HttpResponse response) {
            return "http";
        }

        public String getNetworkProtocolVersion(HttpRequest request, HttpResponse response) {
            return HttpInstrumenterVertxTracer.getHttpVersion(request);
        }
    }

    private static class ClientSpanNameExtractor
    implements SpanNameExtractor<HttpRequest> {
        private final SpanNameExtractor<HttpRequest> http;

        ClientSpanNameExtractor(HttpClientAttributesExtractor clientAttributesExtractor) {
            this.http = HttpSpanNameExtractor.create((HttpClientAttributesGetter)clientAttributesExtractor);
        }

        public String extract(HttpRequest httpRequest) {
            WriteHeadersHttpRequest writeHeaders;
            String traceOperation;
            if (httpRequest instanceof HttpRequestHead) {
                HttpRequestHead head = (HttpRequestHead)httpRequest;
                if (head.traceOperation != null) {
                    return head.traceOperation;
                }
            }
            if (httpRequest instanceof WriteHeadersHttpRequest && (traceOperation = (writeHeaders = (WriteHeadersHttpRequest)httpRequest).traceOperation()) != null) {
                return traceOperation;
            }
            return this.http.extract((Object)httpRequest);
        }
    }

    private static class HttpRequestTextMapSetter
    implements TextMapSetter<HttpRequest> {
        private HttpRequestTextMapSetter() {
        }

        public void set(HttpRequest carrier, String key, String value) {
            if (carrier != null) {
                carrier.headers().set(key, value);
            }
        }
    }
}

