/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.events.GlobalEventEmitterProvider;
import io.opentelemetry.api.logs.GlobalLoggerProvider;
import io.opentelemetry.context.ContextStorage;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.quarkus.arc.Arc;
import io.quarkus.opentelemetry.runtime.QuarkusContextStorage;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.vertx.core.Vertx;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.util.function.Supplier;

@Recorder
public class OpenTelemetryRecorder {
    public static final String OPEN_TELEMETRY_DRIVER = "io.opentelemetry.instrumentation.jdbc.OpenTelemetryDriver";

    public void resetGlobalOpenTelemetryForDevMode() {
        GlobalOpenTelemetry.resetForTest();
        GlobalLoggerProvider.resetForTest();
        GlobalEventEmitterProvider.resetForTest();
    }

    public RuntimeValue<OpenTelemetry> createOpenTelemetry(ShutdownContext shutdownContext) {
        BeanManager beanManager = Arc.container().beanManager();
        OpenTelemetry openTelemetry = (OpenTelemetry)beanManager.createInstance().select(OpenTelemetry.class, new Annotation[]{Any.Literal.INSTANCE}).get();
        shutdownContext.addShutdownTask(() -> {
            ((OpenTelemetrySdk)openTelemetry).getSdkTracerProvider().forceFlush();
            ((OpenTelemetrySdk)openTelemetry).getSdkTracerProvider().shutdown();
        });
        return new RuntimeValue((Object)openTelemetry);
    }

    public void eagerlyCreateContextStorage() {
        ContextStorage.get();
    }

    public void storeVertxOnContextStorage(Supplier<Vertx> vertx) {
        QuarkusContextStorage.vertx = vertx.get();
    }
}

