/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.quartz.runtime;

import io.quarkus.scheduler.spi.JobInstrumenter;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;

class InstrumentedJob
implements Job {
    private final Job delegate;
    private final JobInstrumenter instrumenter;

    InstrumentedJob(Job delegate, JobInstrumenter instrumenter) {
        this.delegate = delegate;
        this.instrumenter = instrumenter;
    }

    public void execute(final JobExecutionContext context) throws JobExecutionException {
        this.instrumenter.instrument(new JobInstrumenter.JobInstrumentationContext(){

            public CompletionStage<Void> executeJob() {
                try {
                    InstrumentedJob.this.delegate.execute(context);
                    return CompletableFuture.completedFuture(null);
                }
                catch (Exception e) {
                    return CompletableFuture.failedFuture(e);
                }
            }

            public String getSpanName() {
                JobKey key = context.getJobDetail().getKey();
                return key.getGroup() + "." + key.getName();
            }
        });
    }
}

