/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.runtime.resource;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.core.ResourceMethodRegistry;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.links.ClassLinksProvider;
import org.jboss.resteasy.links.ObjectLinksProvider;
import org.jboss.resteasy.links.RESTServiceDiscovery;
import org.jboss.resteasy.spi.Registry;

public final class ResourceLinksProvider {
    private static final String SELF_REF = "self";

    public Map<String, String> getClassLinks(Class<?> className) {
        return this.linksToMap(this.getClassLinksProvider().getLinks(className));
    }

    public Map<String, String> getInstanceLinks(Object instance) {
        return this.linksToMap(this.getObjectLinksProvider().getLinks(instance));
    }

    public String getSelfLink(Object instance) {
        RESTServiceDiscovery.AtomLink link = this.getObjectLinksProvider().getLinks(instance).getLinkForRel(SELF_REF);
        return link == null ? null : link.getHref();
    }

    private Map<String, String> linksToMap(RESTServiceDiscovery serviceDiscovery) {
        HashMap<String, String> links = new HashMap<String, String>(serviceDiscovery.size());
        for (RESTServiceDiscovery.AtomLink atomLink : serviceDiscovery) {
            links.put(atomLink.getRel(), atomLink.getHref());
        }
        return links;
    }

    private ObjectLinksProvider getObjectLinksProvider() {
        UriInfo uriInfo = (UriInfo)ResteasyContext.getContextData(UriInfo.class);
        ResourceMethodRegistry registry = (ResourceMethodRegistry)ResteasyContext.getContextData(Registry.class);
        return new ObjectLinksProvider(uriInfo, registry);
    }

    private ClassLinksProvider getClassLinksProvider() {
        UriInfo uriInfo = (UriInfo)ResteasyContext.getContextData(UriInfo.class);
        ResourceMethodRegistry registry = (ResourceMethodRegistry)ResteasyContext.getContextData(Registry.class);
        return new ClassLinksProvider(uriInfo, registry);
    }
}

