/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.jackson.deployment.processor;

import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SynthesisFinishedBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.RuntimeConfigSetupCompleteBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.JaxRsResourceIndexBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.QuarkusResteasyReactiveDotNames;
import io.quarkus.resteasy.reactive.common.deployment.ResourceScanningResultBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.ServerDefaultProducesHandlerBuildItem;
import io.quarkus.resteasy.reactive.jackson.CustomDeserialization;
import io.quarkus.resteasy.reactive.jackson.CustomSerialization;
import io.quarkus.resteasy.reactive.jackson.DisableSecureSerialization;
import io.quarkus.resteasy.reactive.jackson.EnableSecureSerialization;
import io.quarkus.resteasy.reactive.jackson.SecureField;
import io.quarkus.resteasy.reactive.jackson.deployment.processor.JacksonCodeGenerator;
import io.quarkus.resteasy.reactive.jackson.deployment.processor.JacksonDeserializerFactory;
import io.quarkus.resteasy.reactive.jackson.deployment.processor.JacksonFeatureBuildItem;
import io.quarkus.resteasy.reactive.jackson.deployment.processor.JacksonOptimizationConfig;
import io.quarkus.resteasy.reactive.jackson.deployment.processor.JacksonSerializerFactory;
import io.quarkus.resteasy.reactive.jackson.deployment.processor.ResourceMethodCustomSerializationBuildItem;
import io.quarkus.resteasy.reactive.jackson.deployment.processor.ResteasyReactiveJacksonProviderDefinedBuildItem;
import io.quarkus.resteasy.reactive.jackson.runtime.ResteasyReactiveServerJacksonRecorder;
import io.quarkus.resteasy.reactive.jackson.runtime.mappers.NativeInvalidDefinitionExceptionMapper;
import io.quarkus.resteasy.reactive.jackson.runtime.security.RolesAllowedConfigExpStorage;
import io.quarkus.resteasy.reactive.jackson.runtime.security.SecurityCustomSerialization;
import io.quarkus.resteasy.reactive.jackson.runtime.serialisers.BasicServerJacksonMessageBodyWriter;
import io.quarkus.resteasy.reactive.jackson.runtime.serialisers.FullyFeaturedServerJacksonMessageBodyReader;
import io.quarkus.resteasy.reactive.jackson.runtime.serialisers.FullyFeaturedServerJacksonMessageBodyWriter;
import io.quarkus.resteasy.reactive.jackson.runtime.serialisers.GeneratedSerializersRegister;
import io.quarkus.resteasy.reactive.jackson.runtime.serialisers.ServerJacksonMessageBodyReader;
import io.quarkus.resteasy.reactive.jackson.runtime.serialisers.vertx.VertxJsonArrayMessageBodyReader;
import io.quarkus.resteasy.reactive.jackson.runtime.serialisers.vertx.VertxJsonArrayMessageBodyWriter;
import io.quarkus.resteasy.reactive.jackson.runtime.serialisers.vertx.VertxJsonObjectMessageBodyReader;
import io.quarkus.resteasy.reactive.jackson.runtime.serialisers.vertx.VertxJsonObjectMessageBodyWriter;
import io.quarkus.resteasy.reactive.server.deployment.ContextResolversBuildItem;
import io.quarkus.resteasy.reactive.server.deployment.ResteasyReactiveResourceMethodEntriesBuildItem;
import io.quarkus.resteasy.reactive.spi.CustomExceptionMapperBuildItem;
import io.quarkus.resteasy.reactive.spi.ExceptionMapperBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyReaderBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyWriterBuildItem;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.security.spi.RolesAllowedConfigExpResolverBuildItem;
import io.quarkus.vertx.deployment.ReinitializeVertxJsonBuildItem;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.core.Cookie;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.common.model.ResourceMethod;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.server.util.MethodId;

public class ResteasyReactiveJacksonProcessor {
    private static final Logger log = Logger.getLogger(ResteasyReactiveJacksonProcessor.class);
    private static final DotName JSON_VIEW = DotName.createSimple((String)JsonView.class.getName());
    private static final DotName CUSTOM_SERIALIZATION = DotName.createSimple((String)CustomSerialization.class.getName());
    private static final DotName CUSTOM_DESERIALIZATION = DotName.createSimple((String)CustomDeserialization.class.getName());
    private static final DotName SECURE_FIELD = DotName.createSimple((String)SecureField.class.getName());
    private static final DotName DISABLE_SECURE_SERIALIZATION = DotName.createSimple((String)DisableSecureSerialization.class.getName());
    private static final DotName ENABLE_SECURE_SERIALIZATION = DotName.createSimple((String)EnableSecureSerialization.class.getName());
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final List<String> HANDLED_MEDIA_TYPES = List.of("application/json", "application/x-ndjson", "application/stream+json");
    public static final String DEFAULT_MISMATCHED_INPUT_EXCEPTION = "io.quarkus.resteasy.reactive.jackson.runtime.mappers.BuiltinMismatchedInputExceptionMapper";

    @BuildStep
    void feature(BuildProducer<FeatureBuildItem> feature) {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.REST_JACKSON));
    }

    @BuildStep
    ServerDefaultProducesHandlerBuildItem jsonDefault() {
        return ServerDefaultProducesHandlerBuildItem.json();
    }

    @BuildStep
    ResteasyReactiveJacksonProviderDefinedBuildItem jacksonRegistered() {
        return new ResteasyReactiveJacksonProviderDefinedBuildItem();
    }

    @BuildStep
    ReinitializeVertxJsonBuildItem vertxJson() {
        return new ReinitializeVertxJsonBuildItem();
    }

    @BuildStep
    void exceptionMappers(BuildProducer<ExceptionMapperBuildItem> producer) {
        try {
            Thread.currentThread().getContextClassLoader().loadClass(DEFAULT_MISMATCHED_INPUT_EXCEPTION);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return;
        }
        producer.produce((BuildItem)new ExceptionMapperBuildItem(DEFAULT_MISMATCHED_INPUT_EXCEPTION, MismatchedInputException.class.getName(), Integer.valueOf(5100), false));
    }

    @BuildStep
    CustomExceptionMapperBuildItem customExceptionMappers() {
        return new CustomExceptionMapperBuildItem(NativeInvalidDefinitionExceptionMapper.class.getName());
    }

    @BuildStep
    AdditionalBeanBuildItem beans() {
        return AdditionalBeanBuildItem.builder().addBeanClass(ServerJacksonMessageBodyReader.class.getName()).addBeanClass(FullyFeaturedServerJacksonMessageBodyReader.class).addBeanClass(BasicServerJacksonMessageBodyWriter.class).addBeanClass(FullyFeaturedServerJacksonMessageBodyWriter.class).setUnremovable().build();
    }

    @BuildStep
    void additionalProviders(ContextResolversBuildItem contextResolversBuildItem, List<JacksonFeatureBuildItem> jacksonFeatureBuildItems, BuildProducer<MessageBodyReaderBuildItem> additionalReaders, BuildProducer<MessageBodyWriterBuildItem> additionalWriters) {
        boolean specialJacksonFeaturesUsed = !jacksonFeatureBuildItems.isEmpty();
        boolean hasObjectMapperContextResolver = contextResolversBuildItem.getContextResolvers().getResolvers().containsKey(ObjectMapper.class);
        additionalReaders.produce((BuildItem)new MessageBodyReaderBuildItem.Builder(this.getJacksonMessageBodyReader(hasObjectMapperContextResolver || specialJacksonFeaturesUsed), Object.class.getName()).setMediaTypeStrings(HANDLED_MEDIA_TYPES).setBuiltin(true).setRuntimeType(RuntimeType.SERVER).build());
        additionalReaders.produce((BuildItem)new MessageBodyReaderBuildItem.Builder(VertxJsonArrayMessageBodyReader.class.getName(), JsonArray.class.getName()).setMediaTypeStrings(HANDLED_MEDIA_TYPES).setBuiltin(true).setRuntimeType(RuntimeType.SERVER).build());
        additionalReaders.produce((BuildItem)new MessageBodyReaderBuildItem.Builder(VertxJsonObjectMessageBodyReader.class.getName(), JsonObject.class.getName()).setMediaTypeStrings(HANDLED_MEDIA_TYPES).setBuiltin(true).setRuntimeType(RuntimeType.SERVER).build());
        additionalWriters.produce((BuildItem)new MessageBodyWriterBuildItem.Builder(this.getJacksonMessageBodyWriter(hasObjectMapperContextResolver || specialJacksonFeaturesUsed), Object.class.getName()).setMediaTypeStrings(HANDLED_MEDIA_TYPES).setBuiltin(true).setRuntimeType(RuntimeType.SERVER).build());
        additionalWriters.produce((BuildItem)new MessageBodyWriterBuildItem.Builder(VertxJsonArrayMessageBodyWriter.class.getName(), JsonArray.class.getName()).setMediaTypeStrings(HANDLED_MEDIA_TYPES).setBuiltin(true).setRuntimeType(RuntimeType.SERVER).build());
        additionalWriters.produce((BuildItem)new MessageBodyWriterBuildItem.Builder(VertxJsonObjectMessageBodyWriter.class.getName(), JsonObject.class.getName()).setMediaTypeStrings(HANDLED_MEDIA_TYPES).setBuiltin(true).setRuntimeType(RuntimeType.SERVER).build());
    }

    private String getJacksonMessageBodyWriter(boolean needsFullFeatureSet) {
        return needsFullFeatureSet ? FullyFeaturedServerJacksonMessageBodyWriter.class.getName() : BasicServerJacksonMessageBodyWriter.class.getName();
    }

    private String getJacksonMessageBodyReader(boolean needsFullFeatureSet) {
        return needsFullFeatureSet ? FullyFeaturedServerJacksonMessageBodyReader.class.getName() : ServerJacksonMessageBodyReader.class.getName();
    }

    @BuildStep
    void reflection(BuildProducer<ReflectiveClassBuildItem> producer) {
        producer.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{Cookie.class}).reason(this.getClass().getName()).methods().build());
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void handleJsonAnnotations(Optional<ResourceScanningResultBuildItem> resourceScanningResultBuildItem, CombinedIndexBuildItem index, List<ResourceMethodCustomSerializationBuildItem> resourceMethodCustomSerializationBuildItems, BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer, BuildProducer<JacksonFeatureBuildItem> jacksonFeaturesProducer, ResteasyReactiveServerJacksonRecorder recorder, ShutdownContextBuildItem shutdown) {
        if (resourceScanningResultBuildItem.isEmpty()) {
            return;
        }
        Collection resourceClasses = resourceScanningResultBuildItem.get().getResult().getScannedResources().values();
        HashSet<JacksonFeatureBuildItem.Feature> jacksonFeatures = new HashSet<JacksonFeatureBuildItem.Feature>();
        for (ClassInfo resourceClass : resourceClasses) {
            ClassInfo biFunctionClassInfo;
            Type biFunctionType;
            AnnotationValue annotationValue;
            if (resourceClass.annotationsMap().containsKey(JSON_VIEW)) {
                jacksonFeatures.add(JacksonFeatureBuildItem.Feature.JSON_VIEW);
                for (AnnotationInstance instance : (List)resourceClass.annotationsMap().get(JSON_VIEW)) {
                    Type[] jsonViews;
                    annotationValue = instance.value();
                    if (annotationValue == null || (jsonViews = annotationValue.asClassArray()) == null || jsonViews.length == 0) continue;
                    recorder.recordJsonView(this.getTargetId(instance), jsonViews[0].name().toString());
                }
            }
            if (resourceClass.annotationsMap().containsKey(CUSTOM_SERIALIZATION)) {
                jacksonFeatures.add(JacksonFeatureBuildItem.Feature.CUSTOM_SERIALIZATION);
                for (AnnotationInstance instance : (List)resourceClass.annotationsMap().get(CUSTOM_SERIALIZATION)) {
                    annotationValue = instance.value();
                    if (annotationValue == null || (biFunctionType = annotationValue.asClass()) == null) continue;
                    biFunctionClassInfo = index.getIndex().getClassByName(biFunctionType.name());
                    if (biFunctionClassInfo != null && !biFunctionClassInfo.hasNoArgsConstructor()) {
                        throw new IllegalArgumentException("Class '" + biFunctionClassInfo.name() + "' must contain a no-args constructor");
                    }
                    reflectiveClassProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{biFunctionType.name().toString()}).reason(this.getClass().getName()).build());
                    recorder.recordCustomSerialization(this.getTargetId(instance), biFunctionType.name().toString());
                }
            }
            if (!resourceClass.annotationsMap().containsKey(CUSTOM_DESERIALIZATION)) continue;
            jacksonFeatures.add(JacksonFeatureBuildItem.Feature.CUSTOM_DESERIALIZATION);
            for (AnnotationInstance instance : (List)resourceClass.annotationsMap().get(CUSTOM_DESERIALIZATION)) {
                annotationValue = instance.value();
                if (annotationValue == null || (biFunctionType = annotationValue.asClass()) == null) continue;
                biFunctionClassInfo = index.getIndex().getClassByName(biFunctionType.name());
                if (biFunctionClassInfo != null && !biFunctionClassInfo.hasNoArgsConstructor()) {
                    throw new IllegalArgumentException("Class '" + biFunctionClassInfo.name() + "' must contain a no-args constructor");
                }
                reflectiveClassProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{biFunctionType.name().toString()}).reason(this.getClass().getName()).build());
                recorder.recordCustomDeserialization(this.getTargetId(instance), biFunctionType.name().toString());
            }
        }
        for (ResourceMethodCustomSerializationBuildItem bi : resourceMethodCustomSerializationBuildItems) {
            jacksonFeatures.add(JacksonFeatureBuildItem.Feature.CUSTOM_SERIALIZATION);
            String className = bi.getCustomSerializationProvider().getName();
            reflectiveClassProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{className}).reason(this.getClass().getName()).build());
            recorder.recordCustomSerialization(this.getMethodId(bi.getMethodInfo(), bi.getDeclaringClassInfo()), className);
        }
        if (!jacksonFeatures.isEmpty()) {
            for (JacksonFeatureBuildItem.Feature jacksonFeature : jacksonFeatures) {
                jacksonFeaturesProducer.produce((BuildItem)new JacksonFeatureBuildItem(jacksonFeature));
            }
            recorder.configureShutdown((ShutdownContext)shutdown);
        }
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    public void resolveRolesAllowedConfigExpressions(BuildProducer<RolesAllowedConfigExpResolverBuildItem> resolverProducer, Capabilities capabilities, ResteasyReactiveServerJacksonRecorder recorder, CombinedIndexBuildItem indexBuildItem, BuildProducer<SyntheticBeanBuildItem> syntheticBeanProducer, BuildProducer<InitAndValidateRolesAllowedConfigExp> initAndValidateItemProducer) {
        if (capabilities.isPresent("io.quarkus.security")) {
            BiConsumer configValRecorder = null;
            for (AnnotationInstance instance : indexBuildItem.getIndex().getAnnotations(SECURE_FIELD)) {
                for (String role : instance.value("rolesAllowed").asStringArray()) {
                    if (!RolesAllowedConfigExpResolverBuildItem.isSecurityConfigExpressionCandidate((String)role)) continue;
                    if (configValRecorder == null) {
                        RuntimeValue storage = recorder.createConfigExpToAllowedRoles();
                        configValRecorder = recorder.recordRolesAllowedConfigExpression(storage);
                        syntheticBeanProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(RolesAllowedConfigExpStorage.class).scope(Singleton.class)).supplier(recorder.createRolesAllowedConfigExpStorage(storage)).unremovable()).done());
                        initAndValidateItemProducer.produce((BuildItem)new InitAndValidateRolesAllowedConfigExp());
                    }
                    resolverProducer.produce((BuildItem)new RolesAllowedConfigExpResolverBuildItem(role, configValRecorder));
                }
            }
        }
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    @Consume.List(value={@Consume(value=RuntimeConfigSetupCompleteBuildItem.class), @Consume(value=SynthesisFinishedBuildItem.class)})
    public void initializeRolesAllowedConfigExp(ResteasyReactiveServerJacksonRecorder recorder, Optional<InitAndValidateRolesAllowedConfigExp> initAndValidateItem) {
        if (initAndValidateItem.isPresent()) {
            recorder.initAndValidateRolesAllowedConfigExp();
        }
    }

    @BuildStep(onlyIf={JacksonOptimizationConfig.IsReflectionFreeSerializersEnabled.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    public void handleEndpointParams(ResteasyReactiveResourceMethodEntriesBuildItem resourceMethodEntries, JaxRsResourceIndexBuildItem jaxRsIndex, CombinedIndexBuildItem index, ResteasyReactiveServerJacksonRecorder recorder, BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer) {
        JacksonCodeGenerator factory;
        IndexView indexView = jaxRsIndex.getIndexView();
        HashMap<String, ClassInfo> serializedClasses = new HashMap<String, ClassInfo>();
        HashMap<String, ClassInfo> deserializedClasses = new HashMap<String, ClassInfo>();
        for (ResteasyReactiveResourceMethodEntriesBuildItem.Entry entry : resourceMethodEntries.getEntries()) {
            MethodInfo methodInfo = entry.getMethodInfo();
            ClassInfo effectiveReturnClassInfo = ResteasyReactiveJacksonProcessor.getEffectiveClassInfo(methodInfo.returnType(), indexView);
            if (effectiveReturnClassInfo != null) {
                serializedClasses.put(effectiveReturnClassInfo.name().toString(), effectiveReturnClassInfo);
            }
            if (!methodInfo.hasAnnotation(POST.class)) continue;
            for (Type paramType : methodInfo.parameterTypes()) {
                ClassInfo effectiveParamClassInfo = ResteasyReactiveJacksonProcessor.getEffectiveClassInfo(paramType, indexView);
                if (effectiveParamClassInfo == null) continue;
                deserializedClasses.put(effectiveParamClassInfo.name().toString(), effectiveParamClassInfo);
            }
        }
        if (!serializedClasses.isEmpty()) {
            factory = new JacksonSerializerFactory(generatedClassBuildItemBuildProducer, index.getComputingIndex());
            ((JacksonSerializerFactory)factory).create(serializedClasses.values()).forEach(arg_0 -> ((ResteasyReactiveServerJacksonRecorder)recorder).recordGeneratedSerializer(arg_0));
        }
        if (!deserializedClasses.isEmpty()) {
            factory = new JacksonDeserializerFactory(generatedClassBuildItemBuildProducer, index.getComputingIndex());
            factory.create(deserializedClasses.values()).forEach(arg_0 -> ((ResteasyReactiveServerJacksonRecorder)recorder).recordGeneratedDeserializer(arg_0));
        }
    }

    @BuildStep(onlyIf={JacksonOptimizationConfig.IsReflectionFreeSerializersEnabled.class})
    void unremovable(BuildProducer<AdditionalBeanBuildItem> additionalProducer) {
        additionalProducer.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(GeneratedSerializersRegister.class));
    }

    @BuildStep
    public void handleFieldSecurity(ResteasyReactiveResourceMethodEntriesBuildItem resourceMethodEntries, JaxRsResourceIndexBuildItem index, BuildProducer<ResourceMethodCustomSerializationBuildItem> producer) {
        IndexView indexView = index.getIndexView();
        boolean noSecureFieldDetected = indexView.getAnnotations(SECURE_FIELD).isEmpty();
        if (noSecureFieldDetected) {
            return;
        }
        HashMap<String, Boolean> typeToHasSecureField = new HashMap<String, Boolean>(ResteasyReactiveJacksonProcessor.getTypesWithSecureField());
        ArrayList<ResourceMethodCustomSerializationBuildItem> result = new ArrayList<ResourceMethodCustomSerializationBuildItem>();
        for (ResteasyReactiveResourceMethodEntriesBuildItem.Entry entry : resourceMethodEntries.getEntries()) {
            ClassInfo effectiveReturnClassInfo;
            MethodInfo methodInfo = entry.getMethodInfo();
            if (methodInfo.hasAnnotation(DISABLE_SECURE_SERIALIZATION) || entry.getActualClassInfo().declaredAnnotation(DISABLE_SECURE_SERIALIZATION) != null && !methodInfo.hasAnnotation(ENABLE_SECURE_SERIALIZATION)) continue;
            ResourceMethod resourceInfo = entry.getResourceMethod();
            boolean isJsonResponse = false;
            if (resourceInfo.getProduces() != null) {
                for (String produces : resourceInfo.getProduces()) {
                    if (!produces.toLowerCase(Locale.ROOT).contains("application/json")) continue;
                    isJsonResponse = true;
                    break;
                }
            }
            if (!isJsonResponse || (effectiveReturnClassInfo = ResteasyReactiveJacksonProcessor.getEffectiveClassInfo(methodInfo.returnType(), indexView)) == null) continue;
            AtomicBoolean needToDeleteCache = new AtomicBoolean(false);
            if (ResteasyReactiveJacksonProcessor.hasSecureFields(indexView, effectiveReturnClassInfo, typeToHasSecureField, needToDeleteCache)) {
                AnnotationInstance customSerializationAtClassAnnotation = methodInfo.declaringClass().declaredAnnotation(CUSTOM_SERIALIZATION);
                AnnotationInstance customSerializationAtMethodAnnotation = methodInfo.annotation(CUSTOM_SERIALIZATION);
                if (customSerializationAtMethodAnnotation != null || customSerializationAtClassAnnotation != null) {
                    log.warn((Object)("Secure serialization will not be applied to method: '" + methodInfo.declaringClass().name() + "#" + methodInfo.name() + "' because the method or class are annotated with @CustomSerialization."));
                } else {
                    result.add(new ResourceMethodCustomSerializationBuildItem(methodInfo, entry.getActualClassInfo(), SecurityCustomSerialization.class));
                }
            }
            if (!needToDeleteCache.get()) continue;
            typeToHasSecureField.clear();
            typeToHasSecureField.putAll(ResteasyReactiveJacksonProcessor.getTypesWithSecureField());
        }
        if (!result.isEmpty()) {
            for (ResourceMethodCustomSerializationBuildItem bi : result) {
                producer.produce((BuildItem)bi);
            }
        }
    }

    private static ClassInfo getEffectiveClassInfo(Type type, IndexView indexView) {
        if (type.kind() == Type.Kind.VOID) {
            return null;
        }
        Type effectiveReturnType = ResteasyReactiveJacksonProcessor.getEffectiveType(type);
        return effectiveReturnType == null ? null : indexView.getClassByName(effectiveReturnType.name());
    }

    private static Type getEffectiveType(Type type) {
        Type effectiveReturnType = type;
        if (effectiveReturnType.name().equals((Object)ResteasyReactiveDotNames.REST_RESPONSE) || effectiveReturnType.name().equals((Object)ResteasyReactiveDotNames.UNI) || effectiveReturnType.name().equals((Object)ResteasyReactiveDotNames.COMPLETABLE_FUTURE) || effectiveReturnType.name().equals((Object)ResteasyReactiveDotNames.COMPLETION_STAGE) || effectiveReturnType.name().equals((Object)ResteasyReactiveDotNames.REST_MULTI) || effectiveReturnType.name().equals((Object)ResteasyReactiveDotNames.MULTI)) {
            if (effectiveReturnType.kind() != Type.Kind.PARAMETERIZED_TYPE) {
                return null;
            }
            effectiveReturnType = (Type)type.asParameterizedType().arguments().get(0);
        }
        if (effectiveReturnType.name().equals((Object)ResteasyReactiveDotNames.SET) || effectiveReturnType.name().equals((Object)ResteasyReactiveDotNames.COLLECTION) || effectiveReturnType.name().equals((Object)ResteasyReactiveDotNames.LIST)) {
            effectiveReturnType = (Type)effectiveReturnType.asParameterizedType().arguments().get(0);
        } else if (effectiveReturnType.name().equals((Object)ResteasyReactiveDotNames.MAP)) {
            effectiveReturnType = (Type)effectiveReturnType.asParameterizedType().arguments().get(1);
        }
        return effectiveReturnType;
    }

    private static Map<String, Boolean> getTypesWithSecureField() {
        return Map.of(ResteasyReactiveDotNames.OBJECT.toString(), Boolean.TRUE, ResteasyReactiveDotNames.RESPONSE.toString(), Boolean.TRUE);
    }

    private static boolean hasSecureFields(IndexView indexView, ClassInfo currentClassInfo, Map<String, Boolean> typeToHasSecureField, AtomicBoolean needToDeleteCache) {
        String className = currentClassInfo.name().toString();
        if (typeToHasSecureField.containsKey(className)) {
            Boolean hasSecureFields = typeToHasSecureField.get(className);
            if (hasSecureFields == null) {
                needToDeleteCache.set(true);
                return false;
            }
            return hasSecureFields;
        }
        typeToHasSecureField.put(className, null);
        boolean hasSecureFields = currentClassInfo.isInterface() ? (ResteasyReactiveJacksonProcessor.isExcludedFromSecureFieldLookup(currentClassInfo.name()) ? false : indexView.getAllKnownImplementors(currentClassInfo.name()).stream().anyMatch(ci -> ResteasyReactiveJacksonProcessor.hasSecureFields(indexView, ci, typeToHasSecureField, needToDeleteCache))) : (ResteasyReactiveJacksonProcessor.hasSecureFields(currentClassInfo) ? true : (ResteasyReactiveJacksonProcessor.isExcludedFromSecureFieldLookup(currentClassInfo.name()) ? false : ResteasyReactiveJacksonProcessor.anyFieldHasSecureFields(indexView, currentClassInfo, typeToHasSecureField, needToDeleteCache) || ResteasyReactiveJacksonProcessor.anySubclassHasSecureFields(indexView, currentClassInfo, typeToHasSecureField, needToDeleteCache) || ResteasyReactiveJacksonProcessor.anyParentClassHasSecureFields(indexView, currentClassInfo, typeToHasSecureField, needToDeleteCache)));
        typeToHasSecureField.put(className, hasSecureFields);
        return hasSecureFields;
    }

    private static boolean isExcludedFromSecureFieldLookup(DotName name) {
        return QuarkusResteasyReactiveDotNames.IGNORE_TYPE_FOR_REFLECTION_PREDICATE.test(name);
    }

    private static boolean hasSecureFields(ClassInfo classInfo) {
        return classInfo.annotationsMap().containsKey(SECURE_FIELD);
    }

    private static boolean anyParentClassHasSecureFields(IndexView indexView, ClassInfo currentClassInfo, Map<String, Boolean> typeToHasSecureField, AtomicBoolean needToDeleteCache) {
        if (!currentClassInfo.superName().equals((Object)ResteasyReactiveDotNames.OBJECT)) {
            ClassInfo parentClassInfo = indexView.getClassByName(currentClassInfo.superName());
            return parentClassInfo != null && ResteasyReactiveJacksonProcessor.hasSecureFields(indexView, parentClassInfo, typeToHasSecureField, needToDeleteCache);
        }
        return false;
    }

    private static boolean anySubclassHasSecureFields(IndexView indexView, ClassInfo currentClassInfo, Map<String, Boolean> typeToHasSecureField, AtomicBoolean needToDeleteCache) {
        return indexView.getAllKnownSubclasses(currentClassInfo.name()).stream().anyMatch(subclass -> ResteasyReactiveJacksonProcessor.hasSecureFields(indexView, subclass, typeToHasSecureField, needToDeleteCache));
    }

    private static boolean anyFieldHasSecureFields(IndexView indexView, ClassInfo currentClassInfo, Map<String, Boolean> typeToHasSecureField, AtomicBoolean needToDeleteCache) {
        return currentClassInfo.fields().stream().filter(fieldInfo -> !fieldInfo.hasAnnotation(QuarkusResteasyReactiveDotNames.JSON_IGNORE)).map(FieldInfo::type).anyMatch(fieldType -> ResteasyReactiveJacksonProcessor.fieldTypeHasSecureFields(fieldType, indexView, typeToHasSecureField, needToDeleteCache));
    }

    private static boolean fieldTypeHasSecureFields(Type fieldType, IndexView indexView, Map<String, Boolean> typeToHasSecureField, AtomicBoolean needToDeleteCache) {
        if (fieldType.kind() == Type.Kind.CLASS) {
            if (ResteasyReactiveJacksonProcessor.isExcludedFromSecureFieldLookup(fieldType.name())) {
                return false;
            }
            ClassInfo fieldClass = indexView.getClassByName(fieldType.name());
            return fieldClass != null && ResteasyReactiveJacksonProcessor.hasSecureFields(indexView, fieldClass, typeToHasSecureField, needToDeleteCache);
        }
        if (fieldType.kind() == Type.Kind.ARRAY) {
            return ResteasyReactiveJacksonProcessor.fieldTypeHasSecureFields(fieldType.asArrayType().constituent(), indexView, typeToHasSecureField, needToDeleteCache);
        }
        if (fieldType.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            return fieldType.asParameterizedType().arguments().stream().anyMatch(t -> ResteasyReactiveJacksonProcessor.fieldTypeHasSecureFields(t, indexView, typeToHasSecureField, needToDeleteCache));
        }
        return false;
    }

    private String getTargetId(AnnotationInstance instance) {
        AnnotationTarget target = instance.target();
        if (target.kind() == AnnotationTarget.Kind.CLASS) {
            return this.getClassId(target.asClass());
        }
        if (target.kind() == AnnotationTarget.Kind.METHOD) {
            return this.getMethodId(target.asMethod());
        }
        if (target.kind() == AnnotationTarget.Kind.METHOD_PARAMETER) {
            return this.getMethodId(target.asMethodParameter().method());
        }
        throw new UnsupportedOperationException(String.format("The `%s` annotation can only be used in methods or classes.", instance.name()));
    }

    private String getClassId(ClassInfo classInfo) {
        return classInfo.name().toString();
    }

    private String getMethodId(MethodInfo methodInfo) {
        return this.getMethodId(methodInfo, methodInfo.declaringClass());
    }

    private String getMethodId(MethodInfo methodInfo, ClassInfo declaringClassInfo) {
        ArrayList<String> parameterClassNames = new ArrayList<String>(methodInfo.parametersCount());
        for (Type parameter : methodInfo.parameterTypes()) {
            parameterClassNames.add(parameter.name().toString());
        }
        return MethodId.get((String)methodInfo.name(), (String)declaringClassInfo.name().toString(), (String[])parameterClassNames.toArray(EMPTY_STRING_ARRAY));
    }

    public static final class InitAndValidateRolesAllowedConfigExp
    extends SimpleBuildItem {
        private InitAndValidateRolesAllowedConfigExp() {
        }
    }
}

