/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.resteasy.runtime.JaxRsPermissionChecker;
import io.quarkus.security.UnauthorizedException;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.spi.runtime.AuthorizationController;
import io.quarkus.security.spi.runtime.AuthorizationFailureEvent;
import io.quarkus.security.spi.runtime.AuthorizationSuccessEvent;
import io.quarkus.security.spi.runtime.MethodDescription;
import io.quarkus.security.spi.runtime.SecurityCheck;
import io.quarkus.security.spi.runtime.SecurityCheckStorage;
import io.quarkus.security.spi.runtime.SecurityEvent;
import io.quarkus.security.spi.runtime.SecurityEventHelper;
import io.quarkus.vertx.http.runtime.security.EagerSecurityInterceptorStorage;
import io.vertx.ext.web.RoutingContext;
import jakarta.annotation.Priority;
import jakarta.enterprise.event.Event;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.microprofile.config.ConfigProvider;

@Priority(value=1000)
@Provider
public class EagerSecurityFilter
implements ContainerRequestFilter {
    static final String SKIP_DEFAULT_CHECK = "io.quarkus.resteasy.runtime.EagerSecurityFilter#SKIP_DEFAULT_CHECK";
    private final EagerSecurityInterceptorStorage interceptorStorage;
    private final SecurityEventHelper<AuthorizationSuccessEvent, AuthorizationFailureEvent> eventHelper;
    @Context
    ResourceInfo resourceInfo;
    @Inject
    RoutingContext routingContext;
    @Inject
    SecurityCheckStorage securityCheckStorage;
    @Inject
    CurrentIdentityAssociation identityAssociation;
    @Inject
    AuthorizationController authorizationController;
    @Inject
    JaxRsPermissionChecker jaxRsPermissionChecker;

    public EagerSecurityFilter() {
        InstanceHandle interceptorStorageHandle = Arc.container().instance(EagerSecurityInterceptorStorage.class, new Annotation[0]);
        this.interceptorStorage = interceptorStorageHandle.isAvailable() ? (EagerSecurityInterceptorStorage)interceptorStorageHandle.get() : null;
        Event event = Arc.container().beanManager().getEvent();
        this.eventHelper = new SecurityEventHelper(event.select(AuthorizationSuccessEvent.class, new Annotation[0]), event.select(AuthorizationFailureEvent.class, new Annotation[0]), (SecurityEvent)SecurityEventHelper.AUTHORIZATION_SUCCESS, (SecurityEvent)SecurityEventHelper.AUTHORIZATION_FAILURE, Arc.container().beanManager(), ConfigProvider.getConfig().getOptionalValue("quarkus.security.events.enabled", Boolean.class).orElse(false).booleanValue());
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (this.authorizationController.isAuthorizationEnabled()) {
            MethodDescription description = MethodDescription.ofMethod((Method)this.resourceInfo.getResourceMethod());
            if (this.interceptorStorage != null) {
                this.applyEagerSecurityInterceptors(description);
            }
            if (this.jaxRsPermissionChecker.shouldRunPermissionChecks()) {
                this.jaxRsPermissionChecker.applyPermissionChecks(this.eventHelper);
            }
            this.applySecurityChecks(description);
        }
    }

    private void applySecurityChecks(MethodDescription description) {
        SecurityCheck check = this.securityCheckStorage.getSecurityCheck(description);
        if (check == null && this.securityCheckStorage.getDefaultSecurityCheck() != null && this.routingContext.get(EagerSecurityFilter.class.getName()) == null && this.routingContext.get(SKIP_DEFAULT_CHECK) == null) {
            check = this.securityCheckStorage.getDefaultSecurityCheck();
        }
        if (check != null) {
            if (check.isPermitAll()) {
                this.fireEventOnAuthZSuccess(check, null);
            } else {
                if (check.requiresMethodArguments()) {
                    if (this.identityAssociation.getIdentity().isAnonymous()) {
                        UnauthorizedException exception = new UnauthorizedException();
                        if (this.eventHelper.fireEventOnFailure()) {
                            this.fireEventOnAuthZFailure((Exception)exception, check);
                        }
                        throw exception;
                    }
                    return;
                }
                if (this.eventHelper.fireEventOnFailure()) {
                    try {
                        check.apply(this.identityAssociation.getIdentity(), description, null);
                    }
                    catch (Exception e) {
                        this.fireEventOnAuthZFailure(e, check);
                        throw e;
                    }
                } else {
                    check.apply(this.identityAssociation.getIdentity(), description, null);
                }
                this.fireEventOnAuthZSuccess(check, this.identityAssociation.getIdentity());
            }
            this.routingContext.put(EagerSecurityFilter.class.getName(), (Object)this.resourceInfo.getResourceMethod());
        }
    }

    private void fireEventOnAuthZFailure(Exception exception, SecurityCheck check) {
        this.eventHelper.fireFailureEvent((SecurityEvent)new AuthorizationFailureEvent(this.identityAssociation.getIdentity(), (Throwable)exception, check.getClass().getName(), Map.of(RoutingContext.class.getName(), this.routingContext)));
    }

    private void fireEventOnAuthZSuccess(SecurityCheck check, SecurityIdentity securityIdentity) {
        if (this.eventHelper.fireEventOnSuccess()) {
            this.eventHelper.fireSuccessEvent((SecurityEvent)new AuthorizationSuccessEvent(securityIdentity, check.getClass().getName(), Map.of(RoutingContext.class.getName(), this.routingContext)));
        }
    }

    private void applyEagerSecurityInterceptors(MethodDescription description) {
        Consumer interceptor = this.interceptorStorage.getInterceptor(description);
        if (interceptor != null) {
            interceptor.accept(this.routingContext);
        }
    }
}

