/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.scheduler.common.runtime;

import io.quarkus.scheduler.ScheduledExecution;
import io.quarkus.scheduler.common.runtime.ScheduledInvoker;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

abstract class DelegateInvoker
implements ScheduledInvoker {
    protected final ScheduledInvoker delegate;

    public DelegateInvoker(ScheduledInvoker delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean isBlocking() {
        return this.delegate.isBlocking();
    }

    @Override
    public boolean isRunningOnVirtualThread() {
        return this.delegate.isRunningOnVirtualThread();
    }

    protected CompletionStage<Void> invokeDelegate(ScheduledExecution execution) {
        try {
            return this.delegate.invoke(execution);
        }
        catch (Throwable e) {
            return CompletableFuture.failedStage(e);
        }
    }
}

