/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.scheduler.runtime;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import io.quarkus.arc.Arc;
import io.quarkus.runtime.StartupEvent;
import io.quarkus.scheduler.FailedExecution;
import io.quarkus.scheduler.Scheduled;
import io.quarkus.scheduler.ScheduledExecution;
import io.quarkus.scheduler.ScheduledJobPaused;
import io.quarkus.scheduler.ScheduledJobResumed;
import io.quarkus.scheduler.Scheduler;
import io.quarkus.scheduler.SchedulerPaused;
import io.quarkus.scheduler.SchedulerResumed;
import io.quarkus.scheduler.SkippedExecution;
import io.quarkus.scheduler.SuccessfulExecution;
import io.quarkus.scheduler.Trigger;
import io.quarkus.scheduler.common.runtime.AbstractJobDefinition;
import io.quarkus.scheduler.common.runtime.DefaultInvoker;
import io.quarkus.scheduler.common.runtime.Events;
import io.quarkus.scheduler.common.runtime.ScheduledInvoker;
import io.quarkus.scheduler.common.runtime.ScheduledMethod;
import io.quarkus.scheduler.common.runtime.SchedulerContext;
import io.quarkus.scheduler.common.runtime.SkipConcurrentExecutionInvoker;
import io.quarkus.scheduler.common.runtime.SkipPredicateInvoker;
import io.quarkus.scheduler.common.runtime.StatusEmitterInvoker;
import io.quarkus.scheduler.common.runtime.SyntheticScheduled;
import io.quarkus.scheduler.common.runtime.util.SchedulerUtils;
import io.quarkus.scheduler.runtime.SchedulerRuntimeConfig;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.smallrye.common.vertx.VertxContext;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import jakarta.annotation.PreDestroy;
import jakarta.annotation.Priority;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Typed;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.jboss.threads.JBossScheduledThreadPoolExecutor;

@Typed(value={Scheduler.class})
@Singleton
public class SimpleScheduler
implements Scheduler {
    private static final Logger LOG = Logger.getLogger(SimpleScheduler.class);
    private static final long CHECK_PERIOD = 1000L;
    private final ScheduledExecutorService scheduledExecutor;
    private final Vertx vertx;
    private volatile boolean running = true;
    private final ConcurrentMap<String, ScheduledTask> scheduledTasks;
    private final boolean enabled;
    private final CronParser cronParser;
    private final Duration defaultOverdueGracePeriod;
    private final Event<SkippedExecution> skippedExecutionEvent;
    private final Event<SuccessfulExecution> successExecutionEvent;
    private final Event<FailedExecution> failedExecutionEvent;
    private final Event<SchedulerPaused> schedulerPausedEvent;
    private final Event<SchedulerResumed> schedulerResumedEvent;
    private final Event<ScheduledJobPaused> scheduledJobPausedEvent;
    private final Event<ScheduledJobResumed> scheduledJobResumedEvent;

    public SimpleScheduler(SchedulerContext context, SchedulerRuntimeConfig schedulerRuntimeConfig, Event<SkippedExecution> skippedExecutionEvent, Event<SuccessfulExecution> successExecutionEvent, Event<FailedExecution> failedExecutionEvent, Event<SchedulerPaused> schedulerPausedEvent, Event<SchedulerResumed> schedulerResumedEvent, Event<ScheduledJobPaused> scheduledJobPausedEvent, Event<ScheduledJobResumed> scheduledJobResumedEvent, Vertx vertx) {
        this.enabled = schedulerRuntimeConfig.enabled;
        this.scheduledTasks = new ConcurrentHashMap<String, ScheduledTask>();
        this.vertx = vertx;
        this.skippedExecutionEvent = skippedExecutionEvent;
        this.successExecutionEvent = successExecutionEvent;
        this.failedExecutionEvent = failedExecutionEvent;
        this.schedulerPausedEvent = schedulerPausedEvent;
        this.schedulerResumedEvent = schedulerResumedEvent;
        this.scheduledJobPausedEvent = scheduledJobPausedEvent;
        this.scheduledJobResumedEvent = scheduledJobResumedEvent;
        CronDefinition definition = CronDefinitionBuilder.instanceDefinitionFor((CronType)context.getCronType());
        this.cronParser = new CronParser(definition);
        this.defaultOverdueGracePeriod = schedulerRuntimeConfig.overdueGracePeriod;
        if (!schedulerRuntimeConfig.enabled) {
            this.scheduledExecutor = null;
            LOG.info((Object)"Simple scheduler is disabled by config property and will not be started");
            return;
        }
        SchedulerRuntimeConfig.StartMode startMode = schedulerRuntimeConfig.startMode.orElse(SchedulerRuntimeConfig.StartMode.NORMAL);
        if (startMode == SchedulerRuntimeConfig.StartMode.NORMAL && context.getScheduledMethods().isEmpty()) {
            this.scheduledExecutor = null;
            LOG.info((Object)"No scheduled business methods found - Simple scheduler will not be started");
            return;
        }
        this.scheduledExecutor = new JBossScheduledThreadPoolExecutor(1, new Runnable(){

            @Override
            public void run() {
            }
        });
        if (startMode == SchedulerRuntimeConfig.StartMode.HALTED) {
            this.running = false;
        }
        for (ScheduledMethod method : context.getScheduledMethods()) {
            int nameSequence = 0;
            for (Scheduled scheduled : method.getSchedules()) {
                Optional<SimpleTrigger> trigger;
                ++nameSequence;
                Object id = SchedulerUtils.lookUpPropertyValue((String)scheduled.identity());
                if (((String)id).isEmpty()) {
                    id = nameSequence + "_" + method.getMethodDescription();
                }
                if (!(trigger = this.createTrigger((String)id, method.getMethodDescription(), this.cronParser, scheduled, this.defaultOverdueGracePeriod)).isPresent()) continue;
                ScheduledInvoker invoker = SimpleScheduler.initInvoker(context.createInvoker(method.getInvokerClassName()), skippedExecutionEvent, successExecutionEvent, failedExecutionEvent, scheduled.concurrentExecution(), SimpleScheduler.initSkipPredicate(scheduled.skipExecutionIf()));
                this.scheduledTasks.put(trigger.get().id, new ScheduledTask(trigger.get(), invoker, false));
            }
        }
    }

    public Scheduler.JobDefinition newJob(String identity) {
        Objects.requireNonNull(identity);
        if (this.scheduledTasks.containsKey(identity)) {
            throw new IllegalStateException("A job with this identity is already scheduled: " + identity);
        }
        return new SimpleJobDefinition(identity);
    }

    public Trigger unscheduleJob(String identity) {
        String parsedIdentity;
        ScheduledTask task;
        Objects.requireNonNull(identity);
        if (!identity.isEmpty() && (task = (ScheduledTask)this.scheduledTasks.get(parsedIdentity = SchedulerUtils.lookUpPropertyValue((String)identity))) != null && task.isProgrammatic && this.scheduledTasks.remove(task.trigger.id) != null) {
            return task.trigger;
        }
        return null;
    }

    void start(@Observes @Priority(value=0) StartupEvent event) {
        if (this.scheduledExecutor == null) {
            return;
        }
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime trunc = now.plusSeconds(1L).truncatedTo(ChronoUnit.SECONDS);
        this.scheduledExecutor.scheduleAtFixedRate(this::checkTriggers, ChronoUnit.MILLIS.between(now, trunc), 1000L, TimeUnit.MILLISECONDS);
    }

    @PreDestroy
    void stop() {
        try {
            if (this.scheduledExecutor != null) {
                this.scheduledExecutor.shutdownNow();
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Unable to shutdown the scheduler executor", (Throwable)e);
        }
    }

    void checkTriggers() {
        if (!this.running) {
            LOG.trace((Object)"Skip all triggers - scheduler paused");
            return;
        }
        ZonedDateTime now = ZonedDateTime.now();
        LOG.tracef("Check triggers at %s", (Object)now);
        for (ScheduledTask task : this.scheduledTasks.values()) {
            task.execute(now, this.vertx);
        }
    }

    public void pause() {
        if (!this.enabled) {
            LOG.warn((Object)"Scheduler is disabled and cannot be paused");
        } else {
            this.running = false;
            Events.fire(this.schedulerPausedEvent, (Object)SchedulerPaused.INSTANCE);
        }
    }

    public void pause(String identity) {
        Objects.requireNonNull(identity, "Cannot pause - identity is null");
        if (identity.isEmpty()) {
            LOG.warn((Object)"Cannot pause - identity is empty");
            return;
        }
        String parsedIdentity = SchedulerUtils.lookUpPropertyValue((String)identity);
        ScheduledTask task = (ScheduledTask)this.scheduledTasks.get(parsedIdentity);
        if (task != null) {
            task.trigger.setRunning(false);
            Events.fire(this.scheduledJobPausedEvent, (Object)new ScheduledJobPaused((Trigger)task.trigger));
        }
    }

    public boolean isPaused(String identity) {
        Objects.requireNonNull(identity);
        if (identity.isEmpty()) {
            return false;
        }
        String parsedIdentity = SchedulerUtils.lookUpPropertyValue((String)identity);
        ScheduledTask task = (ScheduledTask)this.scheduledTasks.get(parsedIdentity);
        if (task != null) {
            return !task.trigger.isRunning();
        }
        return false;
    }

    public void resume() {
        if (!this.enabled) {
            LOG.warn((Object)"Scheduler is disabled and cannot be resumed");
        } else {
            this.running = true;
            Events.fire(this.schedulerResumedEvent, (Object)SchedulerResumed.INSTANCE);
        }
    }

    public void resume(String identity) {
        Objects.requireNonNull(identity, "Cannot resume - identity is null");
        if (identity.isEmpty()) {
            LOG.warn((Object)"Cannot resume - identity is empty");
            return;
        }
        String parsedIdentity = SchedulerUtils.lookUpPropertyValue((String)identity);
        ScheduledTask task = (ScheduledTask)this.scheduledTasks.get(parsedIdentity);
        if (task != null) {
            task.trigger.setRunning(true);
            Events.fire(this.scheduledJobResumedEvent, (Object)new ScheduledJobResumed((Trigger)task.trigger));
        }
    }

    public boolean isRunning() {
        return this.enabled && this.running;
    }

    public List<Trigger> getScheduledJobs() {
        return this.scheduledTasks.values().stream().map(task -> task.trigger).collect(Collectors.toUnmodifiableList());
    }

    public Trigger getScheduledJob(String identity) {
        Objects.requireNonNull(identity);
        if (identity.isEmpty()) {
            return null;
        }
        String parsedIdentity = SchedulerUtils.lookUpPropertyValue((String)identity);
        ScheduledTask task = (ScheduledTask)this.scheduledTasks.get(parsedIdentity);
        if (task != null) {
            return task.trigger;
        }
        return null;
    }

    Optional<SimpleTrigger> createTrigger(String id, String methodDescription, CronParser parser, Scheduled scheduled, Duration defaultGracePeriod) {
        String cron;
        ZonedDateTime start = ZonedDateTime.now().truncatedTo(ChronoUnit.SECONDS);
        Long millisToAdd = null;
        if (scheduled.delay() > 0L) {
            millisToAdd = scheduled.delayUnit().toMillis(scheduled.delay());
        } else if (!scheduled.delayed().isEmpty()) {
            millisToAdd = SchedulerUtils.parseDelayedAsMillis((Scheduled)scheduled);
        }
        if (millisToAdd != null) {
            start = start.toInstant().plusMillis(millisToAdd).atZone(start.getZone());
        }
        if (!(cron = SchedulerUtils.lookUpPropertyValue((String)scheduled.cron())).isEmpty()) {
            Cron cronExpr;
            if (SchedulerUtils.isOff((String)cron)) {
                return Optional.empty();
            }
            try {
                cronExpr = parser.parse(cron);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Cannot parse cron expression: " + cron, e);
            }
            return Optional.of(new CronTrigger(id, start, cronExpr, SchedulerUtils.parseOverdueGracePeriod((Scheduled)scheduled, (Duration)defaultGracePeriod), SchedulerUtils.parseCronTimeZone((Scheduled)scheduled), methodDescription));
        }
        if (!scheduled.every().isEmpty()) {
            OptionalLong everyMillis = SchedulerUtils.parseEveryAsMillis((Scheduled)scheduled);
            if (!everyMillis.isPresent()) {
                return Optional.empty();
            }
            return Optional.of(new IntervalTrigger(id, start, everyMillis.getAsLong(), SchedulerUtils.parseOverdueGracePeriod((Scheduled)scheduled, (Duration)defaultGracePeriod), methodDescription));
        }
        throw new IllegalArgumentException("Either the 'cron' expression or the 'every' period must be set: " + scheduled);
    }

    public static ScheduledInvoker initInvoker(ScheduledInvoker invoker, Event<SkippedExecution> skippedExecutionEvent, Event<SuccessfulExecution> successExecutionEvent, Event<FailedExecution> failedExecutionEvent, Scheduled.ConcurrentExecution concurrentExecution, Scheduled.SkipPredicate skipPredicate) {
        invoker = new StatusEmitterInvoker(invoker, successExecutionEvent, failedExecutionEvent);
        if (concurrentExecution == Scheduled.ConcurrentExecution.SKIP) {
            invoker = new SkipConcurrentExecutionInvoker(invoker, skippedExecutionEvent);
        }
        if (skipPredicate != null) {
            invoker = new SkipPredicateInvoker(invoker, skipPredicate, skippedExecutionEvent);
        }
        return invoker;
    }

    public static Scheduled.SkipPredicate initSkipPredicate(Class<? extends Scheduled.SkipPredicate> predicateClass) {
        if (predicateClass.equals(Scheduled.Never.class)) {
            return null;
        }
        return (Scheduled.SkipPredicate)Arc.container().select(predicateClass, new Annotation[]{Any.Literal.INSTANCE}).get();
    }

    class SimpleJobDefinition
    extends AbstractJobDefinition {
        SimpleJobDefinition(String id) {
            super(id);
        }

        public Trigger schedule() {
            this.checkScheduled();
            if (this.task == null && this.asyncTask == null) {
                throw new IllegalStateException("Either sync or async task must be set");
            }
            this.scheduled = true;
            DefaultInvoker invoker = this.task != null ? new DefaultInvoker(){

                public CompletionStage<Void> invokeBean(ScheduledExecution execution) {
                    try {
                        SimpleJobDefinition.this.task.accept(execution);
                        return CompletableFuture.completedStage(null);
                    }
                    catch (Exception e) {
                        return CompletableFuture.failedStage(e);
                    }
                }
            } : new DefaultInvoker(){

                public CompletionStage<Void> invokeBean(ScheduledExecution execution) {
                    try {
                        return ((Uni)SimpleJobDefinition.this.asyncTask.apply(execution)).subscribeAsCompletionStage();
                    }
                    catch (Exception e) {
                        return CompletableFuture.failedStage(e);
                    }
                }

                public boolean isBlocking() {
                    return false;
                }
            };
            SyntheticScheduled scheduled = new SyntheticScheduled(this.identity, this.cron, this.every, 0L, TimeUnit.MINUTES, this.delayed, this.overdueGracePeriod, this.concurrentExecution, this.skipPredicate, this.timeZone);
            Optional<SimpleTrigger> trigger = SimpleScheduler.this.createTrigger(this.identity, null, SimpleScheduler.this.cronParser, (Scheduled)scheduled, SimpleScheduler.this.defaultOverdueGracePeriod);
            if (trigger.isPresent()) {
                SimpleTrigger simpleTrigger = trigger.get();
                invoker = SimpleScheduler.initInvoker((ScheduledInvoker)invoker, SimpleScheduler.this.skippedExecutionEvent, SimpleScheduler.this.successExecutionEvent, SimpleScheduler.this.failedExecutionEvent, this.concurrentExecution, this.skipPredicate);
                ScheduledTask scheduledTask = new ScheduledTask(trigger.get(), (ScheduledInvoker)invoker, true);
                ScheduledTask existing = SimpleScheduler.this.scheduledTasks.putIfAbsent(simpleTrigger.id, scheduledTask);
                if (existing != null) {
                    throw new IllegalStateException("A job with this identity is already scheduled: " + this.identity);
                }
                return simpleTrigger;
            }
            return null;
        }
    }

    static class SimpleScheduledExecution
    implements ScheduledExecution {
        private final ZonedDateTime fireTime;
        private final ZonedDateTime scheduledFireTime;
        private final Trigger trigger;

        public SimpleScheduledExecution(ZonedDateTime fireTime, ZonedDateTime scheduledFireTime, SimpleTrigger trigger) {
            this.fireTime = fireTime;
            this.scheduledFireTime = scheduledFireTime;
            this.trigger = trigger;
        }

        public Trigger getTrigger() {
            return this.trigger;
        }

        public Instant getFireTime() {
            return this.fireTime.toInstant();
        }

        public Instant getScheduledFireTime() {
            return this.scheduledFireTime.toInstant();
        }
    }

    static class CronTrigger
    extends SimpleTrigger {
        private final Cron cron;
        private final ExecutionTime executionTime;
        private final Duration gracePeriod;
        private final ZoneId timeZone;

        CronTrigger(String id, ZonedDateTime start, Cron cron, Duration gracePeriod, ZoneId timeZone, String description) {
            super(id, start, description);
            this.cron = cron;
            this.executionTime = ExecutionTime.forCron((Cron)cron);
            this.lastFireTime = start;
            this.gracePeriod = gracePeriod;
            this.timeZone = timeZone;
        }

        public Instant getNextFireTime() {
            Optional nextFireTime = this.executionTime.nextExecution(this.lastFireTime);
            return nextFireTime.isPresent() ? ((ZonedDateTime)nextFireTime.get()).toInstant() : null;
        }

        @Override
        ZonedDateTime evaluate(ZonedDateTime now) {
            ZonedDateTime lastTruncated;
            if (now.isBefore(this.start)) {
                return null;
            }
            ZonedDateTime zonedNow = this.timeZone == null ? now : now.withZoneSameInstant(this.timeZone);
            Optional lastExecution = this.executionTime.lastExecution(zonedNow);
            if (lastExecution.isPresent() && zonedNow.isAfter(lastTruncated = ((ZonedDateTime)lastExecution.get()).truncatedTo(ChronoUnit.SECONDS)) && this.lastFireTime.isBefore(lastTruncated)) {
                LOG.tracef("%s fired, last=", (Object)this, (Object)lastTruncated);
                this.lastFireTime = zonedNow;
                return lastTruncated;
            }
            return null;
        }

        public boolean isOverdue() {
            ZonedDateTime now = ZonedDateTime.now();
            if (now.isBefore(this.start)) {
                return false;
            }
            ZonedDateTime zonedNow = this.timeZone == null ? now : now.withZoneSameInstant(this.timeZone);
            Optional nextFireTime = this.executionTime.nextExecution(this.lastFireTime);
            return nextFireTime.isEmpty() || ((ZonedDateTime)nextFireTime.get()).plus(this.gracePeriod).isBefore(zonedNow);
        }

        public String toString() {
            return "CronTrigger [id=" + this.id + ", cron=" + this.cron.asString() + ", gracePeriod=" + this.gracePeriod + ", timeZone=" + this.timeZone + "]";
        }
    }

    static class IntervalTrigger
    extends SimpleTrigger {
        private final long interval;
        private final Duration gracePeriod;

        IntervalTrigger(String id, ZonedDateTime start, long interval, Duration gracePeriod, String description) {
            super(id, start, description);
            this.interval = interval;
            this.gracePeriod = gracePeriod;
        }

        @Override
        ZonedDateTime evaluate(ZonedDateTime now) {
            if (now.isBefore(this.start)) {
                return null;
            }
            if (this.lastFireTime == null) {
                this.lastFireTime = now.truncatedTo(ChronoUnit.SECONDS);
                return now;
            }
            long diff = ChronoUnit.MILLIS.between(this.lastFireTime, now);
            if (diff >= this.interval) {
                ZonedDateTime scheduledFireTime = this.lastFireTime.plus(Duration.ofMillis(this.interval));
                this.lastFireTime = now.truncatedTo(ChronoUnit.SECONDS);
                LOG.tracef("%s fired, diff=%s ms", (Object)this, (Object)diff);
                return scheduledFireTime;
            }
            return null;
        }

        public Instant getNextFireTime() {
            ZonedDateTime last = this.lastFireTime;
            if (last == null) {
                last = this.start;
            }
            return last.plus(Duration.ofMillis(this.interval)).toInstant();
        }

        public boolean isOverdue() {
            ZonedDateTime now = ZonedDateTime.now();
            if (now.isBefore(this.start)) {
                return false;
            }
            return this.lastFireTime == null || this.lastFireTime.plus(Duration.ofMillis(this.interval)).plus(this.gracePeriod).isBefore(now);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("IntervalTrigger [id=").append(this.getId()).append(", interval=").append(this.interval).append("]");
            return builder.toString();
        }
    }

    static abstract class SimpleTrigger
    implements Trigger {
        protected final String id;
        protected final String methodDescription;
        private volatile boolean running;
        protected final ZonedDateTime start;
        protected volatile ZonedDateTime lastFireTime;

        SimpleTrigger(String id, ZonedDateTime start, String description) {
            this.id = id;
            this.start = start;
            this.running = true;
            this.methodDescription = description;
        }

        abstract ZonedDateTime evaluate(ZonedDateTime var1);

        public Instant getPreviousFireTime() {
            ZonedDateTime last = this.lastFireTime;
            return last != null ? last.toInstant() : null;
        }

        public String getId() {
            return this.id;
        }

        synchronized boolean isRunning() {
            return this.running;
        }

        synchronized void setRunning(boolean running) {
            this.running = running;
        }

        public String getMethodDescription() {
            return this.methodDescription;
        }
    }

    static class ScheduledTask {
        final boolean isProgrammatic;
        final SimpleTrigger trigger;
        final ScheduledInvoker invoker;

        ScheduledTask(SimpleTrigger trigger, ScheduledInvoker invoker, boolean isProgrammatic) {
            this.trigger = trigger;
            this.invoker = invoker;
            this.isProgrammatic = isProgrammatic;
        }

        void execute(final ZonedDateTime now, Vertx vertx) {
            if (!this.trigger.isRunning()) {
                return;
            }
            final ZonedDateTime scheduledFireTime = this.trigger.evaluate(now);
            if (scheduledFireTime != null) {
                Context context = VertxContext.getOrCreateDuplicatedContext((Vertx)vertx);
                VertxContextSafetyToggle.setContextSafe((Context)context, (boolean)true);
                if (this.invoker.isBlocking()) {
                    context.executeBlocking((Handler)new Handler<Promise<Object>>(){

                        public void handle(Promise<Object> p) {
                            try {
                                this.doInvoke(now, scheduledFireTime);
                            }
                            finally {
                                p.complete();
                            }
                        }
                    }, false);
                } else {
                    context.runOnContext((Handler)new Handler<Void>(){

                        public void handle(Void event) {
                            this.doInvoke(now, scheduledFireTime);
                        }
                    });
                }
            }
        }

        void doInvoke(ZonedDateTime now, ZonedDateTime scheduledFireTime) {
            try {
                this.invoker.invoke((ScheduledExecution)new SimpleScheduledExecution(now, scheduledFireTime, this.trigger));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

