/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.health.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ManagedContext;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.vertx.core.runtime.BufferOutputStream;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.smallrye.health.SmallRyeHealth;
import io.smallrye.health.SmallRyeHealthReporter;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.MutinyHelper;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;

abstract class SmallRyeHealthHandlerBase
implements Handler<RoutingContext> {
    SmallRyeHealthHandlerBase() {
    }

    protected abstract Uni<SmallRyeHealth> getHealth(SmallRyeHealthReporter var1, RoutingContext var2);

    public void handle(RoutingContext ctx) {
        ManagedContext requestContext = Arc.container().requestContext();
        if (requestContext.isActive()) {
            this.doHandle(ctx, null);
        } else {
            requestContext.activate();
            try {
                this.doHandle(ctx, requestContext);
            }
            catch (Exception e) {
                requestContext.terminate();
                throw e;
            }
        }
    }

    private void doHandle(RoutingContext ctx, ManagedContext requestContext) {
        QuarkusHttpUser user = (QuarkusHttpUser)ctx.user();
        if (user != null) {
            ((CurrentIdentityAssociation)Arc.container().instance(CurrentIdentityAssociation.class, new Annotation[0]).get()).setIdentity(user.getSecurityIdentity());
        }
        SmallRyeHealthReporter reporter = (SmallRyeHealthReporter)Arc.container().instance(SmallRyeHealthReporter.class, new Annotation[0]).get();
        Context context = Vertx.currentContext();
        this.getHealth(reporter, ctx).emitOn(MutinyHelper.executor((Context)context)).subscribe().with(health -> {
            if (requestContext != null) {
                requestContext.terminate();
            }
            HttpServerResponse resp = ctx.response();
            if (health.isDown()) {
                resp.setStatusCode(503);
            }
            resp.headers().set(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json; charset=UTF-8");
            Buffer buffer = Buffer.buffer((int)256);
            try (BufferOutputStream outputStream = new BufferOutputStream(buffer);){
                reporter.reportHealth((OutputStream)outputStream, health);
                resp.end(buffer);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }, failure -> {
            if (requestContext != null) {
                requestContext.terminate();
            }
        });
    }
}

