/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.stork;

import io.quarkus.stork.ServiceConfiguration;
import io.quarkus.stork.StorkConfiguration;
import io.smallrye.stork.api.config.ConfigWithType;
import io.smallrye.stork.api.config.ServiceConfig;
import io.smallrye.stork.spi.config.SimpleServiceConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class StorkConfigUtil {
    public static List<ServiceConfig> toStorkServiceConfig(StorkConfiguration storkConfiguration) {
        ArrayList<ServiceConfig> storkServicesConfigs = new ArrayList<ServiceConfig>();
        Set<String> servicesConfigs = storkConfiguration.serviceConfiguration().keySet();
        SimpleServiceConfig.Builder builder = new SimpleServiceConfig.Builder();
        for (String serviceName : servicesConfigs) {
            builder.setServiceName(serviceName);
            ServiceConfiguration serviceConfiguration = storkConfiguration.serviceConfiguration().get(serviceName);
            if (serviceConfiguration.serviceDiscovery().isPresent()) {
                SimpleServiceConfig.SimpleServiceDiscoveryConfig storkServiceDiscoveryConfig = new SimpleServiceConfig.SimpleServiceDiscoveryConfig(serviceConfiguration.serviceDiscovery().get().type(), serviceConfiguration.serviceDiscovery().get().params());
                builder = builder.setServiceDiscovery((ConfigWithType)storkServiceDiscoveryConfig);
                SimpleServiceConfig.SimpleLoadBalancerConfig loadBalancerConfig = new SimpleServiceConfig.SimpleLoadBalancerConfig(serviceConfiguration.loadBalancer().type(), serviceConfiguration.loadBalancer().parameters());
                builder.setLoadBalancer((ConfigWithType)loadBalancerConfig);
            }
            if (serviceConfiguration.serviceRegistrar().isPresent()) {
                SimpleServiceConfig.SimpleServiceRegistrarConfig serviceRegistrarConfig = new SimpleServiceConfig.SimpleServiceRegistrarConfig(serviceConfiguration.serviceRegistrar().get().type(), serviceConfiguration.serviceRegistrar().get().parameters());
                builder.setServiceRegistrar((ConfigWithType)serviceRegistrarConfig);
            }
            storkServicesConfigs.add((ServiceConfig)builder.build());
        }
        return storkServicesConfigs;
    }
}

