/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common;

import io.quarkus.commons.classloading.ClassloadHelper;
import io.quarkus.runtime.util.ClassPathUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public final class PathTestHelper {
    private static final String TARGET = "target";
    private static final Map<String, String> TEST_TO_MAIN_DIR_FRAGMENTS = new HashMap<String, String>();

    private PathTestHelper() {
    }

    public static Path getTestClassesLocation(Class<?> testClass) {
        String classFileName = testClass.getName().replace('.', File.separatorChar) + ".class";
        URL resource = testClass.getClassLoader().getResource(ClassloadHelper.fromClassNameToResourceName((String)testClass.getName()));
        if (resource.getProtocol().equals("jar")) {
            try {
                resource = URI.create(resource.getFile().substring(0, resource.getFile().indexOf(33))).toURL();
                return PathTestHelper.toPath(resource);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Failed to resolve the location of the JAR containing " + testClass, e);
            }
        }
        Path path = PathTestHelper.toPath(resource);
        path = path.getRoot().resolve(path.subpath(0, path.getNameCount() - Path.of(classFileName, new String[0]).getNameCount()));
        if (!PathTestHelper.isInTestDir(resource) && !path.getParent().getFileName().toString().equals(TARGET)) {
            StringBuilder msg = new StringBuilder();
            msg.append("The test class ").append(testClass.getName()).append(" is not located in any of the directories ");
            Iterator<String> i = TEST_TO_MAIN_DIR_FRAGMENTS.keySet().iterator();
            msg.append(i.next());
            while (i.hasNext()) {
                msg.append(", ").append(i.next());
            }
            throw new RuntimeException(msg.toString());
        }
        return path;
    }

    public static Path getAppClassLocation(Class<?> testClass) {
        return PathTestHelper.getAppClassLocationForTestLocation(PathTestHelper.getTestClassesLocation(testClass).toString());
    }

    public static Path getAppClassLocationForTestLocation(String testClassLocation) {
        if (testClassLocation.endsWith(".jar")) {
            if (testClassLocation.endsWith("-tests.jar")) {
                return Paths.get(new StringBuilder().append(testClassLocation, 0, testClassLocation.length() - "-tests.jar".length()).append(".jar").toString(), new String[0]);
            }
            return Path.of(testClassLocation, new String[0]);
        }
        Optional<Path> mainClassesDir = TEST_TO_MAIN_DIR_FRAGMENTS.entrySet().stream().filter(e -> testClassLocation.contains((CharSequence)e.getKey())).map(e -> {
            int i = testClassLocation.lastIndexOf((String)e.getKey());
            StringBuilder buf = new StringBuilder(testClassLocation.length());
            buf.append(testClassLocation.substring(0, i)).append((String)e.getValue());
            if (i + ((String)e.getKey()).length() + 1 < testClassLocation.length()) {
                buf.append(testClassLocation.substring(i + ((String)e.getKey()).length()));
            }
            return Path.of(buf.toString(), new String[0]);
        }).findFirst();
        Path p = null;
        if (mainClassesDir.isPresent() && Files.exists(p = mainClassesDir.get(), new LinkOption[0])) {
            return p;
        }
        p = Path.of(testClassLocation, new String[0]).getParent();
        if (p != null && p.getFileName().toString().equals(TARGET) && Files.exists(p = p.resolve("classes"), new LinkOption[0])) {
            return p;
        }
        if (mainClassesDir.isPresent()) {
            return mainClassesDir.get();
        }
        throw new IllegalStateException("Unable to translate path for " + testClassLocation);
    }

    public static Path getResourcesForClassesDirOrNull(Path classesDir, String name) {
        if (!Files.isDirectory(classesDir, new LinkOption[0])) {
            return null;
        }
        Path p = classesDir.getParent();
        if (p == null) {
            return null;
        }
        if ((p = p.getParent()) == null) {
            return null;
        }
        if ((p = p.getParent()) == null) {
            return null;
        }
        if (Files.exists(p = p.resolve("resources").resolve(name), new LinkOption[0])) {
            return p;
        }
        return null;
    }

    public static boolean isTestClass(String className, ClassLoader classLoader, Path testLocation) {
        URL resource = classLoader.getResource(ClassloadHelper.fromClassNameToResourceName((String)className));
        if (resource == null) {
            return false;
        }
        if (Files.isDirectory(testLocation, new LinkOption[0])) {
            return resource.getProtocol().startsWith("file") && PathTestHelper.toPath(resource).startsWith(testLocation);
        }
        if (!resource.getProtocol().equals("jar")) {
            return false;
        }
        String path = resource.getPath();
        if (!path.startsWith("file:")) {
            return false;
        }
        path = path.substring(5, path.lastIndexOf(33));
        return testLocation.equals(Path.of(path, new String[0]));
    }

    private static boolean isInTestDir(URL resource) {
        String path = PathTestHelper.toPath(resource).toString();
        return TEST_TO_MAIN_DIR_FRAGMENTS.keySet().stream().anyMatch(path::contains);
    }

    private static Path toPath(URL resource) {
        return ClassPathUtils.toLocalPath((URL)resource);
    }

    public static Path getProjectBuildDir(Path projectRoot, Path testClassLocation) {
        if (!testClassLocation.startsWith(projectRoot)) {
            return projectRoot.resolve(TARGET);
        }
        return projectRoot.resolve(projectRoot.relativize(testClassLocation).getName(0));
    }

    static {
        TEST_TO_MAIN_DIR_FRAGMENTS.put("bin" + File.separator + "test", "bin" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("out" + File.separator + "test", "out" + File.separator + "production");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "java" + File.separator + "native-test", "classes" + File.separator + "java" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "java" + File.separator + "test", "classes" + File.separator + "java" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "java" + File.separator + "integration-test", "classes" + File.separator + "java" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "java" + File.separator + "integrationTest", "classes" + File.separator + "java" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "java" + File.separator + "native-integrationTest", "classes" + File.separator + "java" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "java" + File.separator + "native-integration-test", "classes" + File.separator + "java" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("quarkus-app-classes-test", "quarkus-app-classes");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "kotlin" + File.separator + "native-test", "classes" + File.separator + "kotlin" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "kotlin" + File.separator + "test", "classes" + File.separator + "kotlin" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "kotlin" + File.separator + "integration-test", "classes" + File.separator + "kotlin" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "kotlin" + File.separator + "integrationTest", "classes" + File.separator + "kotlin" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "kotlin" + File.separator + "native-integrationTest", "classes" + File.separator + "kotlin" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "kotlin" + File.separator + "native-integration-test", "classes" + File.separator + "kotlin" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "scala" + File.separator + "native-test", "classes" + File.separator + "scala" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "scala" + File.separator + "test", "classes" + File.separator + "scala" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "scala" + File.separator + "integration-test", "classes" + File.separator + "scala" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "scala" + File.separator + "integrationTest", "classes" + File.separator + "scala" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "scala" + File.separator + "native-integrationTest", "classes" + File.separator + "scala" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "scala" + File.separator + "native-integration-test", "classes" + File.separator + "scala" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put(File.separator + "test-classes", File.separator + "classes");
        String mappings = System.getenv("TEST_TO_MAIN_MAPPINGS");
        if (mappings != null) {
            Stream.of(mappings.split(",")).filter(s -> !s.isEmpty()).forEach(s -> {
                String[] entry = s.split(":");
                if (entry.length != 2) {
                    throw new IllegalStateException("Unable to parse additional test-to-main mapping: " + s);
                }
                TEST_TO_MAIN_DIR_FRAGMENTS.put(entry[0], entry[1]);
            });
        }
    }
}

