/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.tls.runtime;

import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.tls.TlsConfiguration;
import io.quarkus.tls.TlsConfigurationRegistry;
import io.quarkus.tls.runtime.KeyStoreAndKeyCertOptions;
import io.quarkus.tls.runtime.TrustStoreAndTrustOptions;
import io.quarkus.tls.runtime.VertxCertificateHolder;
import io.quarkus.tls.runtime.config.KeyStoreConfig;
import io.quarkus.tls.runtime.config.TlsBucketConfig;
import io.quarkus.tls.runtime.config.TlsConfig;
import io.quarkus.tls.runtime.config.TrustStoreConfig;
import io.quarkus.tls.runtime.keystores.JKSKeyStores;
import io.quarkus.tls.runtime.keystores.P12KeyStores;
import io.quarkus.tls.runtime.keystores.PemKeyStores;
import io.quarkus.tls.runtime.keystores.TrustAllOptions;
import io.vertx.core.Vertx;
import java.security.KeyStoreException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

@Recorder
public class CertificateRecorder
implements TlsConfigurationRegistry {
    private final Map<String, TlsConfiguration> certificates = new ConcurrentHashMap<String, TlsConfiguration>();

    public void validateCertificates(TlsConfig config, RuntimeValue<Vertx> vertx) {
        if (config.defaultCertificateConfig().isPresent()) {
            this.verifyCertificateConfig(config.defaultCertificateConfig().get(), (Vertx)vertx.getValue(), "<default>");
        }
        for (String name : config.namedCertificateConfig().keySet()) {
            this.verifyCertificateConfig(config.namedCertificateConfig().get(name), (Vertx)vertx.getValue(), name);
        }
    }

    public void verifyCertificateConfig(TlsBucketConfig config, Vertx vertx, String name) {
        KeyStoreAndKeyCertOptions ks = null;
        if (config.keyStore().isPresent()) {
            KeyStoreConfig keyStoreConfig = config.keyStore().get();
            ks = CertificateRecorder.verifyKeyStore(keyStoreConfig, vertx, name);
            boolean sni = keyStoreConfig.sni();
            if (sni) {
                try {
                    if (Collections.list(ks.keyStore.aliases()).size() <= 1) {
                        throw new IllegalStateException("The SNI option cannot be used when the keystore contains only one alias or the `alias` property has been set");
                    }
                }
                catch (KeyStoreException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        TrustStoreAndTrustOptions ts = null;
        if (config.trustStore().isPresent()) {
            ts = CertificateRecorder.verifyTrustStore(config.trustStore().get(), vertx, name);
        }
        if (config.trustAll() && ts != null) {
            throw new IllegalStateException("The trust-all option cannot be used when a trust-store is configured");
        }
        if (config.trustAll()) {
            ts = new TrustStoreAndTrustOptions(null, TrustAllOptions.INSTANCE);
        }
        this.certificates.put(name, new VertxCertificateHolder(vertx, name, config, ks, ts));
    }

    public static KeyStoreAndKeyCertOptions verifyKeyStore(KeyStoreConfig config, Vertx vertx, String name) {
        config.validate(name);
        if (config.pem().isPresent()) {
            return PemKeyStores.verifyPEMKeyStore(config, vertx, name);
        }
        if (config.p12().isPresent()) {
            return P12KeyStores.verifyP12KeyStore(config, vertx, name);
        }
        if (config.jks().isPresent()) {
            return JKSKeyStores.verifyJKSKeyStore(config, vertx, name);
        }
        return null;
    }

    public static TrustStoreAndTrustOptions verifyTrustStore(TrustStoreConfig config, Vertx vertx, String name) {
        config.validate(name);
        if (config.pem().isPresent()) {
            return PemKeyStores.verifyPEMTrustStoreStore(config, vertx, name);
        }
        if (config.p12().isPresent()) {
            return P12KeyStores.verifyP12TrustStoreStore(config, vertx, name);
        }
        if (config.jks().isPresent()) {
            return JKSKeyStores.verifyJKSTrustStoreStore(config, vertx, name);
        }
        return null;
    }

    @Override
    public Optional<TlsConfiguration> get(String name) {
        return Optional.ofNullable(this.certificates.get(name));
    }

    @Override
    public Optional<TlsConfiguration> getDefault() {
        return this.get("<default>");
    }

    @Override
    public void register(String name, TlsConfiguration configuration) {
        if (name == null) {
            throw new IllegalArgumentException("The name of the TLS configuration to register cannot be null");
        }
        if (name.equals("<default>")) {
            throw new IllegalArgumentException("The name of the TLS configuration to register cannot be <default>");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("The TLS configuration to register cannot be null");
        }
        this.certificates.put(name, configuration);
    }

    public Supplier<TlsConfigurationRegistry> getSupplier() {
        return new Supplier<TlsConfigurationRegistry>(){

            @Override
            public TlsConfigurationRegistry get() {
                return CertificateRecorder.this;
            }
        };
    }

    public void register(String name, Supplier<TlsConfiguration> supplier) {
        this.register(name, supplier.get());
    }
}

