/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.updates.camel.camel40.xml;

import io.quarkus.updates.camel.AbstractCamelQuarkusXmlVisitor;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.marker.Markers;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public class XmlDslRecipe
extends Recipe {
    private static final XPathMatcher ROUTE_DESCRIPTION_XPATH_MATCHER = new XPathMatcher("/routes/route/description");
    private static final XPathMatcher ROUTE_XPATH_MATCHER = new XPathMatcher("/routes/route");

    public String getDisplayName() {
        return "Camel XMl DSL changes";
    }

    public String getDescription() {
        return "Apache Camel XML DSL migration from version 3.20 or higher to 4.0.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new AbstractCamelQuarkusXmlVisitor(){

            @Override
            public Xml.Tag doVisitTag(Xml.Tag tag, ExecutionContext ctx) {
                String d;
                Xml.Tag t = super.doVisitTag(tag, ctx);
                if (ROUTE_XPATH_MATCHER.matches(this.getCursor()) && (d = (String)ctx.pollMessage("description")) != null) {
                    return t.withAttributes(ListUtils.concat((List)t.getAttributes(), (Object)((Xml.Attribute)this.autoFormat((Xml)new Xml.Attribute(Tree.randomId(), "", Markers.EMPTY, new Xml.Ident(Tree.randomId(), "", Markers.EMPTY, "description"), "", (Xml.Attribute.Value)this.autoFormat((Xml)new Xml.Attribute.Value(Tree.randomId(), "", Markers.EMPTY, Xml.Attribute.Value.Quote.Double, d), ctx)), ctx))));
                }
                if (ROUTE_DESCRIPTION_XPATH_MATCHER.matches(this.getCursor())) {
                    t.getValue().ifPresent(s -> ctx.putMessage("description", s));
                    return null;
                }
                return t;
            }
        };
    }
}

