/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.updates.camel.camel44;

import io.quarkus.updates.camel.AbstractCamelQuarkusJavaVisitor;
import io.quarkus.updates.camel.RecipesUtil;
import java.util.ArrayList;
import java.util.Collections;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;

public final class CamelCoreRecipe
extends Recipe {
    private static final String M_EXCHANGE_GET_CREATED = "org.apache.camel.Exchange getCreated()";
    private static final String M_PROPERTIES_LOOKUP_LOOKUP = "org.apache.camel.component.properties.PropertiesLookup lookup(java.lang.String)";
    private static final String M_EXPRESSION_CAUSE_JSONPATH1 = "org.apache.camel.builder.ExpressionClause jsonpath(java.lang.String, boolean, java.lang.Class, java.lang.String)";
    private static final String M_EXPRESSION_CAUSE_JSONPATH2 = "org.apache.camel.builder.ExpressionClause jsonpathWriteAsString(java.lang.String, boolean, java.lang.String)";
    private static final String M_EXPRESSION_CAUSE_XPATH1 = "org.apache.camel.builder.ExpressionClause xpath(java.lang.String, java.lang.String)";
    private static final String M_EXPRESSION_CAUSE_XPATH2 = "org.apache.camel.builder.ExpressionClause xpath(java.lang.String, java.lang.Class, java.lang.String)";
    private static final String M_EXPRESSION_CAUSE_XPATH3 = "org.apache.camel.builder.ExpressionClause xpath(java.lang.String, java.lang.Class, org.apache.camel.support.builder.Namespaces, java.lang.String)";
    private static final String M_EXPRESSION_CAUSE_TOKENIZE1 = "org.apache.camel.builder.ExpressionClause tokenize(java.lang.String, boolean, int, java.lang.String, boolean)";
    private static final String M_EXPRESSION_CAUSE_TOKENIZE2 = "org.apache.camel.builder.ExpressionClause tokenize(java.lang.String, java.lang.String)";
    private static final String M_EXPRESSION_CAUSE_TOKENIZE3 = "org.apache.camel.builder.ExpressionClause tokenize(java.lang.String, java.lang.String, boolean)";
    private static final String M_EXPRESSION_CAUSE_XQUERY1 = "org.apache.camel.builder.ExpressionClause xquery(java.lang.String, java.lang.String)";
    private static final String M_EXPRESSION_CAUSE_XQUERY2 = "org.apache.camel.builder.ExpressionClause xquery(java.lang.String, java.lang.Class, java.lang.String)";
    private static final String M_EXPRESSION_CAUSE_XQUERY3 = "org.apache.camel.builder.ExpressionClause xquery(java.lang.String, java.lang.Class, boolean, java.lang.String)";
    private static final String CONST_STOP_WATCH_LONG01 = "org.apache.camel.util.StopWatch <constructor>(long)";
    private static final String CONST_STOP_WATCH_LONG02 = "org.apache.camel.util.StopWatch <constructor>(java.lang.Long)";

    public String getDisplayName() {
        return "Camel Core changes";
    }

    public String getDescription() {
        return "Apache Camel Core migration from version 4.3 to 4.4.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return RecipesUtil.newVisitor(new AbstractCamelQuarkusJavaVisitor(){

            @Override
            protected J.MethodInvocation doVisitMethodInvocation(J.MethodInvocation method, ExecutionContext context) {
                J.MethodInvocation mi = super.doVisitMethodInvocation(method, context);
                if (this.getMethodMatcher(CamelCoreRecipe.M_EXCHANGE_GET_CREATED).matches(mi, false)) {
                    mi = mi.withName(mi.getName().withSimpleName("getClock().getCreated"));
                } else if (this.getMethodMatcher(CamelCoreRecipe.M_PROPERTIES_LOOKUP_LOOKUP).matches(mi, false) && mi.getArguments().size() == 1) {
                    ArrayList<Expression> arguments = new ArrayList<Expression>(mi.getArguments());
                    arguments.add(RecipesUtil.createNullExpression());
                    mi = mi.withArguments(arguments);
                } else if (this.getMethodMatcher(CamelCoreRecipe.M_EXPRESSION_CAUSE_JSONPATH1).matches(mi, false) || this.getMethodMatcher(CamelCoreRecipe.M_EXPRESSION_CAUSE_JSONPATH2).matches(mi, false) || this.getMethodMatcher(CamelCoreRecipe.M_EXPRESSION_CAUSE_TOKENIZE1).matches(mi, false) || this.getMethodMatcher(CamelCoreRecipe.M_EXPRESSION_CAUSE_TOKENIZE2).matches(mi, false) || this.getMethodMatcher(CamelCoreRecipe.M_EXPRESSION_CAUSE_TOKENIZE3).matches(mi, false) || this.getMethodMatcher(CamelCoreRecipe.M_EXPRESSION_CAUSE_XPATH1).matches(mi, false) || this.getMethodMatcher(CamelCoreRecipe.M_EXPRESSION_CAUSE_XPATH2).matches(mi, false) || this.getMethodMatcher(CamelCoreRecipe.M_EXPRESSION_CAUSE_XPATH3).matches(mi, false) || this.getMethodMatcher(CamelCoreRecipe.M_EXPRESSION_CAUSE_XQUERY1).matches(mi, false) || this.getMethodMatcher(CamelCoreRecipe.M_EXPRESSION_CAUSE_XQUERY2).matches(mi, false) || this.getMethodMatcher(CamelCoreRecipe.M_EXPRESSION_CAUSE_XQUERY3).matches(mi, false)) {
                    mi = (J.MethodInvocation)mi.withName(RecipesUtil.createIdentifier(Space.EMPTY, "removed_" + mi.getSimpleName(), mi.getType().toString())).withComments(Collections.singletonList(RecipesUtil.createMultinlineComment("Some Java DSL for tokenize, xmlTokenize, xpath, xquery and jsonpath has been removed as part of making the DSL model consistent.\nSee https://camel.apache.org/manual/camel-4x-upgrade-guide-4_4.html#_camel_core for more details.\n")));
                }
                return mi;
            }

            @Override
            protected J.NewClass doVisitNewClass(J.NewClass newClass, ExecutionContext context) {
                J.NewClass nc = super.doVisitNewClass(newClass, context);
                if ((this.getMethodMatcher(CamelCoreRecipe.CONST_STOP_WATCH_LONG01).matches((MethodCall)nc) || this.getMethodMatcher(CamelCoreRecipe.CONST_STOP_WATCH_LONG02).matches((MethodCall)nc)) && nc.getArguments().size() == 1) {
                    nc = (J.NewClass)nc.withArguments(Collections.emptyList()).withComments(Collections.singletonList(RecipesUtil.createMultinlineComment("Removed the deprecated constructor from the internal class org.apache.camel.util.StopWatch.\nUsers of this class are advised to use the default constructor if necessary.Changed exception thrown from IOException to Exception.\n")));
                }
                return nc;
            }
        });
    }

    @Generated
    public CamelCoreRecipe() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "CamelCoreRecipe()";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CamelCoreRecipe)) {
            return false;
        }
        CamelCoreRecipe other = (CamelCoreRecipe)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof CamelCoreRecipe;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

