/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment.devmode.console;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ConfigDescriptionBuildItem;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.devconsole.runtime.spi.DevConsolePostHandler;
import io.quarkus.devconsole.spi.DevConsoleRouteBuildItem;
import io.quarkus.devconsole.spi.DevConsoleTemplateInfoBuildItem;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.ext.web.RoutingContext;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class ConfigEditorProcessor {
    @BuildStep
    DevConsoleTemplateInfoBuildItem config(List<ConfigDescriptionBuildItem> config) throws Exception {
        ArrayList<CurrentConfig> configs = new ArrayList<CurrentConfig>();
        Config current = ConfigProvider.getConfig();
        Properties appProperties = new Properties();
        Path appProps = null;
        for (Path path : DevConsoleManager.getHotReplacementContext().getResourcesDir()) {
            Path app = path.resolve("application.properties");
            if (!Files.exists(app, new LinkOption[0])) continue;
            appProps = app;
            break;
        }
        if (appProps != null) {
            Throwable throwable = null;
            try (InputStream in = Files.newInputStream(appProps, new OpenOption[0]);){
                appProperties.load(in);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        for (ConfigDescriptionBuildItem configDescriptionBuildItem : config) {
            if (configDescriptionBuildItem.getPropertyName().contains("*")) continue;
            configs.add(new CurrentConfig(configDescriptionBuildItem.getPropertyName(), configDescriptionBuildItem.getDocs(), configDescriptionBuildItem.getDefaultValue(), current.getOptionalValue(configDescriptionBuildItem.getPropertyName(), String.class).orElse(null), appProperties.getProperty(configDescriptionBuildItem.getPropertyName())));
        }
        Collections.sort(configs);
        return new DevConsoleTemplateInfoBuildItem("config", configs);
    }

    @BuildStep
    DevConsoleRouteBuildItem handlePost() {
        return new DevConsoleRouteBuildItem("config", "POST", (Handler)new DevConsolePostHandler(){

            protected void handlePost(RoutingContext event, MultiMap form) throws Exception {
                Object app;
                String key = event.request().getFormAttribute("name");
                String value = event.request().getFormAttribute("value");
                Properties appProperties = new Properties();
                Path appProps = null;
                for (Path i : DevConsoleManager.getHotReplacementContext().getResourcesDir()) {
                    app = i.resolve("application.properties");
                    if (!Files.exists((Path)app, new LinkOption[0])) continue;
                    appProps = app;
                    break;
                }
                boolean present = false;
                if (appProps != null) {
                    InputStream in = Files.newInputStream(appProps, new OpenOption[0]);
                    app = null;
                    try {
                        appProperties.load(in);
                        present = appProperties.containsKey(key);
                    }
                    catch (Throwable throwable) {
                        app = throwable;
                        throw throwable;
                    }
                    finally {
                        if (in != null) {
                            if (app != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)app).addSuppressed(throwable);
                                }
                            } else {
                                in.close();
                            }
                        }
                    }
                } else {
                    List resourcesDir = DevConsoleManager.getHotReplacementContext().getResourcesDir();
                    if (resourcesDir.isEmpty()) {
                        throw new IllegalStateException("Unable to create application.properties - no resource directory found");
                    }
                    appProps = Files.createFile(((Path)resourcesDir.get(0)).resolve("application.properties"), new FileAttribute[0]);
                }
                if (!present) {
                    OutputStream out = Files.newOutputStream(appProps, StandardOpenOption.APPEND);
                    app = null;
                    try {
                        out.write(("\n" + key + "=" + value).getBytes(StandardCharsets.UTF_8));
                    }
                    catch (Throwable throwable) {
                        app = throwable;
                        throw throwable;
                    }
                    finally {
                        if (out != null) {
                            if (app != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)app).addSuppressed(throwable);
                                }
                            } else {
                                out.close();
                            }
                        }
                    }
                }
                List<String> lines = Files.readAllLines(appProps);
                Iterator<String> it = lines.iterator();
                while (it.hasNext()) {
                    String val = it.next();
                    if (!val.startsWith(key + "=")) continue;
                    it.remove();
                }
                lines.add(key + "=" + value);
                try (BufferedWriter writer = Files.newBufferedWriter(appProps, new OpenOption[0]);){
                    for (String i : lines) {
                        writer.write(i);
                        writer.newLine();
                    }
                }
                DevConsoleManager.getHotReplacementContext().doScan(true);
                this.flashMessage(event, "Configuration updated");
            }
        });
    }

    public static class CurrentConfig
    implements Comparable<CurrentConfig> {
        private final String propertyName;
        private final String description;
        private final String defaultValue;
        private final String currentValue;
        private final String appPropertiesValue;

        public CurrentConfig(String propertyName, String description, String defaultValue, String currentValue, String appPropertiesValue) {
            this.propertyName = propertyName;
            this.description = description;
            this.defaultValue = defaultValue;
            this.currentValue = currentValue;
            this.appPropertiesValue = appPropertiesValue;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getDescription() {
            return this.description;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getCurrentValue() {
            return this.currentValue;
        }

        public String getAppPropertiesValue() {
            return this.appPropertiesValue;
        }

        @Override
        public int compareTo(CurrentConfig o) {
            if (this.appPropertiesValue == null && o.appPropertiesValue != null) {
                return 1;
            }
            if (this.appPropertiesValue != null && o.appPropertiesValue == null) {
                return -1;
            }
            return this.propertyName.compareTo(o.propertyName);
        }
    }
}

