/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment.devmode.console;

import io.quarkus.qute.EvalContext;
import io.quarkus.qute.Expression;
import io.quarkus.qute.Results;
import io.quarkus.qute.ValueResolver;
import io.vertx.core.MultiMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class MultiMapValueResolver
implements ValueResolver {
    public boolean appliesTo(EvalContext context) {
        return ValueResolver.matchClass((EvalContext)context, MultiMap.class);
    }

    public CompletionStage<Object> resolve(EvalContext context) {
        MultiMap multiMap = (MultiMap)context.getBase();
        switch (context.getName()) {
            case "names": {
                return CompletableFuture.completedFuture(multiMap.names());
            }
            case "size": {
                return CompletableFuture.completedFuture(multiMap.size());
            }
            case "empty": 
            case "isEmpty": {
                return CompletableFuture.completedFuture(multiMap.isEmpty());
            }
            case "get": {
                if (context.getParams().size() == 1) {
                    return context.evaluate((Expression)context.getParams().get(0)).thenCompose(k -> CompletableFuture.completedFuture(multiMap.get((String)k)));
                }
            }
            case "getAll": {
                if (context.getParams().size() == 1) {
                    return context.evaluate((Expression)context.getParams().get(0)).thenCompose(k -> CompletableFuture.completedFuture(multiMap.getAll((String)k)));
                }
            }
            case "contains": {
                if (context.getParams().size() != 1) break;
                return context.evaluate((Expression)context.getParams().get(0)).thenCompose(k -> CompletableFuture.completedFuture(multiMap.contains((String)k)));
            }
        }
        return multiMap.contains(context.getName()) ? CompletableFuture.completedFuture(multiMap.get(context.getName())) : Results.NOT_FOUND;
    }
}

