/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.attribute;

import io.quarkus.vertx.http.runtime.attribute.ExchangeAttribute;
import io.quarkus.vertx.http.runtime.attribute.ExchangeAttributeBuilder;
import io.quarkus.vertx.http.runtime.attribute.ReadOnlyAttributeException;
import io.vertx.ext.web.RoutingContext;

public class RequestLineAttribute
implements ExchangeAttribute {
    public static final String REQUEST_LINE_SHORT = "%r";
    public static final String REQUEST_LINE = "%{REQUEST_LINE}";
    public static final ExchangeAttribute INSTANCE = new RequestLineAttribute();

    private RequestLineAttribute() {
    }

    @Override
    public String readAttribute(RoutingContext exchange) {
        StringBuilder sb = new StringBuilder().append(exchange.request().method()).append(' ').append(exchange.request().uri());
        sb.append(' ').append(exchange.request().version());
        return sb.toString();
    }

    @Override
    public void writeAttribute(RoutingContext exchange, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException("Request line", newValue);
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Request line";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(RequestLineAttribute.REQUEST_LINE) || token.equals(RequestLineAttribute.REQUEST_LINE_SHORT)) {
                return INSTANCE;
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

