/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.bootstrap.runner.Timing;
import io.quarkus.dev.spi.DevModeType;
import io.quarkus.dev.spi.HotReplacementContext;
import io.quarkus.netty.runtime.virtual.VirtualAddress;
import io.quarkus.netty.runtime.virtual.VirtualChannel;
import io.quarkus.netty.runtime.virtual.VirtualServerChannel;
import io.quarkus.runtime.ErrorPageAction;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.LiveReloadConfig;
import io.quarkus.runtime.QuarkusBindException;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.ThreadPoolConfig;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.ConfigInstantiator;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.quarkus.runtime.configuration.MemorySize;
import io.quarkus.runtime.logging.LogBuildTimeConfig;
import io.quarkus.runtime.shutdown.ShutdownConfig;
import io.quarkus.tls.TlsConfigurationRegistry;
import io.quarkus.vertx.core.runtime.VertxCoreRecorder;
import io.quarkus.vertx.core.runtime.config.VertxConfiguration;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.quarkus.vertx.http.DomainSocketServerStart;
import io.quarkus.vertx.http.HttpServerOptionsCustomizer;
import io.quarkus.vertx.http.HttpServerStart;
import io.quarkus.vertx.http.HttpsServerStart;
import io.quarkus.vertx.http.ManagementInterface;
import io.quarkus.vertx.http.runtime.AccessLogConfig;
import io.quarkus.vertx.http.runtime.BodyConfig;
import io.quarkus.vertx.http.runtime.ExtendedQuarkusVertxHttpMetrics;
import io.quarkus.vertx.http.runtime.FilterConfig;
import io.quarkus.vertx.http.runtime.HandlerType;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.HttpCertificateUpdateEventListener;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.quarkus.vertx.http.runtime.ManagementInterfaceImpl;
import io.quarkus.vertx.http.runtime.PortSystemProperties;
import io.quarkus.vertx.http.runtime.ProxyConfig;
import io.quarkus.vertx.http.runtime.QuarkusErrorHandler;
import io.quarkus.vertx.http.runtime.SameSiteCookieConfig;
import io.quarkus.vertx.http.runtime.SameSiteNoneIncompatibleClientChecker;
import io.quarkus.vertx.http.runtime.devmode.RemoteSyncHandler;
import io.quarkus.vertx.http.runtime.devmode.VertxHttpHotReplacementSetup;
import io.quarkus.vertx.http.runtime.filters.Filter;
import io.quarkus.vertx.http.runtime.filters.Filters;
import io.quarkus.vertx.http.runtime.filters.GracefulShutdownFilter;
import io.quarkus.vertx.http.runtime.filters.QuarkusRequestWrapper;
import io.quarkus.vertx.http.runtime.filters.accesslog.AccessLogHandler;
import io.quarkus.vertx.http.runtime.filters.accesslog.AccessLogReceiver;
import io.quarkus.vertx.http.runtime.filters.accesslog.DefaultAccessLogReceiver;
import io.quarkus.vertx.http.runtime.filters.accesslog.JBossLoggingAccessLogReceiver;
import io.quarkus.vertx.http.runtime.management.ManagementInterfaceBuildTimeConfig;
import io.quarkus.vertx.http.runtime.management.ManagementInterfaceConfiguration;
import io.quarkus.vertx.http.runtime.options.HttpServerCommonHandlers;
import io.quarkus.vertx.http.runtime.options.HttpServerOptionsUtils;
import io.quarkus.vertx.http.runtime.options.TlsCertificateReloader;
import io.smallrye.common.vertx.VertxContext;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.CookieSameSite;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.impl.Http1xServerConnection;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.Utils;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.net.impl.VertxHandler;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.CorsHandler;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.CDI;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.BindException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SubmissionPublisher;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.crac.Context;
import org.crac.Core;
import org.crac.Resource;
import org.jboss.logging.Logger;
import org.wildfly.common.cpu.ProcessorInfo;

@Recorder
public class VertxHttpRecorder {
    public static final String REQUEST_START_TIME = "io.quarkus.request-start-time";
    public static final String MAX_REQUEST_SIZE_KEY = "io.quarkus.max-request-size";
    private static final String DISABLE_WEBSOCKETS_PROP_NAME = "vertx.disableWebsockets";
    private static final Logger LOGGER = Logger.getLogger((String)VertxHttpRecorder.class.getName());
    private static volatile Handler<RoutingContext> hotReplacementHandler;
    private static volatile HotReplacementContext hotReplacementContext;
    private static volatile RemoteSyncHandler remoteSyncHandler;
    private static volatile Runnable closeTask;
    static volatile Handler<HttpServerRequest> rootHandler;
    private static volatile Handler<RoutingContext> nonApplicationRedirectHandler;
    private static volatile int actualHttpPort;
    private static volatile int actualHttpsPort;
    private static volatile int actualManagementPort;
    public static final String GET = "GET";
    private static final Handler<HttpServerRequest> ACTUAL_ROOT;
    private static HttpServerOptions httpMainSslServerOptions;
    private static HttpServerOptions httpMainServerOptions;
    private static HttpServerOptions httpMainDomainSocketOptions;
    private static HttpServerOptions httpManagementServerOptions;
    private static final List<Long> refresTaskIds;
    final HttpBuildTimeConfig httpBuildTimeConfig;
    final ManagementInterfaceBuildTimeConfig managementBuildTimeConfig;
    final RuntimeValue<HttpConfiguration> httpConfiguration;
    final RuntimeValue<ManagementInterfaceConfiguration> managementConfiguration;
    private static volatile Handler<HttpServerRequest> managementRouter;
    private static volatile Handler<HttpServerRequest> managementRouterDelegate;
    protected static ServerBootstrap virtualBootstrap;
    protected static ChannelFuture virtualBootstrapChannel;
    public static VirtualAddress VIRTUAL_HTTP;
    private static final List<HttpMethod> CAN_HAVE_BODY;

    public VertxHttpRecorder(HttpBuildTimeConfig httpBuildTimeConfig, ManagementInterfaceBuildTimeConfig managementBuildTimeConfig, RuntimeValue<HttpConfiguration> httpConfiguration, RuntimeValue<ManagementInterfaceConfiguration> managementConfiguration) {
        this.httpBuildTimeConfig = httpBuildTimeConfig;
        this.httpConfiguration = httpConfiguration;
        this.managementBuildTimeConfig = managementBuildTimeConfig;
        this.managementConfiguration = managementConfiguration;
    }

    public static void setHotReplacement(Handler<RoutingContext> handler, HotReplacementContext hrc) {
        hotReplacementHandler = handler;
        hotReplacementContext = hrc;
    }

    public static void shutDownDevMode() {
        if (closeTask != null) {
            closeTask.run();
            closeTask = null;
        }
        rootHandler = null;
        hotReplacementHandler = null;
        hotReplacementContext = null;
    }

    public static void startServerAfterFailedStart() {
        Vertx vertx;
        Supplier supplier;
        if (closeTask != null) {
            Handler<RoutingContext> prevHotReplacementHandler = hotReplacementHandler;
            VertxHttpRecorder.shutDownDevMode();
            hotReplacementHandler = prevHotReplacementHandler;
        }
        if ((supplier = VertxCoreRecorder.getVertx()) == null) {
            VertxConfiguration vertxConfiguration = (VertxConfiguration)ConfigUtils.emptyConfigBuilder().addDiscoveredSources().withMapping(VertxConfiguration.class).build().getConfigMapping(VertxConfiguration.class);
            ThreadPoolConfig threadPoolConfig = new ThreadPoolConfig();
            ConfigInstantiator.handleObject((Object)threadPoolConfig);
            vertx = (Vertx)VertxCoreRecorder.recoverFailedStart((VertxConfiguration)vertxConfiguration, (ThreadPoolConfig)threadPoolConfig).get();
        } else {
            vertx = (Vertx)supplier.get();
        }
        try {
            HttpBuildTimeConfig buildConfig = new HttpBuildTimeConfig();
            ConfigInstantiator.handleObject((Object)buildConfig);
            ManagementInterfaceBuildTimeConfig managementBuildTimeConfig = new ManagementInterfaceBuildTimeConfig();
            ConfigInstantiator.handleObject((Object)managementBuildTimeConfig);
            HttpConfiguration config = new HttpConfiguration();
            ConfigInstantiator.handleObject((Object)config);
            ManagementInterfaceConfiguration managementConfig = new ManagementInterfaceConfiguration();
            ConfigInstantiator.handleObject((Object)managementConfig);
            if (config.host == null) {
                config.host = "localhost";
            }
            Router router = Router.router((Vertx)vertx);
            if (hotReplacementHandler != null) {
                router.route().order(Integer.MIN_VALUE).blockingHandler(hotReplacementHandler);
            }
            Object root = router;
            LiveReloadConfig liveReloadConfig = new LiveReloadConfig();
            ConfigInstantiator.handleObject((Object)liveReloadConfig);
            if (liveReloadConfig.password.isPresent() && hotReplacementContext.getDevModeType() == DevModeType.REMOTE_SERVER_SIDE) {
                remoteSyncHandler = new RemoteSyncHandler((String)liveReloadConfig.password.get(), (Handler<HttpServerRequest>)root, hotReplacementContext);
                root = remoteSyncHandler;
            }
            rootHandler = root;
            HttpConfiguration.InsecureRequests insecureRequestStrategy = HttpServerOptionsUtils.getInsecureRequestStrategy(buildConfig, config.insecureRequests);
            VertxHttpRecorder.doServerStart(vertx, buildConfig, managementBuildTimeConfig, null, config, managementConfig, LaunchMode.DEVELOPMENT, new Supplier<Integer>(){

                @Override
                public Integer get() {
                    return ProcessorInfo.availableProcessors();
                }
            }, null, insecureRequestStrategy, false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public RuntimeValue<Router> initializeRouter(Supplier<Vertx> vertxRuntimeValue) {
        Vertx vertx = vertxRuntimeValue.get();
        Router router = Router.router((Vertx)vertx);
        return new RuntimeValue((Object)router);
    }

    public RuntimeValue<io.vertx.mutiny.ext.web.Router> createMutinyRouter(RuntimeValue<Router> router) {
        return new RuntimeValue((Object)new io.vertx.mutiny.ext.web.Router((Router)router.getValue()));
    }

    public RuntimeValue<SubmissionPublisher<String>> createAccessLogPublisher() {
        return new RuntimeValue(new SubmissionPublisher());
    }

    public void startServer(Supplier<Vertx> vertx, ShutdownContext shutdown, LaunchMode launchMode, boolean startVirtual, boolean startSocket, Supplier<Integer> ioThreads, List<String> websocketSubProtocols, boolean auxiliaryApplication, boolean disableWebSockets) throws IOException {
        ManagementInterfaceConfiguration managementConfig;
        if (disableWebSockets && !System.getProperties().containsKey(DISABLE_WEBSOCKETS_PROP_NAME)) {
            System.setProperty(DISABLE_WEBSOCKETS_PROP_NAME, "true");
        }
        if (startVirtual) {
            VertxHttpRecorder.initializeVirtual(vertx.get());
            shutdown.addShutdownTask(() -> {
                try {
                    virtualBootstrapChannel.channel().close().sync();
                }
                catch (InterruptedException e) {
                    LOGGER.warn((Object)"Unable to close virtualBootstrapChannel");
                }
                finally {
                    virtualBootstrapChannel = null;
                    virtualBootstrap = null;
                }
            });
        }
        HttpConfiguration httpConfiguration = (HttpConfiguration)this.httpConfiguration.getValue();
        ManagementInterfaceConfiguration managementInterfaceConfiguration = managementConfig = this.managementConfiguration == null ? null : (ManagementInterfaceConfiguration)this.managementConfiguration.getValue();
        if (startSocket && (httpConfiguration.hostEnabled || httpConfiguration.domainSocketEnabled || managementConfig != null && managementConfig.hostEnabled || managementConfig != null && managementConfig.domainSocketEnabled) && closeTask == null) {
            HttpConfiguration.InsecureRequests insecureRequestStrategy = HttpServerOptionsUtils.getInsecureRequestStrategy(this.httpBuildTimeConfig, httpConfiguration.insecureRequests);
            VertxHttpRecorder.doServerStart(vertx.get(), this.httpBuildTimeConfig, this.managementBuildTimeConfig, managementRouter, httpConfiguration, managementConfig, launchMode, ioThreads, websocketSubProtocols, insecureRequestStrategy, auxiliaryApplication);
            if (launchMode != LaunchMode.DEVELOPMENT) {
                shutdown.addShutdownTask(closeTask);
            } else {
                shutdown.addShutdownTask(new Runnable(){

                    @Override
                    public void run() {
                        VertxHttpHotReplacementSetup.handleDevModeRestart();
                    }
                });
            }
        }
    }

    public void mountFrameworkRouter(RuntimeValue<Router> mainRouter, RuntimeValue<Router> frameworkRouter, String frameworkPath) {
        ((Router)mainRouter.getValue()).mountSubRouter(frameworkPath, (Router)frameworkRouter.getValue());
    }

    public void finalizeRouter(BeanContainer container, Consumer<Route> defaultRouteHandler, List<Filter> filterList, List<Filter> managementInterfaceFilterList, Supplier<Vertx> vertx, LiveReloadConfig liveReloadConfig, Optional<RuntimeValue<Router>> mainRouterRuntimeValue, RuntimeValue<Router> httpRouterRuntimeValue, RuntimeValue<io.vertx.mutiny.ext.web.Router> mutinyRouter, RuntimeValue<Router> frameworkRouter, RuntimeValue<Router> managementRouter, String rootPath, String nonRootPath, LaunchMode launchMode, BooleanSupplier[] requireBodyHandlerConditions, final Handler<RoutingContext> bodyHandler, GracefulShutdownFilter gracefulShutdownFilter, ShutdownConfig shutdownConfig, Executor executor, LogBuildTimeConfig logBuildTimeConfig, String srcMainJava, List<String> knowClasses, List<ErrorPageAction> actions, Optional<RuntimeValue<SubmissionPublisher<String>>> publisher) {
        Object root;
        HttpConfiguration httpConfiguration = (HttpConfiguration)this.httpConfiguration.getValue();
        Router httpRouteRouter = (Router)httpRouterRuntimeValue.getValue();
        Event event = Arc.container().beanManager().getEvent();
        Filters filters = new Filters();
        event.select(Filters.class, new Annotation[0]).fire((Object)filters);
        filterList.addAll(filters.getFilters());
        event.select(Router.class, new Annotation[]{Default.Literal.INSTANCE}).fire((Object)httpRouteRouter);
        event.select(io.vertx.mutiny.ext.web.Router.class, new Annotation[0]).fire((Object)((io.vertx.mutiny.ext.web.Router)mutinyRouter.getValue()));
        for (Filter filter : filterList) {
            if (filter.getHandler() == null) continue;
            if (filter.isFailureHandler()) {
                httpRouteRouter.route().order(-1 * filter.getPriority()).failureHandler(filter.getHandler());
                continue;
            }
            httpRouteRouter.route().order(-1 * filter.getPriority()).handler(filter.getHandler());
        }
        if (defaultRouteHandler != null) {
            defaultRouteHandler.accept(httpRouteRouter.route().order(10000));
        }
        this.applyCompression(this.httpBuildTimeConfig.enableCompression, httpRouteRouter);
        httpRouteRouter.route().last().failureHandler((Handler)new QuarkusErrorHandler(launchMode.isDevOrTest(), this.decorateStacktrace(launchMode, logBuildTimeConfig), httpConfiguration.unhandledErrorContentTypeDefault, srcMainJava, knowClasses, actions));
        for (BooleanSupplier requireBodyHandlerCondition : requireBodyHandlerConditions) {
            if (!requireBodyHandlerCondition.getAsBoolean()) continue;
            httpRouteRouter.route().order(-2147483647).handler((Handler)new Handler<RoutingContext>(){

                public void handle(RoutingContext routingContext) {
                    routingContext.request().resume();
                    bodyHandler.handle((Object)routingContext);
                }
            });
            break;
        }
        HttpServerCommonHandlers.enforceMaxBodySize(httpConfiguration.limits, httpRouteRouter);
        Map<String, FilterConfig> filtersInConfig = httpConfiguration.filter;
        HttpServerCommonHandlers.applyFilters(filtersInConfig, httpRouteRouter);
        HttpServerCommonHandlers.applyHeaders(httpConfiguration.header, httpRouteRouter);
        if (rootPath.equals("/")) {
            this.addHotReplacementHandlerIfNeeded(httpRouteRouter);
            root = httpRouteRouter;
        } else {
            Router mainRouter = mainRouterRuntimeValue.isPresent() ? (Router)mainRouterRuntimeValue.get().getValue() : Router.router((Vertx)vertx.get());
            mainRouter.mountSubRouter(rootPath, httpRouteRouter);
            this.addHotReplacementHandlerIfNeeded(mainRouter);
            root = mainRouter;
        }
        this.warnIfProxyAddressForwardingAllowedWithMultipleHeaders(httpConfiguration.proxy);
        root = HttpServerCommonHandlers.applyProxy(httpConfiguration.proxy, root, vertx);
        boolean quarkusWrapperNeeded = false;
        if (shutdownConfig.isShutdownTimeoutSet()) {
            gracefulShutdownFilter.next((Handler<HttpServerRequest>)root);
            root = gracefulShutdownFilter;
            quarkusWrapperNeeded = true;
        }
        AccessLogConfig accessLog = httpConfiguration.accessLog;
        if (accessLog.enabled) {
            AccessLogReceiver receiver;
            if (accessLog.logToFile) {
                File outputDir = accessLog.logDirectory.isPresent() ? new File(accessLog.logDirectory.get()) : new File("");
                receiver = new DefaultAccessLogReceiver(executor, outputDir, accessLog.baseFileName, accessLog.logSuffix, accessLog.rotate);
            } else {
                receiver = new JBossLoggingAccessLogReceiver(accessLog.category);
            }
            this.setupAccessLogHandler(mainRouterRuntimeValue, httpRouterRuntimeValue, frameworkRouter, receiver, rootPath, nonRootPath, accessLog.pattern, accessLog.consolidateReroutedRequests, accessLog.excludePattern);
            quarkusWrapperNeeded = true;
        }
        if (publisher.isPresent()) {
            final SubmissionPublisher logPublisher = (SubmissionPublisher)publisher.get().getValue();
            AccessLogReceiver receiver = new AccessLogReceiver(){

                @Override
                public void logMessage(String message) {
                    logPublisher.submit(message);
                }
            };
            this.setupAccessLogHandler(mainRouterRuntimeValue, httpRouterRuntimeValue, frameworkRouter, receiver, rootPath, nonRootPath, accessLog.pattern, accessLog.consolidateReroutedRequests, accessLog.excludePattern.or(() -> Optional.of("^" + nonRootPath + ".*")));
            quarkusWrapperNeeded = true;
        }
        BiConsumer<Cookie, HttpServerRequest> cookieFunction = null;
        if (!httpConfiguration.sameSiteCookie.isEmpty()) {
            cookieFunction = this.processSameSiteConfig(httpConfiguration.sameSiteCookie);
            quarkusWrapperNeeded = true;
        }
        BiConsumer<Cookie, HttpServerRequest> cookieConsumer = cookieFunction;
        if (quarkusWrapperNeeded) {
            Object old = root;
            root = new Handler<HttpServerRequest>(){
                final /* synthetic */ Handler val$old;
                final /* synthetic */ BiConsumer val$cookieConsumer;
                {
                    this.val$old = handler;
                    this.val$cookieConsumer = biConsumer;
                }

                public void handle(HttpServerRequest event) {
                    this.val$old.handle((Object)new QuarkusRequestWrapper(event, this.val$cookieConsumer));
                }
            };
        }
        Object delegate = root;
        root = HttpServerCommonHandlers.enforceDuplicatedContext((Handler<HttpServerRequest>)delegate);
        if (httpConfiguration.recordRequestStartTime) {
            httpRouteRouter.route().order(Integer.MIN_VALUE).handler((Handler)new Handler<RoutingContext>(){

                public void handle(RoutingContext event) {
                    event.put(VertxHttpRecorder.REQUEST_START_TIME, (Object)System.nanoTime());
                    event.next();
                }
            });
        }
        if (launchMode == LaunchMode.DEVELOPMENT && liveReloadConfig.password.isPresent() && hotReplacementContext.getDevModeType() == DevModeType.REMOTE_SERVER_SIDE) {
            remoteSyncHandler = new RemoteSyncHandler((String)liveReloadConfig.password.get(), (Handler<HttpServerRequest>)root, hotReplacementContext);
            root = remoteSyncHandler;
        }
        rootHandler = root;
        if (managementRouter != null && managementRouter.getValue() != null) {
            Router mr = (Router)managementRouter.getValue();
            boolean hasManagementRoutes = !mr.getRoutes().isEmpty();
            this.addHotReplacementHandlerIfNeeded(mr);
            mr.route().last().failureHandler((Handler)new QuarkusErrorHandler(launchMode.isDevOrTest(), this.decorateStacktrace(launchMode, logBuildTimeConfig), httpConfiguration.unhandledErrorContentTypeDefault, srcMainJava, knowClasses, actions));
            mr.route().order(Integer.MIN_VALUE).handler(this.createBodyHandlerForManagementInterface());
            mr.route().order(Integer.MIN_VALUE).handler((Handler)CorsHandler.create().addOrigin("*"));
            HttpServerCommonHandlers.applyFilters(((ManagementInterfaceConfiguration)this.managementConfiguration.getValue()).filter, mr);
            for (Filter filter : managementInterfaceFilterList) {
                mr.route().order(filter.getPriority()).handler(filter.getHandler());
            }
            HttpServerCommonHandlers.applyHeaders(((ManagementInterfaceConfiguration)this.managementConfiguration.getValue()).header, mr);
            this.applyCompression(this.managementBuildTimeConfig.enableCompression, mr);
            Handler<HttpServerRequest> handler = HttpServerCommonHandlers.enforceDuplicatedContext((Handler<HttpServerRequest>)mr);
            handler = HttpServerCommonHandlers.applyProxy(((ManagementInterfaceConfiguration)this.managementConfiguration.getValue()).proxy, handler, vertx);
            int routesBeforeMiEvent = mr.getRoutes().size();
            event.select(ManagementInterface.class, new Annotation[0]).fire((Object)new ManagementInterfaceImpl(mr));
            if (hasManagementRoutes || routesBeforeMiEvent < mr.getRoutes().size()) {
                managementRouterDelegate = handler;
                if (VertxHttpRecorder.managementRouter == null) {
                    VertxHttpRecorder.managementRouter = new Handler<HttpServerRequest>(){

                        public void handle(HttpServerRequest event) {
                            managementRouterDelegate.handle((Object)event);
                        }
                    };
                }
            }
        }
    }

    private void setupAccessLogHandler(Optional<RuntimeValue<Router>> mainRouterRuntimeValue, RuntimeValue<Router> httpRouterRuntimeValue, RuntimeValue<Router> frameworkRouter, AccessLogReceiver receiver, String rootPath, String nonRootPath, String pattern, boolean consolidateReroutedRequests, Optional<String> excludePattern) {
        Router httpRouteRouter = (Router)httpRouterRuntimeValue.getValue();
        AccessLogHandler handler = new AccessLogHandler(receiver, pattern, consolidateReroutedRequests, this.getClass().getClassLoader(), excludePattern);
        if (rootPath.equals("/") || nonRootPath.equals("/")) {
            ((Router)mainRouterRuntimeValue.orElse(httpRouterRuntimeValue).getValue()).route().order(Integer.MIN_VALUE).handler((Handler)handler);
        } else if (nonRootPath.startsWith(rootPath)) {
            httpRouteRouter.route().order(Integer.MIN_VALUE).handler((Handler)handler);
        } else if (rootPath.startsWith(nonRootPath)) {
            ((Router)frameworkRouter.getValue()).route().order(Integer.MIN_VALUE).handler((Handler)handler);
        } else {
            httpRouteRouter.route().order(Integer.MIN_VALUE).handler((Handler)handler);
            ((Router)frameworkRouter.getValue()).route().order(Integer.MIN_VALUE).handler((Handler)handler);
        }
    }

    private boolean decorateStacktrace(LaunchMode launchMode, LogBuildTimeConfig logBuildTimeConfig) {
        return logBuildTimeConfig.decorateStacktraces() && launchMode.equals((Object)LaunchMode.DEVELOPMENT);
    }

    private void addHotReplacementHandlerIfNeeded(Router router) {
        if (hotReplacementHandler != null) {
            ClassLoader currentCl = Thread.currentThread().getContextClassLoader();
            router.route().order(Integer.MIN_VALUE).handler((Handler)new HotReplacementRoutingContextHandler(currentCl));
        }
    }

    private void applyCompression(boolean enableCompression, Router httpRouteRouter) {
        if (enableCompression) {
            httpRouteRouter.route().order(0).handler((Handler)new Handler<RoutingContext>(){

                public void handle(RoutingContext ctx) {
                    ctx.response().putHeader(HttpHeaders.CONTENT_ENCODING, HttpHeaders.IDENTITY);
                    ctx.next();
                }
            });
        }
    }

    private void warnIfProxyAddressForwardingAllowedWithMultipleHeaders(ProxyConfig proxyConfig) {
        boolean proxyAddressForwardingActivated = proxyConfig.proxyAddressForwarding;
        boolean forwardedActivated = proxyConfig.allowForwarded;
        boolean xForwardedActivated = proxyConfig.allowXForwarded.orElse(!forwardedActivated);
        if (proxyAddressForwardingActivated && forwardedActivated && xForwardedActivated) {
            LOGGER.warn((Object)"The X-Forwarded-* and Forwarded headers will be considered when determining the proxy address. This configuration can cause a security issue as clients can forge requests and send a forwarded header that is not overwritten by the proxy. Please consider use one of these headers just to forward the proxy address in requests.");
        }
    }

    private static CompletableFuture<HttpServer> initializeManagementInterfaceWithDomainSocket(Vertx vertx, ManagementInterfaceBuildTimeConfig managementBuildTimeConfig, Handler<HttpServerRequest> managementRouter, ManagementInterfaceConfiguration managementConfig, List<String> websocketSubProtocols) {
        CompletableFuture<HttpServer> managementInterfaceDomainSocketFuture = new CompletableFuture<HttpServer>();
        if (!managementBuildTimeConfig.enabled || managementRouter == null || managementConfig == null) {
            managementInterfaceDomainSocketFuture.complete(null);
            return managementInterfaceDomainSocketFuture;
        }
        HttpServerOptions domainSocketOptionsForManagement = VertxHttpRecorder.createDomainSocketOptionsForManagementInterface(managementBuildTimeConfig, managementConfig, websocketSubProtocols);
        if (domainSocketOptionsForManagement != null) {
            vertx.createHttpServer(domainSocketOptionsForManagement).requestHandler(managementRouter).listen(ar -> {
                if (ar.failed()) {
                    managementInterfaceDomainSocketFuture.completeExceptionally(new IllegalStateException("Unable to start the management interface on the " + domainSocketOptionsForManagement.getHost() + " domain socket", ar.cause()));
                } else {
                    managementInterfaceDomainSocketFuture.complete((HttpServer)ar.result());
                }
            });
        } else {
            managementInterfaceDomainSocketFuture.complete(null);
        }
        return managementInterfaceDomainSocketFuture;
    }

    private static CompletableFuture<HttpServer> initializeManagementInterface(Vertx vertx, ManagementInterfaceBuildTimeConfig managementBuildTimeConfig, Handler<HttpServerRequest> managementRouter, ManagementInterfaceConfiguration managementConfig, LaunchMode launchMode, List<String> websocketSubProtocols, TlsConfigurationRegistry registry) throws IOException {
        httpManagementServerOptions = null;
        CompletableFuture<HttpServer> managementInterfaceFuture = new CompletableFuture<HttpServer>();
        if (!managementBuildTimeConfig.enabled || managementRouter == null || managementConfig == null) {
            managementInterfaceFuture.complete(null);
            return managementInterfaceFuture;
        }
        HttpServerOptions httpServerOptionsForManagement = VertxHttpRecorder.createHttpServerOptionsForManagementInterface(managementBuildTimeConfig, managementConfig, launchMode, websocketSubProtocols);
        httpManagementServerOptions = HttpServerOptionsUtils.createSslOptionsForManagementInterface(managementBuildTimeConfig, managementConfig, launchMode, websocketSubProtocols, registry);
        if (httpManagementServerOptions != null && httpManagementServerOptions.getKeyCertOptions() == null) {
            httpManagementServerOptions = httpServerOptionsForManagement;
        }
        if (httpManagementServerOptions != null) {
            vertx.createHttpServer(httpManagementServerOptions).requestHandler(managementRouter).listen(ar -> {
                if (ar.failed()) {
                    managementInterfaceFuture.completeExceptionally(new IllegalStateException("Unable to start the management interface on " + httpManagementServerOptions.getHost() + ":" + httpManagementServerOptions.getPort(), ar.cause()));
                } else {
                    if (httpManagementServerOptions.isSsl() && managementConfig.ssl.certificate.reloadPeriod.isPresent()) {
                        try {
                            long l = TlsCertificateReloader.initCertReloadingAction(vertx, (HttpServer)ar.result(), httpManagementServerOptions, managementConfig.ssl, registry, managementConfig.tlsConfigurationName);
                            if (l != -1L) {
                                refresTaskIds.add(l);
                            }
                        }
                        catch (IllegalArgumentException e) {
                            managementInterfaceFuture.completeExceptionally(e);
                            return;
                        }
                    }
                    if (httpManagementServerOptions.isSsl()) {
                        ((HttpCertificateUpdateEventListener)CDI.current().select(HttpCertificateUpdateEventListener.class, new Annotation[0]).get()).register((HttpServer)ar.result(), managementConfig.tlsConfigurationName.orElse("<default>"), "management interface");
                    }
                    if ((actualManagementPort = ((HttpServer)ar.result()).actualPort()) != httpManagementServerOptions.getPort()) {
                        final PortSystemProperties managementPortSystemProperties = new PortSystemProperties();
                        managementPortSystemProperties.set("management", actualManagementPort, launchMode);
                        ((VertxInternal)vertx).addCloseHook(new Closeable(){

                            public void close(Promise<Void> completion) {
                                managementPortSystemProperties.restore();
                                completion.complete();
                            }
                        });
                    }
                    managementInterfaceFuture.complete((HttpServer)ar.result());
                }
            });
        } else {
            managementInterfaceFuture.complete(null);
        }
        return managementInterfaceFuture;
    }

    private static CompletableFuture<String> initializeMainHttpServer(Vertx vertx, HttpBuildTimeConfig httpBuildTimeConfig, final HttpConfiguration httpConfiguration, final LaunchMode launchMode, Supplier<Integer> eventLoops, List<String> websocketSubProtocols, final HttpConfiguration.InsecureRequests insecureRequestStrategy, final TlsConfigurationRegistry registry) throws IOException {
        if (!httpConfiguration.hostEnabled && !httpConfiguration.domainSocketEnabled) {
            return CompletableFuture.completedFuture(null);
        }
        httpMainServerOptions = VertxHttpRecorder.createHttpServerOptions(httpBuildTimeConfig, httpConfiguration, launchMode, websocketSubProtocols);
        httpMainDomainSocketOptions = VertxHttpRecorder.createDomainSocketOptions(httpBuildTimeConfig, httpConfiguration, websocketSubProtocols);
        HttpServerOptions tmpSslConfig = HttpServerOptionsUtils.createSslOptions(httpBuildTimeConfig, httpConfiguration, launchMode, websocketSubProtocols, registry);
        ArcContainer container = Arc.container();
        if (container != null) {
            List instances = container.listAll(HttpServerOptionsCustomizer.class, new Annotation[0]);
            for (InstanceHandle instance : instances) {
                HttpServerOptionsCustomizer customizer = (HttpServerOptionsCustomizer)instance.get();
                if (httpMainServerOptions != null) {
                    customizer.customizeHttpServer(httpMainServerOptions);
                }
                if (tmpSslConfig != null) {
                    customizer.customizeHttpsServer(tmpSslConfig);
                }
                if (httpMainDomainSocketOptions == null) continue;
                customizer.customizeDomainSocketServer(httpMainDomainSocketOptions);
            }
        }
        if (tmpSslConfig != null && tmpSslConfig.getKeyCertOptions() == null) {
            tmpSslConfig = null;
        }
        httpMainSslServerOptions = tmpSslConfig;
        if (insecureRequestStrategy != HttpConfiguration.InsecureRequests.ENABLED && httpMainSslServerOptions == null) {
            throw new IllegalStateException("Cannot set quarkus.http.insecure-requests without enabling SSL.");
        }
        int eventLoopCount = eventLoops.get();
        int ioThreads = httpConfiguration.ioThreads.isPresent() ? Math.min(httpConfiguration.ioThreads.getAsInt(), eventLoopCount) : (launchMode.isDevOrTest() ? Math.min(2, eventLoopCount) : eventLoopCount);
        final CompletableFuture<String> futureResult = new CompletableFuture<String>();
        final AtomicInteger connectionCount = new AtomicInteger();
        final AtomicBoolean startEventsFired = new AtomicBoolean();
        vertx.deployVerticle((Supplier)new Supplier<Verticle>(){

            @Override
            public Verticle get() {
                return new WebDeploymentVerticle(httpMainServerOptions, httpMainSslServerOptions, httpMainDomainSocketOptions, launchMode, insecureRequestStrategy, httpConfiguration, connectionCount, registry, startEventsFired);
            }
        }, new DeploymentOptions().setInstances(ioThreads), (Handler)new Handler<AsyncResult<String>>(){

            public void handle(AsyncResult<String> event) {
                if (event.failed()) {
                    Throwable effectiveCause = event.cause();
                    if (effectiveCause instanceof BindException) {
                        List<Object> portsUsed = Collections.emptyList();
                        if (httpMainSslServerOptions == null && httpMainServerOptions != null) {
                            portsUsed = List.of(Integer.valueOf(httpMainServerOptions.getPort()));
                        } else if (insecureRequestStrategy == HttpConfiguration.InsecureRequests.DISABLED && httpMainSslServerOptions != null) {
                            portsUsed = List.of(Integer.valueOf(httpMainSslServerOptions.getPort()));
                        } else if (httpMainSslServerOptions != null && insecureRequestStrategy == HttpConfiguration.InsecureRequests.ENABLED && httpMainServerOptions != null) {
                            portsUsed = List.of(Integer.valueOf(httpMainServerOptions.getPort()), Integer.valueOf(httpMainSslServerOptions.getPort()));
                        }
                        effectiveCause = new QuarkusBindException((BindException)effectiveCause, portsUsed);
                    }
                    futureResult.completeExceptionally(effectiveCause);
                } else {
                    futureResult.complete((String)event.result());
                }
            }
        });
        return futureResult;
    }

    private static void doServerStart(final Vertx vertx, HttpBuildTimeConfig httpBuildTimeConfig, ManagementInterfaceBuildTimeConfig managementBuildTimeConfig, Handler<HttpServerRequest> managementRouter, HttpConfiguration httpConfiguration, ManagementInterfaceConfiguration managementConfig, LaunchMode launchMode, Supplier<Integer> eventLoops, List<String> websocketSubProtocols, HttpConfiguration.InsecureRequests insecureRequestStrategy, boolean auxiliaryApplication) throws IOException {
        TlsConfigurationRegistry registry = null;
        if (Arc.container() != null) {
            registry = (TlsConfigurationRegistry)Arc.container().select(TlsConfigurationRegistry.class, new Annotation[0]).orNull();
        }
        CompletableFuture<String> mainServerFuture = VertxHttpRecorder.initializeMainHttpServer(vertx, httpBuildTimeConfig, httpConfiguration, launchMode, eventLoops, websocketSubProtocols, insecureRequestStrategy, registry);
        CompletableFuture<HttpServer> managementInterfaceFuture = VertxHttpRecorder.initializeManagementInterface(vertx, managementBuildTimeConfig, managementRouter, managementConfig, launchMode, websocketSubProtocols, registry);
        CompletableFuture<HttpServer> managementInterfaceDomainSocketFuture = VertxHttpRecorder.initializeManagementInterfaceWithDomainSocket(vertx, managementBuildTimeConfig, managementRouter, managementConfig, websocketSubProtocols);
        try {
            final String deploymentIdIfAny = mainServerFuture.get();
            HttpServer tmpManagementServer = null;
            HttpServer tmpManagementServerUsingDomainSocket = null;
            if (managementRouter != null) {
                tmpManagementServer = managementInterfaceFuture.get();
                tmpManagementServerUsingDomainSocket = managementInterfaceDomainSocketFuture.get();
            }
            final HttpServer managementServer = tmpManagementServer;
            final HttpServer managementServerDomainSocket = tmpManagementServerUsingDomainSocket;
            if (deploymentIdIfAny != null) {
                VertxCoreRecorder.setWebDeploymentId((String)deploymentIdIfAny);
            }
            closeTask = new Runnable(){

                @Override
                public synchronized void run() {
                    if (closeTask == this) {
                        boolean isVertxClose = ((VertxInternal)vertx).closeFuture().future().isComplete();
                        int count = 0;
                        if (deploymentIdIfAny != null && vertx.deploymentIDs().contains(deploymentIdIfAny)) {
                            ++count;
                        }
                        if (managementServer != null && !isVertxClose) {
                            ++count;
                        }
                        if (managementServerDomainSocket != null && !isVertxClose) {
                            ++count;
                        }
                        final CountDownLatch latch = new CountDownLatch(count);
                        Handler<AsyncResult<Void>> handler = new Handler<AsyncResult<Void>>(){

                            public void handle(AsyncResult<Void> event) {
                                latch.countDown();
                            }
                        };
                        if (deploymentIdIfAny != null) {
                            try {
                                vertx.undeploy(deploymentIdIfAny, (Handler)handler);
                            }
                            catch (Exception e) {
                                if (e instanceof RejectedExecutionException) {
                                    LOGGER.debug((Object)"Failed to undeploy deployment because a task was rejected (due to shutdown)", (Throwable)e);
                                }
                                LOGGER.warn((Object)"Failed to undeploy deployment", (Throwable)e);
                            }
                        }
                        try {
                            for (Long id : refresTaskIds) {
                                TlsCertificateReloader.unschedule(vertx, id);
                            }
                            if (managementServer != null && !isVertxClose) {
                                managementServer.close((Handler)handler);
                            }
                            if (managementServerDomainSocket != null && !isVertxClose) {
                                managementServerDomainSocket.close((Handler)handler);
                            }
                        }
                        catch (Exception e) {
                            LOGGER.warn((Object)"Unable to shutdown the management interface quietly", (Throwable)e);
                        }
                        try {
                            latch.await();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    closeTask = null;
                    if (remoteSyncHandler != null) {
                        remoteSyncHandler.close();
                        remoteSyncHandler = null;
                    }
                }
            };
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Unable to start HTTP server", e);
        }
        VertxHttpRecorder.setHttpServerTiming(insecureRequestStrategy == HttpConfiguration.InsecureRequests.DISABLED, httpMainServerOptions, httpMainSslServerOptions, httpMainDomainSocketOptions, auxiliaryApplication, httpManagementServerOptions);
    }

    private static void setHttpServerTiming(boolean httpDisabled, HttpServerOptions httpServerOptions, HttpServerOptions sslConfig, HttpServerOptions domainSocketOptions, boolean auxiliaryApplication, HttpServerOptions managementConfig) {
        StringBuilder serverListeningMessage = new StringBuilder("Listening on: ");
        int socketCount = 0;
        if (!httpDisabled && httpServerOptions != null) {
            serverListeningMessage.append(String.format("http://%s:%s", VertxHttpRecorder.getDeveloperFriendlyHostName(httpServerOptions), actualHttpPort));
            ++socketCount;
        }
        if (sslConfig != null) {
            if (socketCount > 0) {
                serverListeningMessage.append(" and ");
            }
            serverListeningMessage.append(String.format("https://%s:%s", VertxHttpRecorder.getDeveloperFriendlyHostName(sslConfig), actualHttpsPort));
            ++socketCount;
        }
        if (domainSocketOptions != null) {
            if (socketCount > 0) {
                serverListeningMessage.append(" and ");
            }
            serverListeningMessage.append(String.format("unix:%s", VertxHttpRecorder.getDeveloperFriendlyHostName(domainSocketOptions)));
        }
        if (managementConfig != null) {
            serverListeningMessage.append(String.format(". Management interface listening on http%s://%s:%s.", managementConfig.isSsl() ? "s" : "", VertxHttpRecorder.getDeveloperFriendlyHostName(managementConfig), actualManagementPort));
        }
        Timing.setHttpServer((String)serverListeningMessage.toString(), (boolean)auxiliaryApplication);
    }

    private static String getDeveloperFriendlyHostName(HttpServerOptions options) {
        return LaunchMode.current().isDevOrTest() && "0.0.0.0".equals(options.getHost()) && VertxHttpRecorder.isWSL() ? "localhost" : options.getHost();
    }

    private static boolean isWSL() {
        Map<String, String> sysEnv = System.getenv();
        return sysEnv.containsKey("IS_WSL") || sysEnv.containsKey("WSL_DISTRO_NAME");
    }

    private static HttpServerOptions createHttpServerOptions(HttpBuildTimeConfig buildTimeConfig, HttpConfiguration httpConfiguration, LaunchMode launchMode, List<String> websocketSubProtocols) {
        if (!httpConfiguration.hostEnabled) {
            return null;
        }
        HttpServerOptions options = new HttpServerOptions();
        int port = httpConfiguration.determinePort(launchMode);
        options.setPort(port == 0 ? -1 : port);
        HttpServerOptionsUtils.applyCommonOptions(options, buildTimeConfig, httpConfiguration, websocketSubProtocols);
        httpConfiguration.websocketServer.maxFrameSize.ifPresent(s -> options.setMaxWebSocketFrameSize(s.intValue()));
        httpConfiguration.websocketServer.maxMessageSize.ifPresent(s -> options.setMaxWebSocketMessageSize(s.intValue()));
        return options;
    }

    private static HttpServerOptions createHttpServerOptionsForManagementInterface(ManagementInterfaceBuildTimeConfig buildTimeConfig, ManagementInterfaceConfiguration httpConfiguration, LaunchMode launchMode, List<String> websocketSubProtocols) {
        if (!httpConfiguration.hostEnabled) {
            return null;
        }
        HttpServerOptions options = new HttpServerOptions();
        int port = httpConfiguration.determinePort(launchMode);
        options.setPort(port == 0 ? -3 : port);
        HttpServerOptionsUtils.applyCommonOptionsForManagementInterface(options, buildTimeConfig, httpConfiguration, websocketSubProtocols);
        return options;
    }

    private static HttpServerOptions createDomainSocketOptions(HttpBuildTimeConfig buildTimeConfig, HttpConfiguration httpConfiguration, List<String> websocketSubProtocols) {
        if (!httpConfiguration.domainSocketEnabled) {
            return null;
        }
        HttpServerOptions options = new HttpServerOptions();
        HttpServerOptionsUtils.applyCommonOptions(options, buildTimeConfig, httpConfiguration, websocketSubProtocols);
        options.setHost(httpConfiguration.domainSocket);
        File file = new File(httpConfiguration.domainSocket);
        if (!file.getParentFile().canWrite()) {
            LOGGER.warnf("Unable to write in the domain socket directory (`%s`). Binding to the socket is likely going to fail.", (Object)httpConfiguration.domainSocket);
        }
        return options;
    }

    private static HttpServerOptions createDomainSocketOptionsForManagementInterface(ManagementInterfaceBuildTimeConfig buildTimeConfig, ManagementInterfaceConfiguration httpConfiguration, List<String> websocketSubProtocols) {
        if (!httpConfiguration.domainSocketEnabled) {
            return null;
        }
        HttpServerOptions options = new HttpServerOptions();
        HttpServerOptionsUtils.applyCommonOptionsForManagementInterface(options, buildTimeConfig, httpConfiguration, websocketSubProtocols);
        options.setHost(httpConfiguration.domainSocket);
        File file = new File(httpConfiguration.domainSocket);
        if (!file.getParentFile().canWrite()) {
            LOGGER.warnf("Unable to write in the domain socket directory (`%s`). Binding to the socket is likely going to fail.", (Object)httpConfiguration.domainSocket);
        }
        return options;
    }

    public void addRoute(RuntimeValue<Router> router, Function<Router, Route> route, Handler<RoutingContext> handler, HandlerType type) {
        Route vr = route.apply((Router)router.getValue());
        if (type == HandlerType.BLOCKING) {
            vr.blockingHandler(handler, false);
        } else if (type == HandlerType.FAILURE) {
            vr.failureHandler(handler);
        } else {
            vr.handler(handler);
        }
    }

    public void setNonApplicationRedirectHandler(final String nonApplicationPath, final String rootPath) {
        nonApplicationRedirectHandler = new Handler<RoutingContext>(){

            public void handle(RoutingContext context) {
                String absoluteURI = context.request().path();
                String target = absoluteURI.substring(rootPath.length());
                String redirectTo = nonApplicationPath + target;
                String query = context.request().query();
                if (query != null && !query.isEmpty()) {
                    redirectTo = redirectTo + "?" + query;
                }
                context.response().setStatusCode(HttpResponseStatus.MOVED_PERMANENTLY.code()).putHeader((CharSequence)HttpHeaderNames.LOCATION, (CharSequence)redirectTo).end();
            }
        };
    }

    public Handler<RoutingContext> getNonApplicationRedirectHandler() {
        return nonApplicationRedirectHandler;
    }

    public GracefulShutdownFilter createGracefulShutdownHandler() {
        return new GracefulShutdownFilter();
    }

    private static void initializeVirtual(Vertx vertxRuntime) {
        if (virtualBootstrap != null) {
            return;
        }
        final VertxInternal vertx = (VertxInternal)vertxRuntime;
        virtualBootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)virtualBootstrap.group(vertx.getEventLoopGroup()).channel(VirtualServerChannel.class)).handler((ChannelHandler)new ChannelInitializer<VirtualServerChannel>(){

            public void initChannel(VirtualServerChannel ch) throws Exception {
            }
        })).childHandler((ChannelHandler)new ChannelInitializer<VirtualChannel>(){

            public void initChannel(VirtualChannel ch) throws Exception {
                ContextInternal rootContext = vertx.createEventLoopContext();
                VertxHandler handler = VertxHandler.create(chctx -> {
                    Http1xServerConnection conn = new Http1xServerConnection(() -> {
                        ContextInternal duplicated = (ContextInternal)VertxContext.getOrCreateDuplicatedContext((io.vertx.core.Context)rootContext);
                        VertxContextSafetyToggle.setContextSafe((io.vertx.core.Context)duplicated, (boolean)true);
                        return duplicated;
                    }, null, new HttpServerOptions(), chctx, rootContext, "localhost", null);
                    conn.handler(ACTUAL_ROOT);
                    return conn;
                });
                ch.pipeline().addLast("handler", (ChannelHandler)handler);
            }
        });
        try {
            virtualBootstrapChannel = virtualBootstrap.bind((java.net.SocketAddress)VIRTUAL_HTTP).sync();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("failed to bind virtual http");
        }
    }

    public static Handler<HttpServerRequest> getRootHandler() {
        return ACTUAL_ROOT;
    }

    public static Object getCurrentApplicationState() {
        return rootHandler;
    }

    private static Handler<RoutingContext> configureAndGetBody(Optional<MemorySize> maxBodySize, BodyConfig bodyConfig) {
        final BodyHandler bodyHandler = BodyHandler.create();
        if (maxBodySize.isPresent()) {
            bodyHandler.setBodyLimit(maxBodySize.get().asLongValue());
        }
        bodyHandler.setHandleFileUploads(bodyConfig.handleFileUploads);
        bodyHandler.setUploadsDirectory(bodyConfig.uploadsDirectory);
        bodyHandler.setDeleteUploadedFilesOnEnd(bodyConfig.deleteUploadedFilesOnEnd);
        bodyHandler.setMergeFormAttributes(bodyConfig.mergeFormAttributes);
        bodyHandler.setPreallocateBodyBuffer(bodyConfig.preallocateBodyBuffer);
        return new Handler<RoutingContext>(){

            public void handle(final RoutingContext event) {
                if (!io.vertx.core.Context.isOnEventLoopThread()) {
                    ((ConnectionBase)event.request().connection()).channel().eventLoop().execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (!event.request().isEnded()) {
                                    event.request().resume();
                                    if (CAN_HAVE_BODY.contains(event.request().method())) {
                                        bodyHandler.handle((Object)event);
                                    } else {
                                        event.next();
                                    }
                                } else {
                                    event.next();
                                }
                            }
                            catch (Throwable t) {
                                event.fail(t);
                            }
                        }
                    });
                } else {
                    if (!event.request().isEnded()) {
                        event.request().resume();
                    }
                    if (CAN_HAVE_BODY.contains(event.request().method())) {
                        bodyHandler.handle((Object)event);
                    } else {
                        event.next();
                    }
                }
            }
        };
    }

    public Handler<RoutingContext> createBodyHandler() {
        Optional<MemorySize> maxBodySize = ((HttpConfiguration)this.httpConfiguration.getValue()).limits.maxBodySize;
        return VertxHttpRecorder.configureAndGetBody(maxBodySize, ((HttpConfiguration)this.httpConfiguration.getValue()).body);
    }

    public Handler<RoutingContext> createBodyHandlerForManagementInterface() {
        Optional<MemorySize> maxBodySize = ((ManagementInterfaceConfiguration)this.managementConfiguration.getValue()).limits.maxBodySize;
        return VertxHttpRecorder.configureAndGetBody(maxBodySize, ((ManagementInterfaceConfiguration)this.managementConfiguration.getValue()).body);
    }

    private BiConsumer<Cookie, HttpServerRequest> processSameSiteConfig(Map<String, SameSiteCookieConfig> httpConfiguration) {
        final ArrayList<18> functions = new ArrayList<18>();
        BiFunction<Cookie, HttpServerRequest, Boolean> last = null;
        for (final Map.Entry<String, SameSiteCookieConfig> entry : new TreeMap<String, SameSiteCookieConfig>(httpConfiguration).entrySet()) {
            final Pattern p = Pattern.compile(entry.getKey(), entry.getValue().caseSensitive ? 0 : 2);
            BiFunction<Cookie, HttpServerRequest, Boolean> biFunction = new BiFunction<Cookie, HttpServerRequest, Boolean>(){

                @Override
                public Boolean apply(Cookie cookie, HttpServerRequest request) {
                    if (p.matcher(cookie.getName()).matches()) {
                        if (((SameSiteCookieConfig)entry.getValue()).value == CookieSameSite.NONE) {
                            String userAgent;
                            if (((SameSiteCookieConfig)entry.getValue()).enableClientChecker && (userAgent = request.getHeader(HttpHeaders.USER_AGENT)) != null && SameSiteNoneIncompatibleClientChecker.isSameSiteNoneIncompatible(userAgent)) {
                                return false;
                            }
                            if (((SameSiteCookieConfig)entry.getValue()).addSecureForNone) {
                                cookie.setSecure(true);
                            }
                        }
                        cookie.setSameSite(((SameSiteCookieConfig)entry.getValue()).value);
                        return true;
                    }
                    return false;
                }
            };
            if (entry.getKey().equals(".*")) {
                last = biFunction;
                continue;
            }
            functions.add(biFunction);
        }
        if (last != null) {
            functions.add(last);
        }
        return new BiConsumer<Cookie, HttpServerRequest>(){

            @Override
            public void accept(Cookie cookie, HttpServerRequest request) {
                for (BiFunction i : functions) {
                    if (!((Boolean)i.apply(cookie, request)).booleanValue()) continue;
                    return;
                }
            }
        };
    }

    static {
        actualHttpPort = -1;
        actualHttpsPort = -1;
        actualManagementPort = -1;
        ACTUAL_ROOT = new Handler<HttpServerRequest>(){
            private static final String DISABLE_URI_VALIDATION_PROP_NAME = "vertx.disableURIValidation";
            private final boolean DISABLE_URI_VALIDATION = Boolean.getBoolean("vertx.disableURIValidation");

            public void handle(HttpServerRequest httpServerRequest) {
                if (!this.uriValid(httpServerRequest)) {
                    httpServerRequest.response().setStatusCode(400).end();
                    return;
                }
                httpServerRequest.pause();
                Handler<HttpServerRequest> rh = rootHandler;
                if (rh != null) {
                    rh.handle((Object)httpServerRequest);
                } else {
                    httpServerRequest.resume();
                    httpServerRequest.response().setStatusCode(503).end();
                }
            }

            private boolean uriValid(HttpServerRequest httpServerRequest) {
                if (this.DISABLE_URI_VALIDATION) {
                    return true;
                }
                try {
                    new URI(httpServerRequest.uri());
                    return true;
                }
                catch (URISyntaxException e) {
                    return false;
                }
            }
        };
        refresTaskIds = new CopyOnWriteArrayList<Long>();
        VIRTUAL_HTTP = new VirtualAddress("netty-virtual-http");
        CAN_HAVE_BODY = Arrays.asList(HttpMethod.POST, HttpMethod.PUT, HttpMethod.PATCH, HttpMethod.DELETE);
    }

    private static class HotReplacementRoutingContextHandler
    implements Handler<RoutingContext> {
        private final ClassLoader currentCl;

        public HotReplacementRoutingContextHandler(ClassLoader currentCl) {
            this.currentCl = currentCl;
        }

        public void handle(RoutingContext event) {
            Thread.currentThread().setContextClassLoader(this.currentCl);
            hotReplacementHandler.handle((Object)event);
        }
    }

    public static class AlwaysCreateBodyHandlerSupplier
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return true;
        }
    }

    private static class WebDeploymentVerticle
    extends AbstractVerticle
    implements Resource {
        private final TlsConfigurationRegistry registry;
        private HttpServer httpServer;
        private HttpServer httpsServer;
        private HttpServer domainSocketServer;
        private final HttpServerOptions httpOptions;
        private final HttpServerOptions httpsOptions;
        private final HttpServerOptions domainSocketOptions;
        private final LaunchMode launchMode;
        private volatile boolean clearHttpProperty = false;
        private volatile boolean clearHttpsProperty = false;
        private volatile PortSystemProperties portSystemProperties;
        private final HttpConfiguration.InsecureRequests insecureRequests;
        private final HttpConfiguration quarkusConfig;
        private final AtomicInteger connectionCount;
        private final List<Long> reloadingTasks = new CopyOnWriteArrayList<Long>();
        private final AtomicBoolean startEventsFired;

        public WebDeploymentVerticle(HttpServerOptions httpOptions, HttpServerOptions httpsOptions, HttpServerOptions domainSocketOptions, LaunchMode launchMode, HttpConfiguration.InsecureRequests insecureRequests, HttpConfiguration quarkusConfig, AtomicInteger connectionCount, TlsConfigurationRegistry registry, AtomicBoolean startEventsFired) {
            this.httpOptions = httpOptions;
            this.httpsOptions = httpsOptions;
            this.launchMode = launchMode;
            this.domainSocketOptions = domainSocketOptions;
            this.insecureRequests = insecureRequests;
            this.quarkusConfig = quarkusConfig;
            this.connectionCount = connectionCount;
            this.registry = registry;
            this.startEventsFired = startEventsFired;
            Core.getGlobalContext().register((Resource)this);
        }

        public void start(Promise<Void> startFuture) {
            ArcContainer container;
            boolean notifyStartObservers;
            boolean httpServerEnabled;
            assert (io.vertx.core.Context.isOnEventLoopThread());
            AtomicInteger remainingCount = new AtomicInteger(0);
            boolean bl = httpServerEnabled = this.httpOptions != null && this.insecureRequests != HttpConfiguration.InsecureRequests.DISABLED;
            if (httpServerEnabled) {
                remainingCount.incrementAndGet();
            }
            if (this.httpsOptions != null) {
                remainingCount.incrementAndGet();
            }
            if (this.domainSocketOptions != null) {
                remainingCount.incrementAndGet();
            }
            if (remainingCount.get() == 0) {
                startFuture.fail((Throwable)new IllegalArgumentException("Must configure at least one of http, https or unix domain socket"));
            }
            boolean bl2 = notifyStartObservers = (container = Arc.container()) != null ? this.startEventsFired.compareAndSet(false, true) : false;
            if (httpServerEnabled) {
                this.httpServer = this.vertx.createHttpServer(this.httpOptions);
                if (this.insecureRequests == HttpConfiguration.InsecureRequests.ENABLED) {
                    this.httpServer.requestHandler(ACTUAL_ROOT);
                } else {
                    this.httpServer.requestHandler((Handler)new Handler<HttpServerRequest>(){

                        public void handle(HttpServerRequest req) {
                            try {
                                String host = req.getHeader((CharSequence)HttpHeaderNames.HOST);
                                if (host == null) {
                                    req.response().setStatusCode(HttpResponseStatus.NOT_FOUND.code()).end();
                                } else {
                                    int includedPort = host.indexOf(":");
                                    if (includedPort != -1) {
                                        host = host.substring(0, includedPort);
                                    }
                                    req.response().setStatusCode(301).putHeader("Location", "https://" + host + ":" + httpsOptions.getPort() + req.uri()).end();
                                }
                            }
                            catch (Exception e) {
                                req.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).end();
                            }
                        }
                    });
                }
                this.setupTcpHttpServer(this.httpServer, this.httpOptions, false, startFuture, remainingCount, this.connectionCount, container, notifyStartObservers);
            }
            if (this.domainSocketOptions != null) {
                this.domainSocketServer = this.vertx.createHttpServer(this.domainSocketOptions);
                this.domainSocketServer.requestHandler(ACTUAL_ROOT);
                this.setupUnixDomainSocketHttpServer(this.domainSocketServer, this.domainSocketOptions, startFuture, remainingCount, container, notifyStartObservers);
            }
            if (this.httpsOptions != null) {
                this.httpsServer = this.vertx.createHttpServer(this.httpsOptions);
                this.httpsServer.requestHandler(ACTUAL_ROOT);
                this.setupTcpHttpServer(this.httpsServer, this.httpsOptions, true, startFuture, remainingCount, this.connectionCount, container, notifyStartObservers);
            }
        }

        private void setupUnixDomainSocketHttpServer(HttpServer httpServer, HttpServerOptions options, Promise<Void> startFuture, AtomicInteger remainingCount, ArcContainer container, boolean notifyStartObservers) {
            httpServer.listen(SocketAddress.domainSocketAddress((String)options.getHost()), event -> {
                if (event.succeeded()) {
                    if (notifyStartObservers) {
                        container.beanManager().getEvent().select(DomainSocketServerStart.class, new Annotation[0]).fireAsync((Object)new DomainSocketServerStart(options));
                    }
                    if (remainingCount.decrementAndGet() == 0) {
                        startFuture.complete(null);
                    }
                } else if (event.cause() != null && event.cause().getMessage() != null && event.cause().getMessage().contains("Permission denied")) {
                    startFuture.fail((Throwable)new IllegalStateException(String.format("Unable to bind to Unix domain socket (%s) as the application does not have the permission to write in the directory.", this.domainSocketOptions.getHost())));
                } else if (event.cause() instanceof IllegalArgumentException) {
                    startFuture.fail((Throwable)new IllegalArgumentException(String.format("Unable to bind to Unix domain socket. Consider adding the 'io.netty:%s' dependency. See the Quarkus Vert.x reference guide for more details.", Utils.isLinux() ? "netty-transport-native-epoll" : "netty-transport-native-kqueue")));
                } else {
                    startFuture.fail(event.cause());
                }
            });
        }

        private void setupTcpHttpServer(HttpServer httpServer, final HttpServerOptions options, final boolean https, final Promise<Void> startFuture, final AtomicInteger remainingCount, final AtomicInteger currentConnectionCount, final ArcContainer container, final boolean notifyStartObservers) {
            if (this.quarkusConfig.limits.maxConnections.isPresent() && this.quarkusConfig.limits.maxConnections.getAsInt() > 0) {
                final ExtendedQuarkusVertxHttpMetrics.ConnectionTracker tracker = this.vertx.isMetricsEnabled() ? ((ExtendedQuarkusVertxHttpMetrics)((VertxInternal)this.vertx).metricsSPI()).getHttpConnectionTracker() : ExtendedQuarkusVertxHttpMetrics.NOOP_CONNECTION_TRACKER;
                final int maxConnections = this.quarkusConfig.limits.maxConnections.getAsInt();
                tracker.initialize(maxConnections, currentConnectionCount);
                httpServer.connectionHandler((Handler)new Handler<HttpConnection>(){

                    public void handle(HttpConnection event) {
                        int current;
                        do {
                            if ((current = currentConnectionCount.get()) != maxConnections) continue;
                            LOGGER.debug((Object)"Rejecting connection as there are too many active connections");
                            tracker.onConnectionRejected();
                            event.close();
                            return;
                        } while (!currentConnectionCount.compareAndSet(current, current + 1));
                        event.closeHandler((Handler)new Handler<Void>(){

                            public void handle(Void event) {
                                LOGGER.debug((Object)"Connection closed");
                                currentConnectionCount.decrementAndGet();
                            }
                        });
                    }
                });
            }
            httpServer.listen(options.getPort(), options.getHost(), (Handler)new Handler<AsyncResult<HttpServer>>(){

                public void handle(AsyncResult<HttpServer> event) {
                    if (event.cause() != null) {
                        startFuture.fail(event.cause());
                    } else {
                        int actualPort = ((HttpServer)event.result()).actualPort();
                        if (https) {
                            actualHttpsPort = actualPort;
                            this.validateHttpPorts(actualHttpPort, actualHttpsPort);
                        } else {
                            actualHttpPort = actualPort;
                            this.validateHttpPorts(actualHttpPort, actualHttpsPort);
                        }
                        if (actualPort != options.getPort()) {
                            String schema;
                            if (https) {
                                clearHttpsProperty = true;
                                schema = "https";
                            } else {
                                clearHttpProperty = true;
                                actualHttpPort = actualPort;
                                schema = "http";
                            }
                            portSystemProperties = new PortSystemProperties();
                            portSystemProperties.set(schema, actualPort, launchMode);
                        }
                        if (https && quarkusConfig.ssl.certificate.reloadPeriod.isPresent()) {
                            try {
                                long l = TlsCertificateReloader.initCertReloadingAction(vertx, httpsServer, httpsOptions, quarkusConfig.ssl, registry, quarkusConfig.tlsConfigurationName);
                                if (l != -1L) {
                                    reloadingTasks.add(l);
                                }
                            }
                            catch (IllegalArgumentException e) {
                                startFuture.fail((Throwable)e);
                                return;
                            }
                        }
                        if (https) {
                            ((HttpCertificateUpdateEventListener)container.instance(HttpCertificateUpdateEventListener.class, new Annotation[0]).get()).register((HttpServer)event.result(), quarkusConfig.tlsConfigurationName.orElse("<default>"), "http server");
                        }
                        if (notifyStartObservers) {
                            Event startEvent = container.beanManager().getEvent();
                            if (https) {
                                startEvent.select(HttpsServerStart.class, new Annotation[0]).fireAsync((Object)new HttpsServerStart(options));
                            } else {
                                startEvent.select(HttpServerStart.class, new Annotation[0]).fireAsync((Object)new HttpServerStart(options));
                            }
                        }
                        if (remainingCount.decrementAndGet() == 0) {
                            startFuture.complete(null);
                        }
                    }
                }

                private void validateHttpPorts(int httpPort, int httpsPort) {
                    if (httpsPort == httpPort) {
                        startFuture.fail((Throwable)new IllegalArgumentException("Both http and https servers started on port " + httpPort));
                    }
                }
            });
        }

        public void stop(Promise<Void> stopFuture) {
            for (Long id : this.reloadingTasks) {
                TlsCertificateReloader.unschedule(this.vertx, id);
            }
            AtomicInteger remainingCount = new AtomicInteger(0);
            if (this.httpServer != null) {
                remainingCount.incrementAndGet();
            }
            if (this.httpsServer != null) {
                remainingCount.incrementAndGet();
            }
            if (this.domainSocketServer != null) {
                remainingCount.incrementAndGet();
            }
            Handler handleClose = event -> {
                if (remainingCount.decrementAndGet() == 0) {
                    String portPropertyName;
                    if (this.clearHttpProperty) {
                        portPropertyName = this.launchMode == LaunchMode.TEST ? "quarkus.http.test-port" : "quarkus.http.port";
                        System.clearProperty(portPropertyName);
                        if (this.launchMode.isDevOrTest()) {
                            System.clearProperty(this.propertyWithProfilePrefix(portPropertyName));
                        }
                    }
                    if (this.clearHttpsProperty) {
                        portPropertyName = this.launchMode == LaunchMode.TEST ? "quarkus.http.test-ssl-port" : "quarkus.http.ssl-port";
                        System.clearProperty(portPropertyName);
                        if (this.launchMode.isDevOrTest()) {
                            System.clearProperty(this.propertyWithProfilePrefix(portPropertyName));
                        }
                    }
                    if (this.portSystemProperties != null) {
                        this.portSystemProperties.restore();
                    }
                    stopFuture.complete();
                }
            };
            if (this.httpServer != null) {
                this.httpServer.close(handleClose);
            }
            if (this.httpsServer != null) {
                this.httpsServer.close(handleClose);
            }
            if (this.domainSocketServer != null) {
                this.domainSocketServer.close(handleClose);
            }
        }

        private String propertyWithProfilePrefix(String portPropertyName) {
            return "%" + this.launchMode.getDefaultProfile() + "." + portPropertyName;
        }

        public void beforeCheckpoint(Context<? extends Resource> context) throws Exception {
            Promise p = Promise.promise();
            this.stop((Promise<Void>)p);
            p.future().toCompletionStage().toCompletableFuture().get();
        }

        public void afterRestore(Context<? extends Resource> context) throws Exception {
            Promise p = Promise.promise();
            this.context.runOnContext(nil -> this.start((Promise<Void>)p));
            p.future().toCompletionStage().toCompletableFuture().get();
        }
    }
}

