/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.EvalContext;
import io.quarkus.qute.Evaluator;
import io.quarkus.qute.Expression;
import io.quarkus.qute.ExpressionImpl;
import io.quarkus.qute.Futures;
import io.quarkus.qute.NamespaceResolver;
import io.quarkus.qute.ResolutionContext;
import io.quarkus.qute.Resolver;
import io.quarkus.qute.Results;
import io.quarkus.qute.TemplateException;
import io.quarkus.qute.ValueResolver;
import io.quarkus.qute.WithPriority;
import io.smallrye.mutiny.Uni;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jboss.logging.Logger;

class EvaluatorImpl
implements Evaluator {
    private static final Logger LOGGER = Logger.getLogger(EvaluatorImpl.class);
    private final List<ValueResolver> resolvers;
    private final Map<String, List<NamespaceResolver>> namespaceResolvers;

    EvaluatorImpl(List<ValueResolver> valueResolvers, List<NamespaceResolver> namespaceResolvers) {
        this.resolvers = valueResolvers;
        HashMap<String, List<NamespaceResolver>> namespaceResolversMap = new HashMap<String, List<NamespaceResolver>>();
        for (NamespaceResolver namespaceResolver : namespaceResolvers) {
            ArrayList<NamespaceResolver> matching = (ArrayList<NamespaceResolver>)namespaceResolversMap.get(namespaceResolver.getNamespace());
            if (matching == null) {
                matching = new ArrayList<NamespaceResolver>();
                namespaceResolversMap.put(namespaceResolver.getNamespace(), matching);
            }
            matching.add(namespaceResolver);
        }
        for (Map.Entry entry : namespaceResolversMap.entrySet()) {
            List list = (List)entry.getValue();
            if (list.size() == 1) {
                entry.setValue(Collections.singletonList((NamespaceResolver)list.get(0)));
                continue;
            }
            list.sort(Comparator.comparingInt(WithPriority::getPriority).reversed());
        }
        this.namespaceResolvers = namespaceResolversMap;
    }

    @Override
    public CompletionStage<Object> evaluate(Expression expression, ResolutionContext resolutionContext) {
        if (expression.hasNamespace()) {
            Iterator<Expression.Part> parts = expression.getParts().iterator();
            List<NamespaceResolver> matching = this.namespaceResolvers.get(expression.getNamespace());
            if (matching == null) {
                String msg = "No namespace resolver found for: " + expression.getNamespace();
                LOGGER.errorf(msg, new Object[0]);
                return Futures.failure(new TemplateException(msg));
            }
            EvalContextImpl context = new EvalContextImpl(false, null, parts.next(), resolutionContext);
            if (matching.size() == 1) {
                return matching.get(0).resolve(context).thenCompose(r -> {
                    if (parts.hasNext()) {
                        return this.resolveReference(false, r, parts, resolutionContext);
                    }
                    return EvaluatorImpl.toCompletionStage(r);
                });
            }
            return this.resolveNamespace(context, resolutionContext, parts, matching.iterator());
        }
        if (expression.isLiteral()) {
            return expression.getLiteralValue();
        }
        Iterator<Expression.Part> parts = expression.getParts().iterator();
        return this.resolveReference(true, resolutionContext.getData(), parts, resolutionContext);
    }

    private CompletionStage<Object> resolveNamespace(EvalContext context, ResolutionContext resolutionContext, Iterator<Expression.Part> parts, Iterator<NamespaceResolver> resolvers) {
        NamespaceResolver resolver = resolvers.next();
        return resolver.resolve(context).thenCompose(r -> {
            if (Results.Result.NOT_FOUND.equals(r)) {
                if (resolvers.hasNext()) {
                    return this.resolveNamespace(context, resolutionContext, parts, resolvers);
                }
                return Results.NOT_FOUND;
            }
            if (parts.hasNext()) {
                return this.resolveReference(false, r, parts, resolutionContext);
            }
            return EvaluatorImpl.toCompletionStage(r);
        });
    }

    private CompletionStage<Object> resolveReference(boolean tryParent, Object ref, Iterator<Expression.Part> parts, ResolutionContext resolutionContext) {
        Expression.Part part = parts.next();
        EvalContextImpl evalContext = new EvalContextImpl(tryParent, ref, part, resolutionContext);
        if (!parts.hasNext()) {
            return this.resolve(evalContext, null, true);
        }
        return this.resolve(evalContext, null, true).thenCompose(r -> this.resolveReference(false, r, parts, resolutionContext));
    }

    private CompletionStage<Object> resolve(EvalContextImpl evalContext, Iterator<ValueResolver> resolvers, boolean tryCachedResolver) {
        ValueResolver cachedResolver;
        if (tryCachedResolver && (cachedResolver = evalContext.getCachedResolver()) != null && cachedResolver.appliesTo(evalContext)) {
            return cachedResolver.resolve(evalContext).thenCompose(r -> {
                if (Results.Result.NOT_FOUND.equals(r)) {
                    return this.resolve(evalContext, null, false);
                }
                return EvaluatorImpl.toCompletionStage(r);
            });
        }
        if (resolvers == null) {
            resolvers = this.resolvers.iterator();
        }
        Resolver applicableResolver = null;
        while (applicableResolver == null && resolvers.hasNext()) {
            ValueResolver next = resolvers.next();
            if (!next.appliesTo(evalContext)) continue;
            applicableResolver = next;
        }
        if (applicableResolver == null) {
            ResolutionContext parent = evalContext.resolutionContext.getParent();
            if (evalContext.tryParent && parent != null) {
                return this.resolve(new EvalContextImpl(true, parent.getData(), parent, evalContext.part), null, false);
            }
            LOGGER.tracef("Unable to resolve %s", (Object)evalContext);
            return Results.NOT_FOUND;
        }
        Iterator<ValueResolver> remainingResolvers = resolvers;
        Resolver foundResolver = applicableResolver;
        return applicableResolver.resolve(evalContext).thenCompose(arg_0 -> this.lambda$resolve$4(evalContext, remainingResolvers, (ValueResolver)foundResolver, arg_0));
    }

    private static CompletionStage<Object> toCompletionStage(Object result) {
        if (result instanceof CompletionStage) {
            return (CompletionStage)result;
        }
        if (result instanceof Uni) {
            return ((Uni)result).subscribeAsCompletionStage();
        }
        return CompletableFuture.completedFuture(result);
    }

    private /* synthetic */ CompletionStage lambda$resolve$4(EvalContextImpl evalContext, Iterator remainingResolvers, ValueResolver foundResolver, Object r) {
        if (Results.Result.NOT_FOUND.equals(r)) {
            return this.resolve(evalContext, remainingResolvers, false);
        }
        evalContext.setCachedResolver(foundResolver);
        return EvaluatorImpl.toCompletionStage(r);
    }

    static class EvalContextImpl
    implements EvalContext {
        final boolean tryParent;
        final Object base;
        final ResolutionContext resolutionContext;
        final ExpressionImpl.PartImpl part;
        final List<Expression> params;
        final String name;

        EvalContextImpl(boolean tryParent, Object base, Expression.Part part, ResolutionContext resolutionContext) {
            this(tryParent, base, resolutionContext, part);
        }

        EvalContextImpl(boolean tryParent, Object base, ResolutionContext resolutionContext, Expression.Part part) {
            this.tryParent = tryParent;
            this.base = base;
            this.resolutionContext = resolutionContext;
            this.part = (ExpressionImpl.PartImpl)part;
            this.name = part.getName();
            this.params = part.isVirtualMethod() ? part.asVirtualMethod().getParameters() : Collections.emptyList();
        }

        @Override
        public Object getBase() {
            return this.base;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public List<Expression> getParams() {
            return this.params;
        }

        @Override
        public CompletionStage<Object> evaluate(String value) {
            return this.evaluate(ExpressionImpl.from(value));
        }

        @Override
        public CompletionStage<Object> evaluate(Expression expression) {
            return this.resolutionContext.evaluate(expression);
        }

        @Override
        public Object getAttribute(String key) {
            return this.resolutionContext.getAttribute(key);
        }

        ValueResolver getCachedResolver() {
            return this.part.cachedResolver;
        }

        void setCachedResolver(ValueResolver valueResolver) {
            this.part.cachedResolver = valueResolver;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("EvalContextImpl [tryParent=").append(this.tryParent).append(", base=").append(this.base).append(", name=").append(this.getName()).append(", params=").append(this.getParams()).append("]");
            return builder.toString();
        }
    }
}

