/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import java.util.Locale;
import java.util.Objects;

public final class Variant {
    public static final String TEXT_HTML = "text/html";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String TEXT_XML = "text/xml";
    public static final String APPLICATION_JSON = "application/json";
    private final Locale locale;
    private final String contentType;
    private final String encoding;

    public static Variant forContentType(String contentType) {
        return new Variant(null, contentType, null);
    }

    public Variant(Locale locale, String contentType, String encoding) {
        this.locale = locale;
        this.contentType = contentType;
        this.encoding = encoding;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getMediaType() {
        return this.getContentType();
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int hashCode() {
        return Objects.hash(this.encoding, this.locale, this.contentType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Variant other = (Variant)obj;
        return Objects.equals(this.encoding, other.encoding) && Objects.equals(this.locale, other.locale) && Objects.equals(this.contentType, other.contentType);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Variant [locale=").append(this.locale).append(", contentType=").append(this.contentType).append(", encoding=").append(this.encoding).append("]");
        return builder.toString();
    }
}

