/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.CharReplacementResultMapper;
import io.quarkus.qute.RawString;
import io.quarkus.qute.TemplateNode;
import io.quarkus.qute.Variant;
import java.util.List;
import java.util.Optional;

public class HtmlEscaper
extends CharReplacementResultMapper {
    private final List<String> escapedContentTypes;

    public HtmlEscaper(List<String> escapedContentTypes) {
        this.escapedContentTypes = escapedContentTypes;
    }

    @Override
    public boolean appliesTo(TemplateNode.Origin origin, Object result) {
        if (result instanceof RawString) {
            return false;
        }
        Optional<Variant> variant = origin.getVariant();
        if (variant.isPresent()) {
            return this.requiresDefaultEscaping(variant.get());
        }
        return false;
    }

    private boolean requiresDefaultEscaping(Variant variant) {
        String contentType = variant.getContentType();
        if (contentType == null) {
            return false;
        }
        for (String escaped : this.escapedContentTypes) {
            if (!contentType.startsWith(escaped)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String replacementFor(char c) {
        switch (c) {
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return "&#39;";
            }
            case '&': {
                return "&amp;";
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
        }
        return null;
    }
}

