/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Booleans;
import io.quarkus.qute.CompletedStage;
import io.quarkus.qute.ErrorCode;
import io.quarkus.qute.ErrorInitializer;
import io.quarkus.qute.Expression;
import io.quarkus.qute.ImmutableList;
import io.quarkus.qute.Parser;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.Results;
import io.quarkus.qute.Scope;
import io.quarkus.qute.SectionBlock;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.TemplateException;
import io.quarkus.qute.WithOrigin;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.concurrent.CompletionStage;

public class IfSectionHelper
implements SectionHelper {
    private static final String ELSE = "else";
    private static final String IF = "if";
    private static final String LOGICAL_COMPLEMENT = "!";
    private final IfContext ifContext;

    IfSectionHelper(SectionHelperFactory.SectionInitContext context) {
        ArrayList<ConditionBlock> conditionBlocks = new ArrayList<ConditionBlock>();
        for (SectionBlock block : context.getBlocks()) {
            if (!"$main".equals(block.label) && !ELSE.equals(block.label)) continue;
            conditionBlocks.add(new ConditionBlock(block, context));
        }
        this.ifContext = conditionBlocks.size() == 1 ? new SingletonContext((ConditionBlock)conditionBlocks.get(0)) : (conditionBlocks.size() == 2 ? new DoubletonContext((ConditionBlock)conditionBlocks.get(0), (ConditionBlock)conditionBlocks.get(1)) : new ListContext(ImmutableList.copyOf(conditionBlocks)));
    }

    @Override
    public CompletionStage<ResultNode> resolve(SectionHelper.SectionResolutionContext context) {
        return this.ifContext.resolve(context);
    }

    static <B extends ErrorInitializer & WithOrigin> List<Object> parseParams(List<Object> params, B block) {
        IfSectionHelper.replaceOperatorsAndCompositeParams(params, block);
        int highestPrecedence = IfSectionHelper.getHighestPrecedence(params);
        if (!IfSectionHelper.isGroupingNeeded(params)) {
            return params;
        }
        ArrayList<Object> highestGroup = null;
        ArrayList<Object> ret = new ArrayList<Object>();
        int lastGroupdIdx = 0;
        ListIterator<Object> iterator = params.listIterator();
        while (iterator.hasNext()) {
            int prevIdx = iterator.previousIndex();
            Object param = iterator.next();
            if (param instanceof Operator) {
                Operator op = (Operator)((Object)param);
                if (op.precedence == highestPrecedence) {
                    if (highestGroup == null) {
                        highestGroup = new ArrayList<Object>();
                        if (op.isBinary()) {
                            highestGroup.add(params.get(prevIdx));
                        }
                    }
                    highestGroup.add(param);
                    if (prevIdx <= lastGroupdIdx) continue;
                    int from = lastGroupdIdx > 0 ? lastGroupdIdx + 1 : 0;
                    int to = op.isBinary() ? prevIdx : prevIdx + 1;
                    ret.addAll(params.subList(from, to));
                    continue;
                }
                if (op.precedence < highestPrecedence) {
                    if (highestGroup == null) continue;
                    ret.add(highestGroup);
                    lastGroupdIdx = prevIdx;
                    highestGroup = null;
                    continue;
                }
                throw new IllegalStateException();
            }
            if (highestGroup == null) continue;
            highestGroup.add(param);
        }
        if (highestGroup != null) {
            ret.add(highestGroup);
        } else if (lastGroupdIdx + 1 != params.size()) {
            ret.addAll(params.subList(lastGroupdIdx + 1, params.size()));
        }
        return IfSectionHelper.parseParams(ret, block);
    }

    private static boolean isGroupingNeeded(List<Object> params) {
        Integer lastPrecedence = null;
        for (Object param : params) {
            if (!(param instanceof Operator)) continue;
            Operator op = (Operator)((Object)param);
            if (lastPrecedence == null) {
                lastPrecedence = op.getPrecedence();
                continue;
            }
            if (lastPrecedence.equals(op.getPrecedence())) continue;
            return true;
        }
        return false;
    }

    private static <B extends ErrorInitializer & WithOrigin> void replaceOperatorsAndCompositeParams(List<Object> params, B block) {
        ListIterator<Object> iterator = params.listIterator();
        while (iterator.hasNext()) {
            Object param = iterator.next();
            if (!(param instanceof String)) continue;
            String stringParam = param.toString();
            Operator operator = Operator.from(stringParam);
            if (operator != null) {
                if (operator.isBinary() && !iterator.hasNext()) {
                    throw block.error("binary operator [{operator}] set but the second operand not present for \\{#if\\} section").argument("operator", (Object)operator).code(Code.BINARY_OPERATOR_MISSING_SECOND_OPERAND).origin(((WithOrigin)block).getOrigin()).build();
                }
                iterator.set((Object)operator);
                continue;
            }
            if (stringParam.length() > 1 && stringParam.startsWith(LOGICAL_COMPLEMENT)) {
                iterator.set((Object)Operator.NOT);
                stringParam = stringParam.substring(1);
                if (stringParam.charAt(0) == '(') {
                    iterator.add(IfSectionHelper.processCompositeParam(stringParam, block));
                    continue;
                }
                iterator.add(stringParam);
                continue;
            }
            if (stringParam.charAt(0) != '(') continue;
            iterator.set(IfSectionHelper.processCompositeParam(stringParam, block));
        }
    }

    private static int getHighestPrecedence(List<Object> params) {
        int highestPrecedence = 0;
        for (Object param : params) {
            if (!(param instanceof Operator)) continue;
            Operator op = (Operator)((Object)param);
            if (op.precedence <= highestPrecedence) continue;
            highestPrecedence = op.precedence;
        }
        return highestPrecedence;
    }

    static <B extends ErrorInitializer & WithOrigin> List<Object> processCompositeParam(String stringParam, B block) {
        if (!stringParam.endsWith(")")) {
            throw new TemplateException("Invalid composite parameter found: " + stringParam);
        }
        ArrayList<Object> split = new ArrayList<Object>();
        Parser.splitSectionParams(stringParam.substring(1, stringParam.length() - 1), block).forEachRemaining(split::add);
        return IfSectionHelper.parseParams(split, block);
    }

    static Condition createCondition(Object param, SectionBlock block, Operator operator, SectionHelperFactory.SectionInitContext context) {
        Condition condition;
        if (param instanceof String) {
            Expression expr;
            String stringParam = param.toString();
            boolean logicalComplement = stringParam.startsWith(LOGICAL_COMPLEMENT);
            if (logicalComplement) {
                stringParam = stringParam.substring(1);
            }
            if ((expr = block.expressions.get(stringParam)) == null) {
                throw new TemplateException("Expression not found for param [" + stringParam + "]: " + block);
            }
            condition = new OperandCondition(operator, expr);
        } else if (param instanceof List) {
            List params = (List)param;
            if (params.size() == 1) {
                return IfSectionHelper.createCondition(params.get(0), block, operator, context);
            }
            ArrayList<Condition> conditions = new ArrayList<Condition>();
            Operator nextOperator = null;
            for (Object p : params) {
                if (p instanceof Operator) {
                    nextOperator = (Operator)((Object)p);
                    continue;
                }
                conditions.add(IfSectionHelper.createCondition(p, block, nextOperator, context));
                nextOperator = null;
            }
            condition = operator == null && conditions.size() == 1 ? (Condition)conditions.get(0) : new CompositeCondition(operator, ImmutableList.copyOf(conditions));
        } else {
            throw new TemplateException("Unsupported param type: " + param);
        }
        return condition;
    }

    static enum Code implements ErrorCode
    {
        BINARY_OPERATOR_MISSING_SECOND_OPERAND;


        @Override
        public String getName() {
            return "IF_" + this.name();
        }
    }

    static enum Operator {
        EQ(2, "eq", "==", "is"),
        NE(2, "ne", "!="),
        GT(3, "gt", ">"),
        GE(3, "ge", ">="),
        LE(3, "le", "<="),
        LT(3, "lt", "<"),
        AND(1, "and", "&&"),
        OR(1, "or", "||"),
        NOT(4, "!");

        private final List<String> aliases;
        private final int precedence;

        private Operator(int precedence, String ... aliases) {
            this.aliases = List.of(aliases);
            this.precedence = precedence;
        }

        int getPrecedence() {
            return this.precedence;
        }

        boolean evaluate(Object op1, Object op2) {
            switch (this) {
                case EQ: {
                    return Objects.equals(op1, op2);
                }
                case NE: {
                    return !Objects.equals(op1, op2);
                }
                case GE: 
                case GT: 
                case LE: 
                case LT: {
                    return this.compare(op1, op2);
                }
                case AND: 
                case OR: {
                    return !Booleans.isFalsy(op2);
                }
            }
            throw new TemplateException("Not a binary operator: " + this);
        }

        boolean compare(Object op1, Object op2) {
            Comparable<BigDecimal> c2;
            Comparable<BigDecimal> c1;
            if (op1 == null || op2 == null) {
                throw new TemplateException("Unable to compare null operands [op1=" + op1 + ", op2=" + op2 + "]");
            }
            if (op1 instanceof Comparable && op1.getClass().equals(op2.getClass())) {
                c1 = (Comparable)op1;
                c2 = (Comparable)op2;
            } else {
                c1 = Operator.getDecimal(op1);
                c2 = Operator.getDecimal(op2);
            }
            int result = c1.compareTo((BigDecimal)c2);
            switch (this) {
                case GE: {
                    return result >= 0;
                }
                case GT: {
                    return result > 0;
                }
                case LE: {
                    return result <= 0;
                }
                case LT: {
                    return result < 0;
                }
            }
            return false;
        }

        Boolean evaluate(Object op1) {
            switch (this) {
                case AND: {
                    return Booleans.isFalsy(op1) ? Boolean.FALSE : null;
                }
                case OR: {
                    return Booleans.isFalsy(op1) ? null : Boolean.TRUE;
                }
            }
            throw new TemplateException("Not a short-circuiting operator: " + this);
        }

        boolean isShortCircuiting() {
            return AND.equals((Object)this) || OR.equals((Object)this);
        }

        boolean isBinary() {
            return !NOT.equals((Object)this);
        }

        static Operator from(String value) {
            if (value == null || value.isEmpty()) {
                return null;
            }
            for (Operator operator : Operator.values()) {
                if (!operator.aliases.contains(value)) continue;
                return operator;
            }
            return null;
        }

        static BigDecimal getDecimal(Object value) {
            BigDecimal decimal;
            if (value instanceof BigDecimal) {
                decimal = (BigDecimal)value;
            } else if (value instanceof BigInteger) {
                decimal = new BigDecimal((BigInteger)value);
            } else if (value instanceof Integer) {
                decimal = new BigDecimal((Integer)value);
            } else if (value instanceof Long) {
                decimal = new BigDecimal((Long)value);
            } else if (value instanceof Double) {
                decimal = new BigDecimal((Double)value);
            } else if (value instanceof Float) {
                decimal = new BigDecimal(((Float)value).floatValue());
            } else if (value instanceof String) {
                decimal = new BigDecimal(value.toString());
            } else {
                throw new TemplateException("Not a valid number: " + value);
            }
            return decimal;
        }
    }

    static class CompositeCondition
    implements Condition {
        final List<Condition> conditions;
        final Operator operator;

        public CompositeCondition(Operator operator, List<Condition> conditions) {
            this.operator = operator;
            this.conditions = conditions;
        }

        @Override
        public CompletionStage<Object> evaluate(SectionHelper.SectionResolutionContext context) {
            CompletionStage<Object> ret = this.evaluateNext(context, null, this.conditions.iterator());
            if (this.operator == Operator.NOT) {
                return ret.thenApply(this::logicalComplement);
            }
            return ret;
        }

        CompletionStage<Object> evaluateNext(SectionHelper.SectionResolutionContext context, Object previousValue, Iterator<Condition> iter) {
            Condition next = iter.next();
            Boolean shortResult = null;
            Operator operator = next.getOperator();
            if (operator != null && operator.isShortCircuiting()) {
                shortResult = operator.evaluate(previousValue);
            }
            if (shortResult != null) {
                return CompletedStage.of(shortResult);
            }
            Object literalVal = next.getLiteralValue();
            if (literalVal != null) {
                if (operator == Operator.NOT) {
                    literalVal = this.logicalComplement(literalVal);
                }
                return this.processConditionValue(context, operator, previousValue, literalVal, iter);
            }
            CompletionStage<Object> ret = next.evaluate(context);
            if (ret instanceof CompletedStage) {
                return this.processConditionValue(context, operator, previousValue, ((CompletedStage)ret).get(), iter);
            }
            return ret.thenCompose(r -> this.processConditionValue(context, operator, previousValue, r, iter));
        }

        @Override
        public Operator getOperator() {
            return this.operator;
        }

        @Override
        public boolean isEmpty() {
            return this.conditions.isEmpty();
        }

        public String toString() {
            return "CompositeCondition [conditions=" + this.conditions.size() + ", operator=" + this.operator + "]";
        }

        CompletionStage<Object> processConditionValue(SectionHelper.SectionResolutionContext context, Operator operator, Object previousValue, Object conditionValue, Iterator<Condition> iter) {
            Object val;
            if (operator == null || !operator.isBinary()) {
                val = conditionValue;
            } else {
                try {
                    Object localValue;
                    if (Results.isNotFound(conditionValue)) {
                        conditionValue = null;
                    }
                    if (Results.isNotFound(localValue = previousValue)) {
                        localValue = null;
                    }
                    val = operator.evaluate(localValue, conditionValue);
                }
                catch (Throwable e) {
                    return CompletedStage.failure(e);
                }
            }
            if (!iter.hasNext()) {
                return CompletedStage.of(val);
            }
            return this.evaluateNext(context, val, iter);
        }
    }

    static class OperandCondition
    implements Condition {
        final Operator operator;
        final Expression expression;
        final Object literalValue;

        OperandCondition(Operator operator, Expression expression) {
            this.operator = operator;
            this.expression = expression;
            this.literalValue = expression.getLiteral();
        }

        @Override
        public CompletionStage<Object> evaluate(SectionHelper.SectionResolutionContext context) {
            CompletionStage<Object> ret = context.resolutionContext().evaluate(this.expression);
            if (this.operator == Operator.NOT) {
                return ret.thenApply(this::logicalComplement);
            }
            return ret;
        }

        @Override
        public Operator getOperator() {
            return this.operator;
        }

        @Override
        public Object getLiteralValue() {
            return this.literalValue;
        }

        public String toString() {
            return "OperandCondition [operator=" + this.operator + ", expression=" + this.expression.toOriginalString() + "]";
        }
    }

    static interface Condition {
        public CompletionStage<Object> evaluate(SectionHelper.SectionResolutionContext var1);

        public Operator getOperator();

        default public boolean isEmpty() {
            return false;
        }

        default public Object getLiteralValue() {
            return null;
        }

        default public Boolean logicalComplement(Object val) {
            return Booleans.isFalsy(val) ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    static class ConditionBlock {
        final SectionBlock section;
        final Condition condition;

        public ConditionBlock(SectionBlock block, SectionHelperFactory.SectionInitContext context) {
            this.section = block;
            List<Object> params = IfSectionHelper.parseParams(new ArrayList<Object>(block.parameters.values()), block);
            if (!params.isEmpty() && !"$main".equals(block.label)) {
                params = params.subList(1, params.size());
            }
            this.condition = IfSectionHelper.createCondition(params, block, null, context);
        }
    }

    public static class Factory
    implements SectionHelperFactory<IfSectionHelper> {
        @Override
        public List<String> getDefaultAliases() {
            return ImmutableList.of(IfSectionHelper.IF);
        }

        @Override
        public SectionHelperFactory.ParametersInfo getParameters() {
            return SectionHelperFactory.ParametersInfo.builder().checkNumberOfParams(false).addParameter("condition").build();
        }

        @Override
        public List<String> getBlockLabels() {
            return ImmutableList.of(IfSectionHelper.ELSE);
        }

        @Override
        public IfSectionHelper initialize(SectionHelperFactory.SectionInitContext context) {
            return new IfSectionHelper(context);
        }

        @Override
        public Scope initializeBlock(Scope previousScope, SectionHelperFactory.BlockInfo block) {
            List<Object> params = null;
            if ("$main".equals(block.getLabel())) {
                params = IfSectionHelper.parseParams(new ArrayList<Object>(block.getParameters().values()), block);
            } else if (IfSectionHelper.ELSE.equals(block.getLabel()) && !(params = IfSectionHelper.parseParams(new ArrayList<Object>(block.getParameters().values()), block)).isEmpty()) {
                params.remove(0);
            }
            this.addExpressions(params, block);
            return previousScope;
        }

        private void addExpressions(List<Object> params, SectionHelperFactory.BlockInfo block) {
            if (params != null && !params.isEmpty()) {
                for (Object param : params) {
                    if (param instanceof String) {
                        block.addExpression(param.toString(), param.toString());
                        continue;
                    }
                    if (!(param instanceof List)) continue;
                    this.addExpressions((List)param, block);
                }
            }
        }
    }

    static final class ListContext
    implements IfContext {
        private final List<ConditionBlock> blocks;

        ListContext(List<ConditionBlock> blocks) {
            this.blocks = blocks;
        }

        @Override
        public CompletionStage<ResultNode> resolve(SectionHelper.SectionResolutionContext context) {
            return this.resolveBlocks(context, this.blocks.iterator());
        }

        private CompletionStage<ResultNode> resolveBlocks(SectionHelper.SectionResolutionContext context, Iterator<ConditionBlock> blocks) {
            ConditionBlock block = blocks.next();
            if (block.condition.isEmpty()) {
                return context.execute(block.section, context.resolutionContext());
            }
            return block.condition.evaluate(context).thenCompose(r -> {
                if (Booleans.isFalsy(r)) {
                    if (blocks.hasNext()) {
                        return this.resolveBlocks(context, blocks);
                    }
                    return ResultNode.NOOP;
                }
                return context.execute(block.section, context.resolutionContext());
            });
        }
    }

    static final class DoubletonContext
    implements IfContext {
        private final ConditionBlock block;
        private final ConditionBlock next;

        public DoubletonContext(ConditionBlock block, ConditionBlock next) {
            this.block = block;
            this.next = next;
        }

        @Override
        public CompletionStage<ResultNode> resolve(SectionHelper.SectionResolutionContext context) {
            return this.block.condition.evaluate(context).thenCompose(r -> {
                if (Booleans.isFalsy(r)) {
                    if (this.next.condition.isEmpty()) {
                        return context.execute(this.next.section, context.resolutionContext());
                    }
                    return this.next.condition.evaluate(context).thenCompose(nr -> {
                        if (Booleans.isFalsy(nr)) {
                            return ResultNode.NOOP;
                        }
                        return context.execute(this.next.section, context.resolutionContext());
                    });
                }
                return context.execute(this.block.section, context.resolutionContext());
            });
        }
    }

    static final class SingletonContext
    implements IfContext {
        private final ConditionBlock block;

        SingletonContext(ConditionBlock block) {
            this.block = block;
        }

        @Override
        public CompletionStage<ResultNode> resolve(SectionHelper.SectionResolutionContext context) {
            return this.block.condition.evaluate(context).thenCompose(r -> {
                if (Booleans.isFalsy(r)) {
                    return ResultNode.NOOP;
                }
                return context.execute(this.block.section, context.resolutionContext());
            });
        }
    }

    static interface IfContext {
        public CompletionStage<ResultNode> resolve(SectionHelper.SectionResolutionContext var1);
    }
}

