/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.ErrorCode;
import io.quarkus.qute.ImmutableList;
import io.quarkus.qute.ResolutionContext;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.SectionBlock;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.TemplateNode;
import java.util.List;
import java.util.concurrent.CompletionStage;

public class InsertSectionHelper
implements SectionHelper {
    private final String name;
    private final SectionBlock defaultBlock;

    public InsertSectionHelper(String name, SectionBlock defaultBlock) {
        this.name = name;
        this.defaultBlock = defaultBlock;
    }

    @Override
    public CompletionStage<ResultNode> resolve(SectionHelper.SectionResolutionContext context) {
        SectionBlock extending;
        ResolutionContext rc = this.findParentResolutionContext(context.resolutionContext());
        if (rc == null) {
            rc = context.resolutionContext();
        }
        if ((extending = rc.getExtendingBlock(this.name)) != null) {
            return context.execute(extending, rc);
        }
        return context.execute(this.defaultBlock, rc);
    }

    private ResolutionContext findParentResolutionContext(ResolutionContext context) {
        if (context.getParent() == null) {
            return null;
        }
        SectionBlock block = context.getCurrentExtendingBlock(this.name);
        if (block != null && block.findNode(this::containsThisHelperInstance) != null) {
            return context.getParent();
        }
        return this.findParentResolutionContext(context.getParent());
    }

    private boolean containsThisHelperInstance(TemplateNode node) {
        return node.isSection() && node.asSection().helper == this;
    }

    static enum Code implements ErrorCode
    {
        INSERT_SECTION_CONFLICT;


        @Override
        public String getName() {
            return "INSERT_" + this.name();
        }
    }

    public static class Factory
    implements SectionHelperFactory<InsertSectionHelper> {
        @Override
        public List<String> getDefaultAliases() {
            return ImmutableList.of("insert");
        }

        @Override
        public SectionHelperFactory.ParametersInfo getParameters() {
            return SectionHelperFactory.ParametersInfo.builder().addParameter("name", "$default$").build();
        }

        @Override
        public InsertSectionHelper initialize(SectionHelperFactory.SectionInitContext context) {
            String name = context.getParameter("name");
            if (context.getEngine().getSectionHelperFactories().containsKey(name)) {
                throw context.error("\\{#insert} defined in the \\{#include\\} conflicts with an existing section/tag: {name}").code(Code.INSERT_SECTION_CONFLICT).argument("name", name).origin(context.getOrigin()).build();
            }
            return new InsertSectionHelper(name, context.getBlocks().get(0));
        }
    }
}

