/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl;

import io.vertx.core.Future;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.RequestOptions;
import jakarta.ws.rs.core.Response;
import java.util.function.Function;
import org.jboss.resteasy.reactive.client.handlers.AdvancedRedirectHandler;
import org.jboss.resteasy.reactive.client.impl.RedirectUtil;

class WrapperVertxAdvancedRedirectHandlerImpl
implements Function<HttpClientResponse, Future<RequestOptions>> {
    private final AdvancedRedirectHandler redirectHandler;

    WrapperVertxAdvancedRedirectHandlerImpl(AdvancedRedirectHandler redirectHandler) {
        this.redirectHandler = redirectHandler;
    }

    @Override
    public Future<RequestOptions> apply(HttpClientResponse httpClientResponse) {
        Response jaxRsResponse = RedirectUtil.toResponse(httpClientResponse);
        RequestOptions result = this.redirectHandler.handle(new AdvancedRedirectHandler.Context(jaxRsResponse, httpClientResponse.request()));
        if (result != null) {
            return Future.succeededFuture((Object)result);
        }
        return null;
    }
}

