/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.vertx.serializers;

import io.vertx.mutiny.core.file.AsyncFile;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveResourceInfo;
import org.jboss.resteasy.reactive.server.spi.ServerHttpResponse;
import org.jboss.resteasy.reactive.server.spi.ServerMessageBodyWriter;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;

@Provider
public class ServerMutinyAsyncFileMessageBodyWriter
implements ServerMessageBodyWriter<AsyncFile> {
    public boolean isWriteable(Class<?> type, Type genericType, ResteasyReactiveResourceInfo target, MediaType mediaType) {
        return this.isWritable(type);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isWritable(type);
    }

    private boolean isWritable(Class<?> type) {
        return AsyncFile.class.isAssignableFrom(type);
    }

    public void writeResponse(final AsyncFile file, Type genericType, ServerRequestContext context) throws WebApplicationException {
        final ResteasyReactiveRequestContext ctx = (ResteasyReactiveRequestContext)context;
        ctx.suspend();
        final ServerHttpResponse response = context.serverResponse();
        if (file.getReadLength() != Long.MAX_VALUE) {
            response.setResponseHeader((CharSequence)"Content-Length", (CharSequence)String.valueOf(file.getReadLength()));
        } else {
            response.setChunked(true);
        }
        file.handler(buffer -> {
            try {
                response.write(buffer.getBytes());
            }
            catch (Exception x) {
                ctx.resume((Throwable)x);
                return;
            }
            if (response.isWriteQueueFull()) {
                file.pause();
                response.addDrainHandler(() -> ((AsyncFile)file).resume());
            }
        });
        file.endHandler(new Runnable(){

            @Override
            public void run() {
                file.close().subscribeAsCompletionStage();
                response.end();
                ctx.resume();
            }
        });
    }

    public void writeTo(AsyncFile asyncFile, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        throw new UnsupportedOperationException("Returning an AsyncFile is not supported with WriterInterceptors");
    }
}

