/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.h2.codecs;

import io.r2dbc.h2.client.Client;
import io.r2dbc.h2.codecs.AbstractCodec;
import io.r2dbc.h2.codecs.ByteBufferInputStream;
import io.r2dbc.h2.codecs.ValueLobBlob;
import io.r2dbc.h2.util.Assert;
import io.r2dbc.spi.Blob;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Enumeration;
import java.util.Iterator;
import org.h2.value.Value;
import org.h2.value.ValueBlob;
import org.h2.value.ValueLob;
import org.h2.value.ValueNull;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

final class BlobCodec
extends AbstractCodec<Blob> {
    private final Client client;

    BlobCodec(Client client) {
        super(Blob.class);
        this.client = client;
    }

    @Override
    boolean doCanDecode(int dataType) {
        return dataType == 7;
    }

    @Override
    Blob doDecode(Value value, Class<? extends Blob> type) {
        if (value == null || value instanceof ValueNull) {
            return null;
        }
        return new ValueLobBlob(value);
    }

    @Override
    Value doEncode(Blob value) {
        Assert.requireNonNull(value, "value must not be null");
        ValueBlob blob = this.client.getSession().getDataHandler().getLobStorage().createBlob((InputStream)new SequenceInputStream(new BlobInputStreamEnumeration(value)), -1L);
        this.client.getSession().addTemporaryLob((ValueLob)blob);
        return blob;
    }

    private final class BlobInputStreamEnumeration
    implements Enumeration<InputStream> {
        private final Iterator<ByteBufferInputStream> inputStreams;

        BlobInputStreamEnumeration(Blob value) {
            this.inputStreams = Flux.from((Publisher)value.stream()).map(ByteBufferInputStream::new).subscribeOn(Schedulers.elastic()).cancelOn(Schedulers.elastic()).toIterable().iterator();
        }

        @Override
        public boolean hasMoreElements() {
            return this.inputStreams.hasNext();
        }

        @Override
        public InputStream nextElement() {
            return this.inputStreams.next();
        }
    }
}

