/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql;

import io.netty.util.ReferenceCountUtil;
import io.r2dbc.mssql.ExceptionFactory;
import io.r2dbc.mssql.MssqlResult;
import io.r2dbc.mssql.MssqlReturnValues;
import io.r2dbc.mssql.MssqlRow;
import io.r2dbc.mssql.MssqlRowMetadata;
import io.r2dbc.mssql.MssqlSegmentResult;
import io.r2dbc.mssql.client.ConnectionContext;
import io.r2dbc.mssql.codec.Codecs;
import io.r2dbc.mssql.message.Message;
import io.r2dbc.mssql.message.token.AbstractDoneToken;
import io.r2dbc.mssql.message.token.ColumnMetadataToken;
import io.r2dbc.mssql.message.token.ErrorToken;
import io.r2dbc.mssql.message.token.NbcRowToken;
import io.r2dbc.mssql.message.token.ReturnValue;
import io.r2dbc.mssql.message.token.RowToken;
import io.r2dbc.mssql.util.Assert;
import io.r2dbc.spi.Readable;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.Logger;
import reactor.util.Loggers;

final class DefaultMssqlResult
implements MssqlResult {
    private static final Logger LOGGER = Loggers.getLogger(DefaultMssqlResult.class);
    public static final boolean DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private final String sql;
    private final ConnectionContext context;
    private final Codecs codecs;
    private final Flux<Message> messages;
    private final boolean expectReturnValues;
    private volatile MssqlRowMetadata rowMetadata;

    private DefaultMssqlResult(String sql, ConnectionContext context, Codecs codecs, Flux<Message> messages, boolean expectReturnValues) {
        this.sql = sql;
        this.context = context;
        this.codecs = codecs;
        this.messages = messages;
        this.expectReturnValues = expectReturnValues;
    }

    static MssqlResult toResult(String sql, ConnectionContext context, Codecs codecs, Flux<Message> messages, boolean expectReturnValues) {
        Assert.requireNonNull(sql, "SQL must not be null");
        Assert.requireNonNull(codecs, "Codecs must not be null");
        Assert.requireNonNull(context, "ConnectionContext must not be null");
        Assert.requireNonNull(messages, "Messages must not be null");
        LOGGER.debug(context.getMessage("Creating new result"));
        return new DefaultMssqlResult(sql, context, codecs, messages, expectReturnValues);
    }

    @Override
    public Mono<Long> getRowsUpdated() {
        return this.messages.handle((message, sink) -> {
            if (message instanceof AbstractDoneToken) {
                AbstractDoneToken doneToken = (AbstractDoneToken)message;
                if (doneToken.hasCount()) {
                    if (DEBUG_ENABLED) {
                        LOGGER.debug(this.context.getMessage("Incoming row count: {}"), new Object[]{doneToken});
                    }
                    sink.next((Object)doneToken.getRowCount());
                }
                if (doneToken.isAttentionAck()) {
                    sink.error((Throwable)((Object)new ExceptionFactory.MssqlStatementCancelled(this.sql)));
                    return;
                }
            }
            if (message instanceof ErrorToken) {
                sink.error((Throwable)ExceptionFactory.createException((ErrorToken)message, this.sql));
                return;
            }
            ReferenceCountUtil.release((Object)message);
        }).reduce(Long::sum);
    }

    @Override
    public <T> Flux<T> map(BiFunction<Row, RowMetadata, ? extends T> mappingFunction) {
        Assert.requireNonNull(mappingFunction, "Mapping function must not be null");
        return this.doMap(true, false, readable -> {
            Row row = (Row)readable;
            return mappingFunction.apply(row, row.getMetadata());
        });
    }

    public <T> Publisher<T> map(Function<? super Readable, ? extends T> mappingFunction) {
        Assert.requireNonNull(mappingFunction, "Mapping function must not be null");
        return this.doMap(true, true, mappingFunction);
    }

    private <T> Flux<T> doMap(boolean rows, boolean outparameters, Function<? super Readable, ? extends T> mappingFunction) {
        Flux mappedReturnValues = Flux.empty();
        Flux messages = this.messages;
        if (this.expectReturnValues && outparameters) {
            ArrayList returnValues = new ArrayList();
            messages = messages.doOnNext(message -> {
                if (message instanceof ReturnValue) {
                    returnValues.add((ReturnValue)message);
                }
            }).filter(it -> !(it instanceof ReturnValue));
            mappedReturnValues = Flux.defer(() -> {
                if (returnValues.size() != 0) {
                    MssqlReturnValues mssqlReturnValues = MssqlReturnValues.toReturnValues(this.codecs, returnValues);
                    try {
                        Flux flux = Flux.just(mappingFunction.apply((Readable)mssqlReturnValues));
                        return flux;
                    }
                    finally {
                        mssqlReturnValues.release();
                    }
                }
                return Flux.empty();
            });
        }
        Flux mapped = messages.handle((message, sink) -> {
            AbstractDoneToken doneToken;
            if (message instanceof AbstractDoneToken && (doneToken = (AbstractDoneToken)message).isAttentionAck()) {
                sink.error((Throwable)((Object)new ExceptionFactory.MssqlStatementCancelled(this.sql)));
                return;
            }
            if (message.getClass() == ColumnMetadataToken.class) {
                ColumnMetadataToken token = (ColumnMetadataToken)message;
                if (!token.hasColumns()) {
                    return;
                }
                if (DEBUG_ENABLED) {
                    LOGGER.debug(this.context.getMessage("Result column definition: {}"), new Object[]{message});
                }
                this.rowMetadata = MssqlRowMetadata.create(this.codecs, token);
                return;
            }
            if (rows && (message.getClass() == RowToken.class || message.getClass() == NbcRowToken.class)) {
                MssqlRowMetadata rowMetadata = this.rowMetadata;
                if (rowMetadata == null) {
                    sink.error((Throwable)new IllegalStateException("No MssqlRowMetadata available"));
                    return;
                }
                MssqlRow row = MssqlRow.toRow(this.codecs, (RowToken)message, rowMetadata);
                try {
                    sink.next(mappingFunction.apply((Readable)row));
                }
                finally {
                    row.release();
                }
                return;
            }
            if (message instanceof ErrorToken) {
                sink.error((Throwable)ExceptionFactory.createException((ErrorToken)message, this.sql));
                return;
            }
            if (this.expectReturnValues && message instanceof ReturnValue) {
                return;
            }
            ReferenceCountUtil.release((Object)message);
        });
        if (this.expectReturnValues) {
            mapped = mapped.concatWith((Publisher)mappedReturnValues);
        }
        return mapped;
    }

    @Override
    public MssqlResult filter(Predicate<Result.Segment> filter) {
        return MssqlSegmentResult.toResult(this.sql, this.context, this.codecs, this.messages, this.expectReturnValues).filter((Predicate)filter);
    }

    @Override
    public <T> Flux<T> flatMap(Function<Result.Segment, ? extends Publisher<? extends T>> mappingFunction) {
        return MssqlSegmentResult.toResult(this.sql, this.context, this.codecs, this.messages, this.expectReturnValues).flatMap(mappingFunction);
    }
}

